/* ==========================================================================
*      : TextBox.h
*      : 
*    : 谡
*    : 2006-11-07
* ǻ :
*===========================================================================*/
#pragma once
#include "TextCtrl.h"
#include "UINodeData.h"

class cUITextLexerT;
class cScrollBar;
class cEditBox;
class cUIFuncTextNode;
class cUIFuncTextParam;
struct sInventory;

/// ũѹ ġ 
enum eScrollbarPosType
{
	eRIGHT_SCROLLBAR,
	eLEFT_SCROLLBAR,
};

/// ڿ 
class cTextBox : public cTextCtrl
{
public:
	cTextBox( eUINodeType type = eUINODE_TEXTBOX );
	virtual ~cTextBox();

	/// ؽƮ ڽ ִ    
	void Clear();
	
	/// ο  ߰ 
	int AddNewRow( LPCTSTR text, unsigned long textcolor );

	///   ߰
	void AddPasteRow( LPCTSTR text, unsigned long textcolor, bool autoNewline = false );

	///  ȹ ޼ ( οٿ    )
	void AddItemRow( bool newrow, unsigned long itemIndex, unsigned int slotIndex, LPCTSTR name, unsigned long nameColor );
	void AddItemRow( sInventory inventory, LPCTSTR name, unsigned long nameColor );

	/// ɼ ؽƮ ߰ ( npc_note, quest_note  )
	bool AddFucnText( const cUIFuncTextNode* textNode, cUIFuncTextParam* textParam );

	///   (   )
	void AddEmptyRow( unsigned int line );

	/// ش  ؽƮ 
	void UpdateRowText( int line, LPCTSTR text );

	/// ؽƮڽ  ִ  
	unsigned int GetMaxRowInPage();

	///  
	unsigned int GetRowHeight() const;

	/// ؽƮڽ  ȭ     
	void UpdateTextBox( bool add );

	/// ؽƮڽ Ÿ  ú
	/// ũѹ Y ġ  ( addh ŭ   )
	void SetScrollbar( unsigned int addh );

	/// ؽƮ ġ Ʒͷ  ( ÷װ)
	void SetDrawTextBottom( bool down );

	/// ؽƮԷ½ ũѹٸ ǾƷ 
	void SetScrollBottom( bool bottom );

protected:
	/// ̺Ʈ ó
	virtual bool HandleEvent( const cUIEvent& event );
	virtual void OnRender( cUIFontItemKeeper* pKeeper );   
	virtual void OnMouseMove( const cUIPos& pos );
	virtual void OnLButtonDown(const cUIPos& pos, bool ctrl, bool alt, bool );
	virtual void OnMouseWheel( const cUIPos& pos, int wheel );
	virtual void OnScrollbarMoved( const cUIPos& pos );
	virtual bool SetSkin( const cUINodeSkin* pskin );
	virtual void UpdateSkin();
	virtual void UpdateRect();

	/// ڽĻ
	bool OnCreate( cUINodeProperty* pproperty );

	/// ư  üũ 
	void CheckButtonEvent( unsigned int id );

	///  ϴ ũѹٸ ׷.
	void UpdateScrollBarButton();

	/// topindex  ũѹ ġ ȭ 
	void UpdateScrollBarPos();

	/// ؽƮ ǥ Ʈ 
	void UpdateText();

	/// Ľ
	bool ParseCommand( cUITextLexerT& lexer );

protected:
		/// ũ Ų  
    cString mScrollSkin;

	/// ũѹ
	cScrollBar* mpScrollBar;

	/// ؽƮ  ġ 
	int mTextPosX, mTextPosY, mNextPosY;

	/// ũѹٸ ġŸ (ؽƮڽ)
	eScrollbarPosType mScrollbarPosType;

	/// ؽƮ ġ Ʒ  
	bool mDrawTextBottom;

	///  ؽƮ Է½ ũѹ ġ 
	bool mScrollBottom;

	/// ũѹ   
	unsigned int mFixScrollH;

	/// ִ 
	unsigned int mMaxRowInPage;

	///  ̼
	unsigned int mRowHeight;

	/// ǥ  
	unsigned int mTopRowIdx;

	/// ڻ
	unsigned long mTextColor;
};

inline void cTextBox::SetDrawTextBottom( bool down )
{
	mDrawTextBottom = down;
}

inline void cTextBox::SetScrollBottom( bool bottom )
{
	mScrollBottom = bottom;
}

inline unsigned int cTextBox::GetRowHeight() const
{
	return mRowHeight;
}

inline unsigned int cTextBox::GetMaxRowInPage()
{
	mMaxRowInPage = (GetAbsoluteRect().GetHeight() / mRowHeight);
	return mMaxRowInPage;
}


//////////////////////////////////////////////////////////////////////////////////
class cTextBoxSkin : public cUINodeSkin
{
public:
	cTextBoxSkin( eUINodeType type = eUINODE_TEXTBOX );
	virtual ~cTextBoxSkin();
	/// ε
	virtual bool Load( cParser& parser );

public:
	/// ũѹٸ ʿ Ѱ  (ؽƮڽ )
	bool mScrollBarRightPos;

	/// ؽƮ ڽ   
	unsigned int mRowHeight;

	/// ؽƮڽ  ִ ִ 
	int mTotalMaxNum;

	/// ũ Ų  
	cString mScrollSkin;
};


