#include "Stdafx.h"
#include "TextCtrl.h"

#include "FontAgent.h"
#include "UIImage.h"

cTextCtrl::cTextCtrl( eUINodeType type )
: cUIWindow( type )
, mLine(0)
, mLineWidth(0)
, mMaxTextWidth(0)
, mTotalMaxNum(0)
, mDelCount(0)
{
	mTextQueue.Reserve( 60 );
}

cTextCtrl::~cTextCtrl()
{
	Clear();
}

/// ǻ : ü 
void cTextCtrl::Clear()
{
	sRowTextData* p = 0;
	for( unsigned int i = 0; i < mTextQueue.GetSize(); ++i )
	{
		p = (sRowTextData*)mTextQueue[i];
		if( p )
		{
			for( unsigned int b = 0; b < p->mColumes.GetSize(); ++b )
			{
				SAFE_DELETE( p->mColumes[b] );
			}
			p->mColumes.Clear();
			SAFE_DELETE(p);
		}
	}
	mTextQueue.Clear();

	mLine = 0;
	mLineWidth = 0;
	mDelCount = 0;
}

///
void cTextCtrl::AddEmptyRow( unsigned int line )
{
	mLineWidth = 0;

	///  ߰
	for( unsigned int i = 0; i < line; ++i )
		InsertRow( _T(""), mDefaultColor, 0, 0 );
}


/// ο  ߰
void cTextCtrl::AddNewRow( LPCTSTR str, unsigned long color, unsigned long itemIndex, unsigned int slotIndex )
{
	if( !str ) return;

	/// ڿ  ϱ
	unsigned int len = ::_tcslen( str );
	unsigned int width = FONTAGENT->GetTextExtent( cFontAgent::eFont_System, str, len );

	/// ˻  
	unsigned int cutWidth = 0;
	unsigned int cutlen = 0;
	unsigned int startIndex = 0;
	mLineWidth = 0;

	/// Կ ڿ
	TCHAR text[256] = {0,};
	LPTSTR newtext = text;
	::ZeroMemory( newtext, 256 );

	///  ũ ߶󳽴.
	while( cutlen < len )
	{
		///  ˻   ϱ
		cutlen++;
		cutWidth = FONTAGENT->GetTextExtent( cFontAgent::eFont_System, str + startIndex, cutlen );

		///  ڰ˻縦 Ѵ
		TCHAR temp[3] = {0,};
		::_tcsncpy( temp, &str[startIndex + cutlen], 2 );

		/// ͺȣ  ٳѱ
		if( ::_tcsncmp( temp, _T("\\n"), 2 ) == 0 )
		{
			/// 
			Sstrncpy( newtext, 256, str + startIndex, cutlen );
			InsertRow( newtext, color, itemIndex, slotIndex );

			///
			width -= cutWidth; 
			startIndex += cutlen + 2;
			len -= (cutlen + 2);
			cutWidth = 0;
			cutlen = 0;
		}
		///  ̰ ƽ ѱ 
		else if( cutlen > 0 && cutWidth > mMaxTextWidth )	
		{
			if( startIndex + cutlen > 1 )
			{
				/// UNICODE ϱ  ̸ 1 
				int minusWidth = FONTAGENT->GetTextExtent( cFontAgent::eFont_System, str + startIndex + cutlen - 1, 1 );
				cutWidth -= minusWidth;
				cutlen -= 1;
			}

			Sstrncpy( newtext, 256, str + startIndex, cutlen );
			InsertRow( newtext, color, itemIndex, slotIndex );

			mLineWidth += width;

			///
			width -= cutWidth;
			startIndex += cutlen;
			len -= cutlen;
			cutWidth = 0;
			cutlen = 0;
		}
	}

	if( len > 0 )
	{
		Sstrncpy( newtext, 256, str + startIndex, len );
		InsertRow( newtext, color, itemIndex, slotIndex );

		mLineWidth = width;
	}
	else if( len < 0 )
	{
		assert(0);
	}
}


/// ο Ͽ ߰
void cTextCtrl::AddPasteRow( bool autoNewline, LPCTSTR str, unsigned long color, unsigned long itemIndex, unsigned int slotIndex )
{
	if( !str ) return;

	unsigned int len = ::_tcslen( str );
	if( len == 0 )
		return;

	///  ο ٿ ϱ
	if( mLine > 0 )
	{
		mLine--;
	}

	/// ڿ  ϱ
	unsigned int width = FONTAGENT->GetTextExtent( cFontAgent::eFont_System, str, len );

	/// ˻  
	unsigned int cutWidth = 0;
	unsigned int cutlen = 0;

	/// ڿ  ε 
	int startIndex = 0;

	/// Կ ڿ
	LPTSTR newtext = new TCHAR[256];
	::ZeroMemory( newtext, 256 );

	while( width + mLineWidth > mMaxTextWidth )
	{
		if( cutWidth + mLineWidth < mMaxTextWidth )	
		{
			cutlen++;

			///  ˻   ϱ
			cutWidth = FONTAGENT->GetTextExtent( cFontAgent::eFont_System, str + startIndex, cutlen );
		}
		else if( cutlen > 0 )
		{
			if( /*cutlen > 0 &&*/ cutWidth + mLineWidth > mMaxTextWidth )
			{
				/// UNICODE ϱ  ̸ 1 
				int minusWidth = FONTAGENT->GetTextExtent( cFontAgent::eFont_System, str + startIndex + cutlen - 1, 1 );
				cutWidth -= minusWidth;
				cutlen -= 1;
			}

			Sstrncpy( newtext, 256, str + startIndex, cutlen );
			
			/// ɼ ؽƮ ƴϸ ׳ 
			InsertColumn( autoNewline, newtext, color, itemIndex, slotIndex );
			mLineWidth = 0;

			///
			width -= cutWidth;
			startIndex += cutlen;
			len -= cutlen;
			cutWidth = 0;
			cutlen = 0;
		}
	}

	if( len > 0 )
	{
		Sstrncpy( newtext, 256, str + startIndex, len );

		if( mLineWidth == 0 && autoNewline == false )
			InsertRow( newtext, color, itemIndex, slotIndex );
		else
			InsertColumn( autoNewline, newtext, color, itemIndex, slotIndex );

		mLineWidth += width;
	}
	else if( len < 0 )
	{
		assert(0);
	}

	SAFE_DELETE_ARRAY( newtext );
}

void cTextCtrl::AddPasteRowInven( LPCTSTR str, unsigned long color, sInventory inventory )
{
	if( !str ) return;

	///  ο ٿ ϱ
	if( mLine > 0 )
	{
		mLine--;
	}

	unsigned int len = ::_tcslen( str );

	/// ڿ  ϱ
	unsigned int width = FONTAGENT->GetTextExtent( cFontAgent::eFont_System, str, len );

	/// ˻  
	unsigned int cutWidth = 0;
	unsigned int cutlen = 0;

	/// ڿ  ε 
	int startIndex = 0;

	/// Կ ڿ
	LPTSTR newtext = new TCHAR[256];
	::ZeroMemory( newtext, 256 );

	while( width + mLineWidth > mMaxTextWidth )
	{
		if( cutWidth + mLineWidth < mMaxTextWidth )	
		{
			cutlen++;

			///  ˻   ϱ
			cutWidth = FONTAGENT->GetTextExtent( cFontAgent::eFont_System, str + startIndex, cutlen );
		}
		else if( cutlen > 0 )
		{
			if( cutWidth + mLineWidth > mMaxTextWidth )
			{
				/// UNICODE ϱ  ̸ 1 
				int minusWidth = FONTAGENT->GetTextExtent( cFontAgent::eFont_System, str + startIndex + cutlen - 1, 1 );
				cutWidth -= minusWidth;
				cutlen -= 1;
			}

			Sstrncpy( newtext, 256, str + startIndex, cutlen );

			InsertColumnInven( newtext, color, inventory );
			mLineWidth = 0;

			///
			width -= cutWidth;
			startIndex += cutlen;
			len -= cutlen;
			cutWidth = 0;
			cutlen = 0;
		}
	}

	if( len > 0 )
	{
		Sstrncpy( newtext, 256, str + startIndex, len );

		if( mLineWidth == 0 )
			InsertRowInven( newtext, color, inventory );
		else
			InsertColumnInven( newtext, color, inventory );

		mLineWidth += width;
	}
	else if( len < 0 )
	{
		assert(0);
	}

	SAFE_DELETE_ARRAY( newtext );
}

///
void cTextCtrl::InsertRow( LPCTSTR str, unsigned long color, unsigned long itemIndex, unsigned int slotIndex )
{
	//  ä
	sTextData* data = new sTextData;
	data->mLine = mLine;
	data->mColor = color;
	data->mText = str;
	data->mItemIndex = itemIndex;
	data->mSlotIndex = slotIndex;

	///  
	sRowTextData* rowData = new sRowTextData;
	rowData->mColumes.PushBack( data );

	///   
	mTextQueue.PushBack( rowData );

	/// ִ  ũ
	if( mLine >= mTotalMaxNum )
	{
		sRowTextData* p = (sRowTextData*)mTextQueue.Front();
		if( p )
		{
			for( unsigned int b = 0; b < p->mColumes.GetSize(); ++b )
			{
				SAFE_DELETE( p->mColumes[b] );
			}
			p->mColumes.Clear();
	
			SAFE_DELETE(p);
		}		

		mTextQueue.PopFront();

		///   
		mDelCount++;
	}

	///    
	mLine++;
}


void cTextCtrl::InsertColumn( bool autoNewline, LPCTSTR str, unsigned long color, unsigned long itemIndex, unsigned int slotIndex )
{
	/// ο ׳ ϰ,  ͼ δ
	if( autoNewline == false )
	{
		if( mTextQueue.GetSize() == 0 )
		{
			assert(0);
			return;
		}

		int linenum = mLine;
		if( mLine >= mTextQueue.GetSize() )
		{
			linenum = mTextQueue.GetSize() - 1;
		}

		sTextData* data = new sTextData;
		data->mLine = mLine;
		data->mColor = color;
		data->mText = str;
		data->mItemIndex = itemIndex;
		data->mSlotIndex = slotIndex;
		
		sRowTextData* pRow = (sRowTextData*)mTextQueue[linenum];
		pRow->mColumes.PushBack( data );

		mLine++;
	}
	/// ڵ ο  ־ ϴ° ( npc ȭ.. )
	else
	{
		if( mLine >= mTextQueue.GetSize() )
		{
			InsertRow( str, color, 0, 0 );
			return;
		}

		sTextData* data = new sTextData;
		data->mLine = mLine;
		data->mColor = color;
		data->mText = str;
		data->mItemIndex = 0;
		data->mSlotIndex = UINT_MAX;

		sRowTextData* pRow = (sRowTextData*)mTextQueue[mLine];
		pRow->mColumes.PushBack( data );

		mLine++;
	}
}

void cTextCtrl::InsertRowInven( LPCTSTR str, unsigned long color, sInventory inventory )
{
	sInvenData* data = new sInvenData;
	data->mLine = mLine;
	data->mColor = color;
	data->mText = str;
	data->mItemIndex = 0;
	data->mSlotIndex = UINT_MAX;
	data->mUseInven = true;
	data->mInventory = inventory;

	///  
	sRowTextData* rowData = new sRowTextData;
	rowData->mColumes.PushBack( data );

	///   
	mTextQueue.PushBack( rowData );

	/// ִ  ũ
	if( mLine >= mTotalMaxNum )
	{
		sRowTextData* p = (sRowTextData*)mTextQueue.Front();
		if( p )
		{
			p->mColumes.Clear();
			SAFE_DELETE(p);
		}		

		mTextQueue.PopFront();

		///   
		mDelCount++;
	}

	///    
	mLine++;
}

void cTextCtrl::InsertColumnInven( LPCTSTR str, unsigned long color, sInventory inventory )
{
	if( mTextQueue.GetSize() == 0 )
	{
		assert(0);
		return;
	}

	int linenum = mLine;
	if( mLine >= mTextQueue.GetSize() )
	{
		linenum = mTextQueue.GetSize() - 1;
	}

	sInvenData* data = new sInvenData;
	data->mLine = mLine;
	data->mColor = color;
	data->mText = str;
	data->mItemIndex = 0;
	data->mSlotIndex = UINT_MAX;
	data->mUseInven = true;
	data->mInventory = inventory;

	sRowTextData* pRow = (sRowTextData*)mTextQueue[linenum];
	pRow->mColumes.PushBack( data );

	mLine++;
}

///
sRowTextData* cTextCtrl::GetRowData( unsigned int rowIdx )
{
	if( rowIdx >= mTextQueue.GetSize() )
		return 0;

	return (sRowTextData*)mTextQueue[rowIdx];
}


/// NPC  Ư ÷ 
//void cTextCtrl::InsertFuncColumn( LPCTSTR str, unsigned long color )
//{
//	if( mLine >= mTextQueue.GetSize() )
//	{
//		InsertRow( str, color, 0, 0 );
//		return;
//	}
//
//	sTextData data;
//	data.mLine = mLine;
//	data.mColor = color;
//	data.mText = str;
//	data.mItemIndex = 0;
//	data.mSlotIndex = UINT_MAX;
//
//	sRowTextData* pRow = (sRowTextData*)mTextQueue[mLine];
//	pRow->mColumes.PushBack( data );
//
//	mLine++;
//}

///
//void cTextCtrl::InsertColumn( LPCTSTR str, unsigned long color, unsigned long itemIndex, unsigned int slotIndex )
//{
//	if( mTextQueue.GetSize() == 0 )
//	{
//		assert(0);
//		return;
//	}
//
//	int linenum = mLine;
//	if( mLine >= mTextQueue.GetSize() )
//	{
//		linenum = mTextQueue.GetSize() - 1;
//	}
//	
//	sTextData data;
//	data.mLine = mLine;
//	data.mColor = color;
//	data.mText = str;
//	data.mItemIndex = itemIndex;
//	data.mSlotIndex = slotIndex;
//
//	sRowTextData* pRow = (sRowTextData*)mTextQueue[linenum];
//	pRow->mColumes.PushBack( data );
//
//	mLine++;
//}
