/* ==========================================================================
*      : TextCtrl.h
*      : ؽƮڽ  ڷ  Ŭ 
*    : 谡
*    : 2007-03-12
* ǻ :
*===========================================================================*/
#pragma once
#include "UIWindow.h"
#include "PointerQueue.h"

///  
struct sTextData
{
	/// 
	unsigned int mLine;

	/// ؽƮ ÷
	unsigned long mColor;

	/// ؽƮ
	cStringT mText;

	///   
	unsigned long mItemIndex;
	unsigned int mSlotIndex;

	bool mUseInven;
	sTextData()
	{
		mLine = 0;
		mColor = 0;
		mItemIndex = 0;
		mSlotIndex = UINT_MAX;
		mUseInven = false;
	}
};

struct sInvenData : sTextData
{
	sInventory	mInventory;
	sInvenData()
	{
		::memset( &mInventory, 0, sizeof(mInventory) );
	}
};


///  
struct sRowTextData
{
	/// sTextData
	tPointerArray<sTextData*>		mColumes;
};

class cTextCtrl : public cUIWindow
{
public:
	cTextCtrl( eUINodeType type = eUINODE_TEXTBOX );
	virtual ~cTextCtrl();

protected:
	/// ͸   
	void Clear();

	///   ߰ 
	void AddEmptyRow( unsigned int line );

	/// ο ο  ߰
	void AddNewRow( LPCTSTR str, unsigned long color, unsigned long itemIndex = 0, unsigned int slotIndex = UINT_MAX );

	///  ο Ͽ  ߰ ( autoNewline: ڵ   )
	void AddPasteRow( bool autoNewline, LPCTSTR str, unsigned long color, unsigned long itemIndex = 0, unsigned int slotIndex = UINT_MAX );
	void AddPasteRowInven( LPCTSTR str, unsigned long color, sInventory inventory );
	
	/// ü   
	unsigned int		GetRowCount();

	/// ش   
	sRowTextData*		GetRowData( unsigned int rowIdx );

private:
	void InsertRow( LPCTSTR str, unsigned long color, unsigned long itemIndex, unsigned int slotIndex );
	void InsertColumn( bool autoNewline, LPCTSTR str, unsigned long color, unsigned long itemIndex, unsigned int slotIndex );

	void InsertRowInven( LPCTSTR str, unsigned long color, sInventory inventory );
	void InsertColumnInven( LPCTSTR str, unsigned long color, sInventory inventory );
	
	//	void AddPasteRow( bool func, LPCTSTR str, unsigned long color, unsigned long itemIndex = 0, unsigned int slotIndex = UINT_MAX );
	//	void InsertColumn( LPCTSTR str, unsigned long color, unsigned long itemIndex, unsigned int slotIndex );
	//  void InsertFuncColumn( LPCTSTR str, unsigned long color );

protected:
	/// ڿ Ʈ
	typedef tPointerQueue<void*> cTextQueue;
	cTextQueue	mTextQueue;

	/// ٿϴ   
	unsigned int mMaxTextWidth;

	///   ε
	unsigned int mLine;

	/// Ʈ  ϴ  
	unsigned int mTotalMaxNum;

	/// ʺ
	unsigned int mLineWidth;

	/// 
	unsigned int mDelCount;
};

inline unsigned int cTextCtrl::GetRowCount()
{
	return mTextQueue.GetSize();
}