#include "StdAfx.h"
#include "TexturePalette.h"

#include "RenderSystem.h"
#include "ResourceManager.h"
#include "Stream.h"
#include "EngineFile.h"
#include "ImageReader.h"

cTexturePalette::cTexturePalette( unsigned int sizeHint )
: NiDefaultTexturePalette( false )
, mTextureMap( sizeHint )
, mStream( 0 )
{
}

cTexturePalette::~cTexturePalette()
{
}

void cTexturePalette::RemoveAllTextures()
{
#ifdef _DEVSYS
	cTextureMap::cIterator i = mTextureMap.Begin();
	cTextureMap::cIterator iend = mTextureMap.End();
	for( ; i != iend; ++i )
	{
		cString str = (cString)i->mFirst;
		NiTexture* tex = (NiTexture*)i->mSecond;
		assert(tex->GetRefCount() == 1);
		tex = 0;
	}
#endif

	mTextureMap.Clear();
}

//void cTexturePalette::RemoveTexture( NiTexture* tex )
//{
//	//   , ҽ  üũ ٽ ϶!!
//	assert( tex || tex->GetName() );
//
//	m_kHash.RemoveAt( tex->GetName() );
//}
//

void cTexturePalette::RemoveTexture( char* texName )
{
	assert( ::strlen(texName) );
	
	NiFilename filename( texName );
	cTextureMap::cIterator i = mTextureMap.Find( filename.GetFilename() );
	if( i != mTextureMap.End() )
	{
		cString str = (cString)i->mFirst;
		NiTexture* tex = (NiTexture*)i->mSecond;
		assert(tex->GetRefCount() == 1);
		tex = 0;

		mTextureMap.Erase( i );
	}

	//m_kHash.RemoveAt( texName );
}

void cTexturePalette::SetTexture( const char* pathName, NiTexture* tex )
{
	assert( pathName );
	assert( tex );

	NiFilename filename( pathName );
	if( mTextureMap.Insert( filename.GetFilename(), tex ) == false )
	{
		assert(0);
		return;
	}
	//test
	//if( mStream )
	//{
	//	const char* path = mStream->GetPath().Cstr();
	//	path = path;
	//}
	//NiDefaultTexturePalette::SetTexture( pathName, tex );
	//NiFilename name = NiFilename(pcPath);
	//cString str = name.GetFilename();
	//str += name.GetExt();

	//NiDefaultTexturePalette::SetTexture( pathName, tex );
}

NiTexture* cTexturePalette::GetTexture( const char* pathName, NiTexture* tex ) const
{
	assert( pathName );

	/// ̹ ϴ ˻
	NiFilename filename(pathName);
	cTextureMap::cIterator pos = mTextureMap.Find( filename.GetFilename() );

	if( pos != mTextureMap.End() )
	{
		return pos->mSecond;
	}

	if( mStream == 0 )
		return 0;

	/// Ʈ ܺ ؽó  ε
	NiTexture* nitex = 0;
	NiPixelDataPtr pixelData = 0;

	cString tempName;
	tempName.Format( "%s%s", mStream->GetPath().Cstr(), pathName );

//	cString ext;
//	::GetFileExtension( &ext, tempName );
//	ext.ToLower();

	if( strcmp( filename.GetExt(), ".nif") == 0 )
	{
		cFileLoader loader;
		if( loader.Open( tempName, true ) == false )
		{
			return 0;
		}

		/// ȼ Ÿ ε
		cTextureStream stream( tempName );

		if( stream.Load( (char*)loader.GetBufferPtr(), loader.GetSize() ) == false )
		{
			return 0;
		}

		pixelData = stream.mPixelData;
	}
	else if( strcmp( filename.GetExt(), ".tga") == 0 )
	{
		cFileLoader loader;
		if( loader.Open( tempName, true ) == false )
			return 0;

		cEngineFile file( loader.GetFile() );
		cTGAReader tgaReader;
		pixelData = tgaReader.ReadFile( file, 0 );
	}
	else
	{
		assert( 0 );
		return 0;
	}

	if( pixelData == 0 )
		return 0;

	/// ȼ Ÿκ  ؽó 
	NiTexture::FormatPrefs prefs;
	prefs.m_eMipMapped = pixelData->GetNumMipmapLevels() == 1 ? NiTexture::FormatPrefs::NO : NiTexture::FormatPrefs::YES;

	nitex = NiSourceTexture::Create( pixelData, prefs );

	if( nitex == 0 )
		return 0;

	/// ؽó ʿ ߰
	if( mTextureMap.Insert( filename.GetFilename(), nitex ) == false )
	{
		assert(0);
		return 0;
	}

	return nitex;
}
