#include "stdafx.h"
#include "TipManager.h"
#include "GameResourceManager.h"
#include "ChatManager.h"
#include "ObjectManager.h"
#include "Hero.h"
#include "OptionManager.h"

cTipManager* cTipManager::mpSingleton = 0;

cTipManager::cTipManager()
: mLastAccumTime(0)
{
	mpSingleton = this;
}

cTipManager::~cTipManager()
{
	for( unsigned int i = 0; i < MAX_TIPCOUNT; ++i )
	{
		mTipArr[i].Clear();
	}

	for( unsigned int i = 0; i < mLoadTipArr.GetSize(); ++i )
	{
		delete (sLoadTipData*)mLoadTipArr[i];
	}
	mLoadTipArr.Clear();

	mpSingleton = 0;
}

bool cTipManager::Init()
{
	if( LoadGameTip( "./Script/Resource/Tip_Game.txt" ) == false )
	{
		assert( 0 && "failed to load tip_game" );
		return false;
	}
	if( LoadLoadTip( "./Script/Resource/Tip_LoadingMap.txt" ) == false )
	{
		assert( 0 && "failed to load tip_game" );
		return false;
	}
	
	return true;
}

///   ε
bool cTipManager::LoadGameTip( const cString& pathname )
{
	cFileLoader loader;

	if( loader.Open( pathname, true ) == false )
	{
		assert( 0 && "failed to load game tip" );
		return false;
	}

	cTokenizer tokenizer( loader.GetBufferPtr(), loader.GetSize(), " \t\r\n", pathname.Cstr() );
	cString str;

	while( tokenizer.IsEnd() == false )
	{
		///  ε
		if( tokenizer.GetNext( &str ) == false )
			return false;

		long index = str.ToInt();

		/// ּ 
		if( tokenizer.GetNext( &str ) == false )
			return false;

		long minLevel = str.ToInt();

		/// ִ 
		if( tokenizer.GetNext( &str ) == false )
			return false;

		long maxLevel = str.ToInt();

		if( maxLevel > MAX_TIPCOUNT )
		{
			assert(0);
			return false;
		}

		///  
		for( long i = minLevel; i <= maxLevel; ++i )
		{
			mTipArr[i-1].PushBack( index );
		}
	}
	return true;
}

/// ε   
bool cTipManager::LoadLoadTip( const cString& pathname )
{
	cFileLoader loader;

	if( loader.Open( pathname, true ) == false )
	{
		assert( 0 && "failed to load load tip" );
		return false;
	}

	cTokenizer tokenizer( loader.GetBufferPtr(), loader.GetSize(), " \t\r\n", pathname.Cstr() );
	cString str;

	while( tokenizer.IsEnd() == false )
	{
		///  ε
		if( tokenizer.GetNext( &str ) == false )
			return false;

		long index = (long)str.ToInt();

		/// ؽ 
		if( tokenizer.GetNext( &str ) == false )
			return false;

		cString name = str;

		/// ؽó ǥ X
		if( tokenizer.GetNext( &str ) == false )
			return false;

		unsigned int texX = (unsigned int)str.ToInt();

		/// ؽó ǥ Y
		if( tokenizer.GetNext( &str ) == false )
			return false;

		unsigned int texY = (unsigned int)str.ToInt();

        /// 
		sLoadTipData* p = new sLoadTipData;
		p->mTexName = name;
		p->mTexX = texX;
		p->mTexY = texY;
	
		mLoadTipArr.PushBack( p );
	}
	return true;
}

///   
void cTipManager::Process( unsigned long accumTime )
{
	if( OPTIONMAN->IsShowTip() == false )
		return;

	if( accumTime - mLastAccumTime > TIP_UPDATETIME )
	{
		///  
		unsigned char level = HERO->GetLevel();
		
		if( level <= MAX_TIPCOUNT )
		{
			int size = mTipArr[level-1].GetSize();
			if( size > 0 )
			{
				int key = rand() % size;
				unsigned long textIdx = mTipArr[level-1][key];

				CHATMANAGER->AddTipMsg( GAMERESOURCEMAN->GetTipText( textIdx ) );
			}
		}

		mLastAccumTime = accumTime;
	}
}

sLoadTipData* cTipManager::GetLoadTipData()
{
	int size = mLoadTipArr.GetSize();
	if( size > 0 )
	{
		int key = rand() % size;
		return (sLoadTipData*)mLoadTipArr[key];
	}
	return 0;
}