/* ==========================================================================
*      : TipManager.h
*      : 
*    : 谡
*    : 2008-12-16
* ǻ :
*===========================================================================*/

const int MAX_TIPCOUNT = 100;
const unsigned long TIP_UPDATETIME = 1000 * 180; // 1
const unsigned int TIPIMG_W = 630;
const unsigned int TIPIMG_H = 126;

struct sLoadTipData
{
	/// ؽ 
	cString mTexName;
	
	/// ؽ ġ
	unsigned int mTexX;
	unsigned int mTexY;

	sLoadTipData()
	{
		mTexX = 0;
		mTexY = 0;
	}
};

class cTipManager
{
public:
	cTipManager();
	~cTipManager();

	bool Init();
	void Process( unsigned long accumTime );

	/// 
	sLoadTipData* GetLoadTipData();

public:
	static cTipManager*	mpSingleton;
	static cTipManager* GetSingleton();

protected:
	bool LoadGameTip( const cString& pathname );
	bool LoadLoadTip( const cString& pathname );

private:
	/// ä  
	typedef tArray<unsigned long> cIndexArr;
	cIndexArr mTipArr[MAX_TIPCOUNT];

	/// ε  
	typedef tPointerArray<void*> cLoadTipArr;
	cLoadTipArr mLoadTipArr;

	///
	unsigned long mLastAccumTime;
};

inline cTipManager* cTipManager::GetSingleton() 
{
	return mpSingleton;
}

#define TIPMAN cTipManager::GetSingleton()