#include "StdAfx.h"
#include "TipWindow.h"

#include "ItemManager.h"
#include "PlaneObject.h"
#include "UIWindow.h"
#include "GameResourceManager.h"
#include "FontAgent.h"

cTipWindow::cTipWindow()
: mMiddleBack( 0 )
, mIndex(0)
, mMaxWidth(0)
, mGapCount(0)
, mLineHeight(0)
, mLimitMinWidth(30)
, mLimitMaxWidth(250)
{
	mX = 0;
	mY = 0;

	mLineHeight = FONTAGENT->GetTextHeight(cFontAgent::eFont_System) + LINEGAP_SIZE;
}

cTipWindow::~cTipWindow()
{
	SAFE_DELETE( mMiddleBack );
}

void cTipWindow::Clear()
{
	for( unsigned int i=0; i<MAX_TIP; i++ )
	{
		mToolTip[i].mString.Clear();
		mToolTip[i].mGapCount = 0;
	}

	mMaxWidth = 0;
	mIndex = 0;
	mGapCount = 0;
}

bool cTipWindow::OnCreate( cUINodeProperty* )
{
	/*NiAlphaProperty* alphaProp = mMiddleBack->GetAlphaProp();

	alphaProp->SetAlphaBlending( true );
	alphaProp->SetSrcBlendMode( NiAlphaProperty::ALPHA_ZERO );
	alphaProp->SetDestBlendMode( NiAlphaProperty::ALPHA_SRCCOLOR );*/
	return true;
}

bool cTipWindow::SetSkin( const cUINodeSkin* skin )
{
	assert( skin );

	if( skin->IsKindof( eUINODE_WINDOW ) == false )
	{
		assert( 0 && "not window type" );
		return false;
	}

	unsigned short x = (unsigned short)skin->mSkinInfo->mX;
	unsigned short y = (unsigned short)skin->mSkinInfo->mY;
	unsigned short w = (unsigned short)skin->mSkinInfo->mWidth;
	unsigned short h = (unsigned short)skin->mSkinInfo->mHeight;

	/// ̹ 
	if( skin->mpTexture )
	{
		/// ؽó  
		unsigned short tx = (unsigned short)skin->mSkinInfo->mTexX;
		unsigned short ty = (unsigned short)skin->mSkinInfo->mTexY;
		unsigned short tw = (unsigned short)skin->mSkinInfo->mTexWidth;
		unsigned short th = (unsigned short)skin->mSkinInfo->mTexHeight;

		if( mMiddleBack == 0 )
		{
			mMiddleBack = new cPlaneObject;

			if( mMiddleBack->Create( skin->mpTexture,
				x, y, w, h,
				tx, ty, tx + tw, ty + th ) == false )
			{
				assert( 0 && "failed to create back image");
				return false;
			}
		}
		else
		{
			mMiddleBack->SetTextureRect( tx, ty, tx + tw, ty + th );
		}
	}

	SetRelativeRect( cUIRect(x, y, x + w, y + h) );
	return true;
}

///
void cTipWindow::CalcMaxWidth( const cStringT& str )
{
	unsigned int width = FONTAGENT->GetTextExtent( cFontAgent::eFont_System, (LPCTSTR)str.Cstr(), str.GetSize() );
	if( width > mMaxWidth )
		mMaxWidth = width;

	if( mMaxWidth > mLimitMaxWidth )
		mMaxWidth = mLimitMaxWidth;
}

///
void cTipWindow::SetText( const LPCTSTR str, unsigned long value, unsigned long color )
{
	mToolTip[mIndex].mString.Format( str, value );
	mToolTip[mIndex].mColor = color;
	CalcMaxWidth( mToolTip[mIndex].mString );
	mIndex++;

	if( mIndex > MAX_TIP )
	{
		assert( 0 && "error tip index" );
	}
}

///
void cTipWindow::SetText( const LPCTSTR str, float value, unsigned long color )
{
	mToolTip[mIndex].mString.Format( str, value );
	mToolTip[mIndex].mColor = color;
	CalcMaxWidth( mToolTip[mIndex].mString );
	mIndex++;

	if( mIndex > MAX_TIP )
	{
		assert( 0 && "error tip index" );
	}
}

///
void cTipWindow::SetText( const LPCTSTR str, short value, unsigned long color )
{
	mToolTip[mIndex].mString.Format( str, value );
	mToolTip[mIndex].mColor = color;
	CalcMaxWidth( mToolTip[mIndex].mString );
	mIndex++;

	if( mIndex > MAX_TIP )
	{
		assert( 0 && "error tip index" );
	}
}

///
void cTipWindow::SetText( LPCTSTR str, unsigned long color )
{
	/// Խÿ ڿ  ˻ 
	if( CheckText( str, color ) == false )
	{
		assert(0);
		return;
	}
}

///
void cTipWindow::SetText( LPCTSTR str1, LPCTSTR str2, unsigned long color )
{
	mToolTip[mIndex].mString.Format( str1, str2 );
	mToolTip[mIndex].mColor = color;
	CalcMaxWidth( mToolTip[mIndex].mString );
	mIndex++;

	if( mIndex > MAX_TIP )
	{
		assert( 0 && "error tip index" );
	}
}

///
void cTipWindow::AppendText( LPCTSTR str1, LPCTSTR str2, unsigned long color )
{
	cStringT temp1 = str1;
	cStringT temp2 = str2;
	temp1.Append( temp2 );

	/// Խÿ ڿ  ˻ 
	if( CheckText( (LPCTSTR)temp1.Cstr(), color ) == false )
	{
		assert(0);
		return;
	}
}

///
bool cTipWindow::CheckText( LPCTSTR str, unsigned long color )
{
	/// ڿ  ϱ
	unsigned int len = ::_tcslen( str );
	unsigned int width = FONTAGENT->GetTextExtent( cFontAgent::eFont_System, str, len );

	/// ˻  
	unsigned int cutWidth = 0;
	unsigned int cutlen = 0;
	unsigned int startIndex = 0;

	unsigned int maxWidth = mLimitMaxWidth - GAP_SIZE;

	/// Կ ڿ
	TCHAR	text[128] = {0,};
	LPTSTR newtext = text;
	::ZeroMemory( newtext, 128 );

	/// 乮 ˻
	while( len != cutlen )
	{
		///   Ѵ 
		cutlen++;
		cutWidth = FONTAGENT->GetTextExtent( cFontAgent::eFont_System, str + startIndex, cutlen );

		///  ڰ˻縦 Ѵ
		TCHAR temp[3] = {0,};
		::_tcsncpy( temp, &str[startIndex + cutlen], 2 );

		/// ͺȣ  ٳѱ
		if( ::_tcsncmp( temp, _T("\\n"), 2 ) == 0 )
		{
			/// 
			Sstrncpy( newtext, 128, str + startIndex, cutlen );
			mToolTip[mIndex].mString = newtext;
			mToolTip[mIndex].mColor = color;
			CalcMaxWidth( mToolTip[mIndex].mString );
			mIndex++;

			if( mIndex > MAX_TIP )
			{
				assert( 0 && "error tip index" );
			}

			///
			width -= cutWidth; 
			startIndex += cutlen + 2;
			len -= (cutlen + 2);
			cutWidth = 0;
			cutlen = 0;
		}
		/// ͺȣ  ʺ ˻ 
		else
		{
			///  ̰ ƽ ѱ 
			if( cutWidth > maxWidth )
			{
				if( cutlen > 1 )
				{
					/// UNICODE ϱ  ̸ 1 
					int minusWidth = FONTAGENT->GetTextExtent( cFontAgent::eFont_System, str + startIndex + cutlen - 1, 1 );
					cutWidth -= minusWidth;
					cutlen -= 1;
				}

				/// 
				assert(cutlen <128);
				Sstrncpy( newtext, 128, str + startIndex, cutlen );
				mToolTip[mIndex].mString = newtext;
				mToolTip[mIndex].mColor = color;
				CalcMaxWidth( mToolTip[mIndex].mString );
				mIndex++;

				if( mIndex > MAX_TIP )
				{
					assert( 0 && "error tip index" );
				}

				///
				width -= cutWidth;
				startIndex += cutlen;
				len -= cutlen;
				cutWidth = 0;
				cutlen = 0;
			}
		}
	}

	/// ڿ  
	if( len > 0 )
	{
		/// 
		assert(len <128);
		Sstrncpy( newtext, 128, str + startIndex, len );
		mToolTip[mIndex].mString = newtext;
		mToolTip[mIndex].mColor = color;
		CalcMaxWidth( mToolTip[mIndex].mString );
		mIndex++;

		if( mIndex > MAX_TIP )
		{
			assert( 0 && "error tip index" );
		}
	}

	return true;
}

void cTipWindow::AddGap( unsigned int count )
{
	mToolTip[mIndex].mGapCount += count;
	mGapCount += count;
}
