/* ==========================================================================
*      : TipWindow.h
*      : 
*    : 谡
*    : 2007-09-06
* ǻ :
*===========================================================================*/
#pragma once
#include "UIWindow.h"

enum eTip_Kind
{
	eTIP_ITEM,
	eTIP_SKILL,
	eTIP_QUICK,
};

class cTipParam
{
public:
	/// ؽƮ
	cStringT mString;

	/// ؽƮ ÷
	unsigned long mColor;

	unsigned int mGapCount;

	cTipParam() : mGapCount(0) {}
};

const unsigned int GAP_SIZE = 6;
const unsigned int LINEGAP_SIZE = 3;
const unsigned int MAX_TIP = 50;

class cPlaneObject;
class cTipWindow : public cUIWindow
{
public:
	cTipWindow();
	virtual ~cTipWindow();

protected:
	bool OnCreate( cUINodeProperty* prop );
	void OnRender( cUIFontItemKeeper* fontKeeper ) = 0;
	bool SetSkin( const cUINodeSkin* skin );
	void OnHide() {};
	virtual void Clear();

	/// ؽƮ ̰˻ (  )
	bool CheckText( LPCTSTR str, unsigned long color );

	/// ؽƮ  
	void AppendText( LPCTSTR str1, LPCTSTR str2, unsigned long color );
	void SetText( LPCTSTR str1, LPCTSTR str2, unsigned long color );
	void SetText( LPCTSTR str, unsigned long color );
	void SetText( const LPCTSTR str, unsigned long value, unsigned long color );
	void SetText( const LPCTSTR str, float value, unsigned long color );
	void SetText( const LPCTSTR str, short value, unsigned long color );

	/// Ʈ ʺ  
	void CalcMaxWidth( const cStringT& str );

	void AddGap( unsigned int count );

protected:
	/// 
	unsigned int mX;
	unsigned int mY;
	unsigned int mWidth;
	unsigned int mHeight;

	unsigned int mGapCount;

	///   ̹
	cPlaneObject* mMiddleBack;

	///   
	cTipParam mToolTip[MAX_TIP];

	///  ε 
	unsigned int mIndex;

	/// Ʈ ʺ
	unsigned int mMaxWidth;

	/// Ѱ ʺ
	unsigned int mLimitMinWidth;
	unsigned int mLimitMaxWidth;

	///   
	unsigned int mLineHeight;
};
