/* ==========================================================================
*      : TitleManager.h
*      : 
*    : 谡
*    : 2008-01-18
* ǻ :
*===========================================================================*/
#include "BaseStage.h"

class cTitleDefine
{
public:
	cTitleDefine();

public:
	/// ŸƲ
	LPCTSTR mName;

	/// ŸƲ
	LPCTSTR mDescription;

	/// ȿ ε
	long mInfluenceIndex;

	/// ŸƲ 
	unsigned long mColor;
};

inline
cTitleDefine::cTitleDefine()
: mName(0)
, mDescription(0)
, mInfluenceIndex(0)
, mColor(0)
{
}

class cTitleManager
{
public: 
	cTitleManager();
	~cTitleManager();

	bool Init();
	void Open();
	void Close();

	void TitleSet( unsigned long titleIdx );

	///
	void ClearList();
	void AddHaveTitle( unsigned long titleIdx );

	bool IsHaveTitle( unsigned long titleIdx );

	///
	void NetworkMsgParser( char* msg );
	cTitleDefine* GetTitleDefine( unsigned long titleIdx );

public:
	static cTitleManager* mpSingleton;
	static cTitleManager* GetSingleton();

protected:
	bool Load( const cString& pathname );

	/// ȣĪ UI  Ʈ 
	void SortTitleList();

private:
	/// ȣĪ 
	typedef tPointerHashMap<unsigned long, void*> cTitleDefineMap;
	cTitleDefineMap	mTitleDefineMap;

	///  ȣĪ 
	typedef tHashSet<unsigned long>	cHaveTitleSet;
	cHaveTitleSet	mHaveTitleSet;

	///  û ȣĪε
	unsigned long mRequestTitleIndex;
};

inline cTitleManager* cTitleManager::GetSingleton()
{
	return mpSingleton;
}

#define TITLEMAN cTitleManager::GetSingleton()

