#include "StdAfx.h"
#include "TitleWindow.h"
#include "ListBox.h"
#include "TextBox.h"
#include "TitleManager.h"
#include "SkillScript.h"
#include "SkillManager.h"
#include "GameResourceManager.h"

cTitleWindow::cTitleWindow()
: mpTitleList(0)
, mpDescBox(0)
, mpEffectBox(0)
, mpSelect(0)
{

}

cTitleWindow::~cTitleWindow()
{

}

void cTitleWindow::OnShow()
{
	cUIWindow::OnShow();

	//Sort();
}

void cTitleWindow::Clear()
{
	if( mpTitleList )
		mpTitleList->Clear();

	if( mpDescBox )
		mpDescBox->Clear();

	if( mpEffectBox )
		mpEffectBox->Clear();
}

bool cTitleWindow::OnCreate( cUINodeProperty* pproperty )
{
	if( cUIWindow::OnCreate( pproperty ) == false )
		return false;

	mpTitleList = (cListBox*)GetChild( eUIID_TITLE_LISTBOX );
	mpDescBox = (cTextBox*)GetChild( eUIID_TITLE_DESC_TEXTBOX );
	mpEffectBox = (cTextBox*)GetChild( eUIID_TITLE_EFFECT_TEXTBOX );
	mpSelect = GetChild(eUIID_TITLE_SELECT);

	if( mpTitleList )
		mpTitleList->SetContinueEvent( true );

	if( mpDescBox)
		mpDescBox->SetDrawTextBottom( false );

	if( mpEffectBox )
		mpEffectBox->SetDrawTextBottom( false );
	return true;
}

void cTitleWindow::OnCommand( cUINode* , unsigned int id )
{
	switch( id )
	{
	case eUIID_TITLE_CLOSE:
	case eUIID_TITLE_CANCEL:
		Hide();
		break;
	case eUIID_TITLE_SELECT:
		{
			///  ȣĪ 
			int row = mpTitleList->GetSelectIndex();
			unsigned long titleIdx = (unsigned long)mpTitleList->GetExtraData( row );
			TITLEMAN->TitleSet( titleIdx );
		}
		break;
	default:
		assert(0);
		return;
	}
}

void cTitleWindow::OnListBoxChanged( cUINode* , unsigned int )
{
	if( mpTitleList || mpDescBox || mpEffectBox )
	{
		mpDescBox->Clear();
		mpEffectBox->Clear();

		int row = mpTitleList->GetSelectIndex();
		unsigned long titleIdx = (unsigned long)mpTitleList->GetExtraData( row );

		///  ߰
		cTitleDefine* define = TITLEMAN->GetTitleDefine( titleIdx );
		if( define )
		{
			mpDescBox->AddNewRow( define->mDescription, eCOLOR_WHITE );
		}

		/// ȿ ߰
		sInfluenceScript* pInfo = SKILLSCRIPT->GetInfluenceInfo( define->mInfluenceIndex );
		if( pInfo )
		{
			cStringT temp;

			/// ȿ  ȿ
			if( pInfo->mValue1 != 0 || pInfo->mValue2 != 0 || pInfo->mValue3 != 0 )
			{
				if( pInfo->mValue1 && pInfo->mValue2 && pInfo->mValue3 )
				{
					temp.Format( GAMERESOURCEMAN->GetSkillToolTipText( pInfo->mToolTipIdx ), pInfo->mValue1, pInfo->mValue2, pInfo->mValue3 );
					mpEffectBox->AddNewRow( (LPCTSTR)temp.Cstr(), eCOLOR_WHITE );
				}
				else if( pInfo->mValue1 && pInfo->mValue2 )
				{
					temp.Format( GAMERESOURCEMAN->GetSkillToolTipText( pInfo->mToolTipIdx ), pInfo->mValue1, pInfo->mValue2 );
					mpEffectBox->AddNewRow( (LPCTSTR)temp.Cstr(), eCOLOR_WHITE );
				}
				else if( pInfo->mValue1 )
				{
					temp.Format( GAMERESOURCEMAN->GetSkillToolTipText( pInfo->mToolTipIdx ), pInfo->mValue1 );
					mpEffectBox->AddNewRow( (LPCTSTR)temp.Cstr(), eCOLOR_WHITE );
				}
			}
		}
	}
}

/// ȣĪ ߰
bool cTitleWindow::AddTitle( unsigned long titleIdx )
{
	if( !mpTitleList || !mpDescBox || !mpEffectBox )
	{
		assert(0);
		return false;
	}

	cTitleDefine* define = TITLEMAN->GetTitleDefine( titleIdx );
	if( !define )
	{
		assert(0);
		return false;
	}

	/// Ʈ 
	cStringT str;
	str.Format( _T("%03d. %s"), titleIdx, define->mName );

	mpTitleList->AddRow( (LPCTSTR)str.Cstr(), define->mColor, (void*)titleIdx );
	return true;
}

void cTitleWindow::Sort()
{
	if( mpTitleList )
		mpTitleList->Sort();
}

void cTitleWindow::OnNetLock( int lockTry )
{
	if( mpSelect )
		mpSelect->NetLock( lockTry );
}

void cTitleWindow::OnNetUnLock( int lockTry )
{
	if( mpSelect )
		mpSelect->NetUnLock( lockTry );
}