#include "StdAfx.h"
#include ".\totem.h"

#include "TotemScript.h"
#include "SkillObject.h"

#include "SceneManager.h"
#include "EffectSceneNode.h"

cTotem::cTotem()
{
}

cTotem::~cTotem()
{
	if( mLoopEffect.IsEmpty() == false )
	{
		tPointerList<void*>::cIterator b = mLoopEffect.Begin();
		tPointerList<void*>::cIterator end = mLoopEffect.End();
		for( ; b != end; ++b )
		{
			sLoopEffect* p = (sLoopEffect*)(*b);
			if( p == 0 )
				continue;

			cEffectSceneNode* node = SCENEMAN->GetEffectSceneNode( p->mIdxByManager );
			if( node )
			{
				assert( node == p->mEffectNode );
				node->SetLoopFlag( false );
			}
			delete p;
		}
		mLoopEffect.Clear();
	}
}

bool cTotem::Init( unsigned long totemClassIdx, NiPoint3 pos )
{
	sTotemScript* pInfo = TOTEMSCRIPT->GetTotemInfo( totemClassIdx );
	if( pInfo == 0 )
	{
		assert(0);
		return false;
	}

	/// Effect ü 
	char pathName[256] = {0,};
	::sprintf( pathName, "./Data/Effect/%s", pInfo->mFileName.Cstr() );

	NiTransform trans;
	trans.MakeIdentity();
	trans.m_Translate = pos;

	cEffectSceneNode* node = SCENEMAN->CreateSelfEffect( pathName, true, trans, true );
	if( node == 0 )
	{
		assert(0);
		return false;
	}

	AddLoopEffect( node );
	return true;
}

//void cTotem::Update( unsigned long deltaTime, unsigned long accumTime)
//{
//	deltaTime;
//	accumTime;
//
//}

void cTotem::AddLoopEffect( cEffectSceneNode* pNode )
{
	if( pNode == 0 )
	{
		assert( pNode );
		return;
	}

	sLoopEffect* p = new sLoopEffect;
	p->mIdxByManager = pNode->GetIndexByManger();
	p->mEffectNode = pNode;

	mLoopEffect.PushBack( p );
}