#include "stdafx.h"
#include "TradeWindow.h"
#include "ItemManager.h"
#include "ItemDefine.h"
#include "DragWindow.h"
#include "ObjectManager.h"
#include "Hero.h"
#include "GameUIManager.h"
#include "TipWindow.h"

#include "PushButton.h"
#include "Label.h"
#include "Button.h"
#include "NumberEditBox.h"
#include "WareHouseWindow.h"
#include "UIMsgboxEvent.h"
#include "ItemIcon.h"


cTradeWindow::cTradeWindow()
: mTradeButton(0)
, mpName(0)
, mpOtherName(0)
, mMyLastSlot(0)
, mThatLastSlot(0)
, mpMyMoney(0)
, mpThatMoney(0)
, mpMyOk(0)
, mpThatOk(0)
, mStatus( ItemExchangeBegin )
, mThatStatus( ItemExchangeBegin )
{
	
}

cTradeWindow::~cTradeWindow()
{
}

void cTradeWindow::Clear()
{
	/// ڱ  ʱȭ
	for( unsigned int i = 0; i < mMyLastSlot; ++i )
	{
		sTradeItem& myItem = mMyItem[i];
		
		///  Ǯ
		if( myItem.mSlotIndex <= MAX_INVENTORY )
		{
			cItem& invItem = ITEMMAN->GetItem( myItem.mSlotIndex );
			invItem.SetLock( false );
			myItem.mSlotIndex = UINT_MAX;
		}

		cItemIcon* icon = myItem.mMyIcon;
		if( icon )
		{
			icon->ChangeImage( 0 );
			icon->SetItemIndex( 0 );
			icon->SetNumber( 0 );
			icon->SetTipType( eTOOLTIP_NONE );
			icon->ShowNumber( false );
		}
	}

	mMyLastSlot = 0;

	///   ʱȭ
	for( unsigned int i = 0; i < mThatLastSlot; ++i )
	{
		sThatInvetory& thatInv = mThatItem[i];

		/// κ ʱȭ
		sInventory& inv = thatInv.mThatInv;
		inv.idx			= 0;
		inv.ItemIndex	= 0;
		inv.number		= 0;
		inv.count		= 0;
		inv.enhanced	= 0;
		inv.seal		= 0;

		///  ʱȭ
		cItemIcon* icon = thatInv.mThatIcon;
		if( icon )
		{
			icon->ChangeImage( 0 );
			icon->SetItemIndex( 0 );
			icon->SetNumber( 0 );
			icon->SetTipType( eTOOLTIP_NONE );
			icon->ShowNumber( false );
		}
	}

	mThatLastSlot = 0;

	//mStatus = ItemExchangeBegin;
	//mThatStatus = ItemExchangeBegin;
	SetStatus( ItemExchangeBegin, true );
	SetStatus( ItemExchangeBegin, false );

	//SetStatus( ItemExchangeBegin );
	//SetThatStatus( ItemExchangeBegin );

	AddMyMoney( 0 );
	AddThatMoney( 0 );

	//if( mpMyOk )
	//	mpMyOk->SetEnabled( true );

	//if( mTradeButton )
	//	mTradeButton->SetEnabled( false );
}

void cTradeWindow::OnHide()
{
	cUIWindow::OnHide();

	Clear();
}

void cTradeWindow::HideESC( bool onsound )
{
	/// ݱ û
	ITEMMAN->TryToTradeCancel();
}

bool cTradeWindow::OnCreate( cUINodeProperty* property )
{
	if( cUIWindow::OnCreate( property ) == false )
		return false;

	mpName = (cLabel*)GetChild( eUIID_TRADE_NAME );
	mpOtherName = (cLabel*)GetChild( eUIID_TRADE_THATNAME );

	mTradeButton = (cButton*)GetChild( eUIID_TRADE_TRADE );
	mpMyMoney = (cLabel*)GetChild( eUIID_TRADE_MONEY );
	mpThatMoney = (cLabel*)GetChild( eUIID_TRADE_THATMONEY );
	mpMyOk = (cPushButton*)GetChild( eUIID_TRADE_OK );
	mpThatOk = (cPushButton*)GetChild( eUIID_TRADE_THATOK );

	if( mTradeButton )
		mTradeButton->SetEnabled( false );

	if( mpThatOk )
		mpThatOk->SetEnabled( false );

	AddMyMoney( 0 );
	AddThatMoney( 0 );

	///    
	cString str;
	for( unsigned int i = 0; i < MAX_ITEM_EXCHANGE; ++i )
	{
		str.Format( "Trade_MyIcon%02d", i );
		cItemIcon* icon = new cItemIcon;
		if( icon->CreateBySkinName( str, this, i ) == false )
			return false;

		icon->SetLinked( true );
		mMyItem[i].mMyIcon = icon;
	}

	///    
	for( unsigned int i = 0; i < MAX_ITEM_EXCHANGE; ++i )
	{
		str.Format( "Trade_ThatIcon%02d", i );
		cItemIcon* icon = new cItemIcon;;
		if( icon->CreateBySkinName( str, this, i+100 ) == false )
			return false;

		/// hover ̺Ʈ ó ̵ Ұ 
		icon->SetUsedFlag( false, false );
		icon->SetLinked( true );

		mThatItem[i].mThatIcon = icon;
	}

	/// ʱȭ
	SetStatus( ItemExchangeBegin, true );
	SetStatus( ItemExchangeBegin, false );
	return true;
}

void cTradeWindow::OnCommand( cUINode* /*node*/, unsigned int id )
{
	if( id == eUIID_TRADE_CLOSE )
	{
		/// ݱ û
		ITEMMAN->TryToTradeCancel();
	}
	else if( id == eUIID_TRADE_TRADE )
	{
		/// ŷ Ϸ û
		if( mStatus == ItemExchangeOk && mThatStatus == ItemExchangeOk )
			ITEMMAN->TryToTradeEnd();
	}
	else if( id == eUIID_TRADE_MONEYBUTTON )
	{
		/// ݾ Է¹ư
		if( mStatus == ItemExchangeBegin )
			GAMEUI->ShowMoneyWindow( eMONEY_IN, eMBEVENT_TRADE_MONEYIN );
	}
}

void cTradeWindow::OnPushButtonPressed( cUINode* , unsigned int id )
{
	switch( id )
	{
	case eUIID_TRADE_OK:
		{
			/// ǰȮοû
			if( mStatus == ItemExchangeBegin )
			{
				ITEMMAN->TryToTradeOk();
			}
			/// ǰ û
			else if( mStatus == ItemExchangeOk )
			{
				ITEMMAN->TryToTradeReTry();
			}
		}
		break;
	}
}

void cTradeWindow::OnIconDragged( cUINode* caller, unsigned int id, const cUIPos& pos, bool shift )
{
	cIcon* icon = (cIcon*)caller;
	if( icon )
		UIMAN->ShowDrag( this, DRAG_FROM_TRADE, icon, pos, shift );
}

void cTradeWindow::OnIconHovered( cUINode* caller, unsigned int id, const cUIPos& pos )
{
	cItemIcon* hoverIcon = (cItemIcon*)caller;
	sTradeItem* myItem = mMyItem;
	for( int i = 0; i < MAX_ITEM_EXCHANGE; ++i, ++myItem )
	{
		if( hoverIcon == myItem->mMyIcon )
		{
			if( myItem->mSlotIndex > MAX_INVENTORY )
				continue;

			cItem& item = ITEMMAN->GetItem( myItem->mSlotIndex );
			UIMAN->ShowItemTip( eTIP_ITEM, pos, item.GetIndex(), myItem->mSlotIndex, 0 );
			return;
		}
	}

	sThatInvetory* thatInv = mThatItem;
	for( int i = 0; i < MAX_ITEM_EXCHANGE; ++i, ++thatInv )
	{
		if( hoverIcon == thatInv->mThatIcon )
		{
			UIMAN->ShowOtherItemTip( eTIP_ITEM, pos, thatInv->mThatInv );
			return;
		}
	}
}

/// ŷڸ 
void cTradeWindow::SetNames( LPCTSTR otherName )
{
	if( mpName )
		mpName->SetText( HERO->GetName() );

	if( mpOtherName )
		mpOtherName->SetText( otherName );
}

///  κ   ȹ
int cTradeWindow::GetInvenSlot( unsigned int arrIndex )
{
	return ( arrIndex < mMyLastSlot ) ? mMyItem[arrIndex].mSlotIndex : -1;
}

bool cTradeWindow::AddMyItem( unsigned int slot )
{
	if( slot > MAX_INVENTORY )
		return false;

	///  
	cItem& item = ITEMMAN->GetItem( slot );
	cItemDefine* define = item.GetDefine();
	if( !define )
	{
		assert(0);
		return false;
	}
		
	if( mMyLastSlot >= MAX_ITEM_EXCHANGE )
	{
		assert(0);
		return false;
	}

	///  ε 
	mMyItem[mMyLastSlot].mSlotIndex = slot;

	/// ɱ - κ丮 ,   
	item.SetLock( true );

	/// trade  ̹ 
	cItemIcon* icon = mMyItem[mMyLastSlot].mMyIcon;
	if( icon )
	{
		icon->SetItemIndex( item.GetIndex() );
		icon->ChangeImage( define->GetIconParam() );
		icon->SetTipType( define->GetTipType() );
		icon->SetNumber( item.GetCount() );

		bool show = ( define->GetCapacity() > 1 ) ? true : false;
		icon->ShowNumber( show );
	}
	
	mMyLastSlot++;
	return true;
}

bool cTradeWindow::DeleteMyItem( unsigned int arrIndex )
{
	///   ƴϸ 
	if( arrIndex >= MAX_ITEM_EXCHANGE )
	{
		assert( 0 );
		return false;
	}

	/// 
	if( arrIndex >= mMyLastSlot )
	{
		assert(0);
		return false;
	}

	if( mMyItem[arrIndex].mSlotIndex > MAX_INVENTORY )
		return false;

	/// ɸ  Ǯ
	cItem& invItem = ITEMMAN->GetItem( mMyItem[arrIndex].mSlotIndex );
	invItem.SetLock( false );

	/// Կ 
	sTradeItem& myItem = mMyItem[arrIndex];
	myItem.mSlotIndex = UINT_MAX;

	cItemIcon* icon = myItem.mMyIcon;
	if( icon )
	{
		icon->ChangeImage( 0 );
		icon->SetItemIndex( 0 );
		icon->SetTipType( eTOOLTIP_NONE );
		icon->SetNumber( 0 );
	}

	UpdateMyData( arrIndex );

	if( mMyLastSlot > 0 )
		mMyLastSlot--;

	return true;
}

///  
void cTradeWindow::UpdateMyData( unsigned int index )
{
	sTradeItem* data1 = mMyItem + index;
	sTradeItem* data2 = 0;
	for( unsigned int i = index; i < mMyLastSlot-1; ++i, ++data1 )
	{
		data2 = data1 + 1;
		data1->mSlotIndex = data2->mSlotIndex;

		/// ̹ Ʈ
		cItemIcon* icon = data1->mMyIcon;
		cItemIcon* nextIcon = data2->mMyIcon;
		if( icon && nextIcon )
		{
			icon->ChangeImage( nextIcon->GetIconParam() );
			icon->SetItemIndex( nextIcon->GetItemIndex() );
			icon->SetTipType( nextIcon->GetTipType() );
			icon->SetNumber( nextIcon->GetNumber() );
			icon->ShowNumber( nextIcon->IsShowNumber() );
		}
	}

	///   ʱȭ
	sTradeItem& myItem = mMyItem[mMyLastSlot-1];
	myItem.mSlotIndex = UINT_MAX;

	cItemIcon* icon = myItem.mMyIcon;
	if( icon )
	{
		icon->ChangeImage( 0 );
		icon->SetTipType( eTOOLTIP_NONE );
		icon->SetItemIndex( 0 );
		icon->SetNumber( 0 );
	}
}

///  ŷ 
bool cTradeWindow::AddThatItem( sInventory* inv )
{
	if( mThatLastSlot >= MAX_ITEM_EXCHANGE )
	{
		assert(0);
		return false;
	}
	
	cItemDefine* define = ITEMMAN->GetItemDefine( inv->ItemIndex );
	if( !define )
	{
		assert(0);
		return false;
	}

	///  
	sThatInvetory* thatInv = &mThatItem[mThatLastSlot];
	thatInv->mThatInv = *inv;

	///  
	cItemIcon* icon = thatInv->mThatIcon;
	if( icon )
	{
		icon->ChangeImage( define->GetIconParam() );
		icon->SetTipType( define->GetTipType() );
		icon->SetNumber( inv->count );

		bool show = ( define->GetCapacity() > 1 ) ? true : false;
		icon->ShowNumber( show );
	}
	
	mThatLastSlot++;
	return true;
}

///  ŷ 
bool cTradeWindow::DeleteThatItem( sInventory* inv )
{
	if( inv->ItemIndex == 0 )
		return false;

	///  ݱ
	UIMAN->HideTip();

	sThatInvetory* thatItem = mThatItem;
	for( unsigned int i = 0; i < mThatLastSlot; ++i, ++thatItem )
	{
		sInventory& thatInv = thatItem->mThatInv;	
		if( thatInv.number == inv->number )
		{
			///   ̸, 
			thatInv.idx			= 0;
			thatInv.ItemIndex	= 0;
			thatInv.number		= 0;
			thatInv.count		= 0;
			thatInv.enhanced	= 0;
			thatInv.seal		= 0;

			///  ʱȭ
			cItemIcon* icon = thatItem->mThatIcon;
			if( icon )
			{
				icon->ChangeImage( 0 );
				icon->SetItemIndex( 0 );
				icon->SetTipType( eTOOLTIP_NONE );
				icon->SetNumber( 0 );
				icon->ShowNumber( false );
			}
			
			UpdateThatData( i );

			if( mThatLastSlot > 0 )
				mThatLastSlot--;
			return true;
		}
	}
	return true;
}

///  
void cTradeWindow::UpdateThatData( unsigned int index )
{
	sThatInvetory* data1 = mThatItem + index;
	sThatInvetory* data2 = 0;

	for( unsigned int i = index; i < mThatLastSlot-1; ++i, ++data1 )
	{
		data2 = data1 + 1;
		data1->mThatInv = data2->mThatInv;

		/// ̹ Ʈ
		cItemIcon* icon = data1->mThatIcon;
		cItemIcon* nextIcon = data2->mThatIcon;
		if( icon && nextIcon )
		{
			icon->ChangeImage( nextIcon->GetIconParam() );
			icon->SetTipType( nextIcon->GetTipType() );
			icon->SetNumber( nextIcon->GetNumber() );
			icon->ShowNumber( nextIcon->IsShowNumber() );
			icon->SetUsedFlag( false, false );
		}
	}

	///   ʱȭ
	sThatInvetory& thatInv = mThatItem[mThatLastSlot-1];
	cItemIcon* icon = thatInv.mThatIcon;
	if( icon )
	{
		icon->ChangeImage( 0 );
		icon->SetItemIndex( 0 );
		icon->SetNumber( 0 );
		icon->ShowNumber( false );
	}

	sInventory& inv = thatInv.mThatInv;
	inv.idx			= 0;
	inv.ItemIndex	= 0;
	inv.number		= 0;
	inv.count		= 0;
	inv.enhanced	= 0;
	inv.seal		= 0;
}

void cTradeWindow::AddMyMoney( unsigned long money )
{
	if( mpMyMoney )
		mpMyMoney->SetText( cNumberEditBox::FormatNumber( money ) );
}

void cTradeWindow::AddThatMoney( unsigned long money )
{
	if( mpThatMoney )
		mpThatMoney->SetText( cNumberEditBox::FormatNumber( money ) );
}

///  ŷ  
void cTradeWindow::SetStatus( eItemExchangeStatus status, bool myTurn )
{
	switch( status )
	{
	case ItemExchangeBegin:
		if( myTurn )
		{
			mStatus = status;

			mpMyOk->SetEnabled( true );
			mpMyOk->SetPress( false );

			mTradeButton->SetEnabled( false );
			mTradeButton->SetPress( false );

			/// ó
			if( mThatStatus == ItemExchangeEnd )
			{
				SetStatus( ItemExchangeOk, false );
			}
		}
		else
		{
			mThatStatus = status;

			mpThatOk->SetEnabled( false );
			mpThatOk->SetPress( false );

			/// ó
			if( mStatus == ItemExchangeEnd )
			{
				SetStatus( ItemExchangeOk, true );
			}
		}
		break;
	case ItemExchangeOk:
		if( myTurn )
		{
			mStatus = status;

			mpMyOk->SetEnabled( true );
			mpMyOk->SetPress( true );

			mTradeButton->SetEnabled( false );
			mTradeButton->SetPress( false );

			if( mThatStatus == ItemExchangeOk )
			{
				mTradeButton->SetEnabled( true );
				mTradeButton->SetPress( false );
			}
		}
		else
		{
			mThatStatus = status;

			mpThatOk->SetEnabled( false );
			mpThatOk->SetPress( true );

			if( mStatus == ItemExchangeOk )
			{
				mTradeButton->SetEnabled( true );
				mTradeButton->SetPress( false );
			}
		}
		break;
	case ItemExchangeEnd:
		if( myTurn )
		{
			mStatus = status;

			mpMyOk->SetEnabled( false );
			mpMyOk->SetPress( true );

			mTradeButton->SetEnabled( false );
			mTradeButton->SetPress( true );
		}	
		else
		{
			mThatStatus = status;

			mpThatOk->SetEnabled( false );
			mpThatOk->SetPress( true );
		}
		break;
	}
}


//
/////
//void cTradeWindow::SetStatus( eItemExchangeStatus status )
//{
//	mStatus = status;
//
//	switch( mStatus )
//	{
//	case ItemExchangeBegin:
//		if( mpMyOk )
//			mpMyOk->SetPress( false );
//
//		if( mThatStatus == ItemExchangeOk )
//		{
//			if( mTradeButton )
//				mTradeButton->SetEnabled( false );
//		}
//		else if( mThatStatus == ItemExchangeEnd )
//		{
//			mThatStatus = ItemExchangeOk;
//
//			if( mTradeButton )
//				mTradeButton->SetEnabled( false );
//		}
//		break;
//	case ItemExchangeOk: 
//		if( mpMyOk )
//			mpMyOk->SetPress( true );
//
//		/// Ѵ ǰȮλ̸ ŷȰȭ
//		if( mThatStatus == ItemExchangeOk )
//		{
//			if( mTradeButton )
//				mTradeButton->SetEnabled( true );
//		}
//		break;
//	case ItemExchangeEnd: /// ŷ
//		{
//			if( mTradeButton )
//				mTradeButton->SetEnabled( false );
//
//			if( mpMyOk )
//				mpMyOk->SetEnabled( false );
//		}
//		break;
//	}
//}
//
/////
//void cTradeWindow::SetThatStatus( eItemExchangeStatus status )
//{
//	mThatStatus = status;
//
//	switch( mThatStatus )
//	{
//	case ItemExchangeBegin:
//		if( mpThatOk )
//			mpThatOk->SetPress( false );
//
//		if( mStatus == ItemExchangeOk )
//		{
//			if( mTradeButton )
//				mTradeButton->SetEnabled( false );
//		}
//		else if( mStatus == ItemExchangeEnd )
//		{
//			mStatus = ItemExchangeOk;
//
//			if( mpMyOk )
//				mpMyOk->SetEnabled( true );
//
//			if( mTradeButton )
//			{
//				mTradeButton->SetEnabled( false );
//				mTradeButton->SetPress( false );
//			}
//		}
//		break;
//	case ItemExchangeOk:
//		if( mpThatOk )
//			mpThatOk->SetPress( true );
//
//		/// Ѵ ǰȮλ̸ ŷȰȭ
//		if( mStatus == ItemExchangeOk )
//		{
//			if( mTradeButton )
//				mTradeButton->SetEnabled( true );
//		}
//		break;
//	case ItemExchangeEnd:
//		{
//			if( mTradeButton )
//				mTradeButton->SetEnabled( false );
//		}
//		break;
//	}
//}

bool cTradeWindow::IsNetLock()
{
	if( mpMyOk && mpMyOk->IsNetLock() == true )
		return true;
	return false;
}

void cTradeWindow::OnNetLock( int lockTry )
{
	if( mpMyOk )
		mpMyOk->NetLock( lockTry );
}

void cTradeWindow::OnNetUnLock( int lockTry )
{
	if( mpMyOk )
		mpMyOk->NetUnLock( lockTry );
}