/* ==========================================================================
*    : ̼
*    : 2008.03.13
*      :  
* ǻ : 
*===========================================================================*/
#pragma once

#include "Shader.h"

///  
class cRibbonGeometry : public NiGeometry
{
public:
	cRibbonGeometry();
	~cRibbonGeometry();

	/// 
	void Clear();

	/// ʱȭ
	bool Init( unsigned int maxVerts, float pushInterval, float alphaInterval, float alphaFactor = 1.0f );

	/// ó
	void Process( float deltaTime );
	
	/// 
	void AddToVisibleArray( NiVisibleArray* alphaArray ) const;
	virtual void RenderImmediate( NiRenderer* renderer );

	///
	void SetPushEnabled( bool enabled );
	void SetPushPoint( const NiPoint3& v0, const NiPoint3& v1 );
	void SetTexture( LPDIRECT3DTEXTURE9 tex );
	//void SetBlendFactor( DWORD sourceBlend, DWORD destBlend );
	void SetCenter( const NiPoint3& center );
	
	//
	unsigned int GetNumVerts() const;

protected:
	unsigned int mMaxVerts;
	unsigned int mNumVerts;

	bool mPushEnabled;
	float mPushInterval;
	float mPushTime;
	float mAlphaInterval;
	float mAlphaTime;
	float mAlphaFactor;
	bool mTexCoordFlip;

	///
	NiPoint3 mOldPoint[2];
	NiPoint3 mPoint[2];

	/// ̴
	cShader mShader;

	/// DX9
	LPDIRECT3DTEXTURE9 mTexture;
	LPDIRECT3DVERTEXDECLARATION9 mVertexDeclaration;
	LPDIRECT3DVERTEXBUFFER9 mPosCoordBuffer;
	LPDIRECT3DVERTEXBUFFER9 mTexCoordBuffer;
	LPDIRECT3DVERTEXBUFFER9 mAlphaBuffer;
};

inline
void cRibbonGeometry::SetPushEnabled( bool enabled )
{
	mPushEnabled = enabled;
}

inline
void cRibbonGeometry::SetPushPoint( const NiPoint3& v0, const NiPoint3& v1 )
{
	mPoint[0] = v0;
	mPoint[1] = v1;
}

inline
void cRibbonGeometry::SetTexture( LPDIRECT3DTEXTURE9 tex )
{
	assert( tex );

	mTexture = tex;
}
//
//inline
//void cRibbonGeometry::SetBlendFactor( DWORD sourceBlend, DWORD destBlend )
//{
//	mSourceBlend = sourceBlend;
//	mDestBlend = destBlend;
//}

inline
void cRibbonGeometry::SetCenter( const NiPoint3& center )
{
	m_kWorldBound.SetCenter( center );
	m_kWorldBound.SetRadius( 100.0f );
}

inline
unsigned int cRibbonGeometry::GetNumVerts() const
{
	return mNumVerts;
}
