#include "StdAfx.h"
#include ".\transmonscenenode.h"

#include "ResourceManager.h"
#include "SceneManager.h"
#include "cameraManager.h"
#include "OptionManager.h"
#include "RenderSystem.h"

#include "BaseObject.h"

#include "ObjectNameCard.h"
#include "ChatBubble.h"
#include "CenterMsgPlane.h"
#include "NoticeMsgPlane.h"
#include "Signboard.h"

#include "ShadowGeometry.h"



cTransMonSceneNode::cTransMonSceneNode( eType type )
: cMonsterSceneNode( type )
, mpTarotBoard(0)
, mpUserSellBoard(0)
, mpQuestPlane(0)
, mpFieldTargetEffect(0)
, mpNoticePlane(0)
{
	mFieldEffectOn = false;
}

cTransMonSceneNode::~cTransMonSceneNode()
{
	SAFE_DELETE( mpFieldTargetEffect );
	SAFE_DELETE( mpNoticePlane );
	SAFE_DELETE( mpQuestPlane );
	SAFE_DELETE( mpUserSellBoard );
	SAFE_DELETE( mpTarotBoard );
}

bool cTransMonSceneNode::Init( const cMonsterSceneNodeParam& param, bool hero )
{
	if( cDynamicSceneNode::Init( param ) == false )
	{
		return false;
	}

	mHeadDist = param.mHeadHeight;

	/// ǳ ü 
	mpTarotBoard = new cTarotSignboard;
	if( mpTarotBoard == 0 )
	{
		assert(0);
		return false;
	}
	mpUserSellBoard = new cUseSellSignboard;
	if( mpUserSellBoard == 0 )
	{
		assert(0);
		return false;
	}
	mpChatBubble = new cChatBubble;
	if( mpChatBubble == 0 )
	{
		assert(0);
		return false;
	}

	if( hero )
	{
		mpQuestPlane = new cCenterMsgPlane;
		if( mpQuestPlane == 0 )
		{
			assert(0);
			return false;
		}

		mpNoticePlane = new cNoticeMsgPlane;
		if( mpNoticePlane == 0 )
		{
			assert(mpNoticePlane);
			return false;
		}

		mpFieldTargetEffect = new cShadowGeometry();
		if( mpFieldTargetEffect->Init( RESOURCEMAN->GetFieldTargetTexture(), 1.0f ) == false )
		{
			assert(mpFieldTargetEffect);
			return false;
		}
	}

	return true;
}

void cTransMonSceneNode::OnProcess( unsigned long deltaTime, unsigned long accumTime )
{
	cMonsterSceneNode::OnProcess( deltaTime, accumTime );

	if( mpQuestPlane )
		mpQuestPlane->Update( deltaTime );

	if( mpNoticePlane )
		mpNoticePlane->Update( deltaTime, accumTime );
}

void cTransMonSceneNode::AddToVisibleArray()
{
	if( SCENEMAN->IsScreenShotMode() == true )
		return;

	cDynamicSceneNode::AddToVisibleArray();
}

void cTransMonSceneNode::AddDepthPlaneObject()
{
	if( mpQuestPlane && mpQuestPlane->IsActive() )
	{
		SCENEMAN->AddPlane( mpQuestPlane );
	}

	if( mpNoticePlane && mpNoticePlane->IsActive() )
	{
		SCENEMAN->AddPlane( mpNoticePlane );
	}

	///
	bool showName = true;
	unsigned int optionHeight = 0;

	/// Ÿ &   ߰
	if( mpTarotBoard && mpTarotBoard->IsActive() )
	{
		SCENEMAN->AddPlane( mpTarotBoard );

		mpTarotBoard->SetPos( mHeadScreenPosX, mHeadScreenPosY );
		optionHeight += mpTarotBoard->GetBoardHeight()+5;

		showName = false;
	}
	else if( mpUserSellBoard && mpUserSellBoard->IsActive() )
	{
		SCENEMAN->AddPlane( mpUserSellBoard );
		mpUserSellBoard->SetPos( mHeadScreenPosX, mHeadScreenPosY );

		optionHeight += mpUserSellBoard->GetBoardHeight()+5;
		showName = false;
	}

	NiPoint3 pos = this->GetWorldTranslate();
	pos.z = mpHead->GetWorldTranslate().z;
	pos.z += mHeadDist;

	NiPoint3 camPos = CAMERAMAN->GetCurrentNi()->GetWorldTranslate();
	float distCam = (pos - camPos).Length();

	/// ǳ ̱ 
	if( OPTIONMAN->IsShowBubble() )
	{
		if( mpChatBubble && mpChatBubble->IsActive() )
		{
			/// ǳ 
			SCENEMAN->AddPlane( mpChatBubble );
			mpChatBubble->SetPos( mHeadScreenPosX, mHeadScreenPosY - (optionHeight+5) );

			optionHeight += mpChatBubble->GetBubbleHeight()+5;
		}
	}

	if( mpNameCard && showName == true )
	{
		if( distCam < 1500.0f )
			distCam = 1500.0f;
		if( distCam > 10000.0f )
			distCam = 10000.0f;

		if( mShowNameGauge )
			mpNameCard->SetEnableGauge( true );
		else
			mpNameCard->SetEnableGauge( false );

		mpNameCard->Set2DPos( mHeadScreenPosX, mHeadScreenPosY - (optionHeight+5), mFootScreenPosX, mFootScreenPosY+20 );
		SCENEMAN->AddPlane( mpNameCard );
	}
}

void cTransMonSceneNode::ActiveQuestText( LPCTSTR msg, unsigned long color )
{
	if( mpQuestPlane == 0 )
		return;

	if( mpHead == 0 || mpFoot == 0 )
	{
		assert(0);
		return;
	}

	NiPoint3 pos = mpFoot->GetWorldTranslate();
	pos.z += mpGameObject->GetStatureValue() + mHeadDist;

	mpQuestPlane->ActiveMsg( msg, pos, color );
}

void cTransMonSceneNode::ActiveNoticeText( LPCTSTR msg, unsigned long color )
{
	if( mpNoticePlane == 0 )
		return;

	mpNoticePlane->ActiveMsg( msg, color );
}

void cTransMonSceneNode::ActiveTarotBubble( LPTSTR title, unsigned long color )
{
	if( mpTarotBoard )
		mpTarotBoard->Active( mpGameObject->GetName(), title, color, true );
}

void cTransMonSceneNode::DeActiveTarotBubble()
{
	if( mpTarotBoard )
		mpTarotBoard->DeActive();
}

void cTransMonSceneNode::ActiveUserSellBubble( LPTSTR title, unsigned long color )
{
	if( mpUserSellBoard )
		mpUserSellBoard->Active( mpGameObject->GetName(), title, color, true );
}

void cTransMonSceneNode::DeActiveUserSellBubble()
{
	if( mpUserSellBoard )
		mpUserSellBoard->DeActive();
}

cObjectNameCard* cTransMonSceneNode::CreateNameCard( cBaseObject* pObj )
{
	if( !pObj )
	{
		assert(0);
		return 0;
	}
	return new cPlayerNameCard( pObj );
}

void cTransMonSceneNode::SetFieldEffRadius( float r )
{
	if( mpFieldTargetEffect == 0 )
		return;
	mpFieldTargetEffect->SetRadius( r );
}

void cTransMonSceneNode::UpdateFieldTargetEffect( NiPoint3 center )
{
	if( mpFieldTargetEffect == 0 )
		return;

	mFieldEffectOn = true;
	mFieldEffectCenter = center;
}

bool cTransMonSceneNode::OnVisible()
{
	bool check = cMonsterSceneNode::OnVisible();

	if( check && mFieldEffectOn )
	{
		mFieldEffectOn = false;
		mpFieldTargetEffect->Process( true, mFieldEffectCenter, 0.9f );
	}
	return check;
}
