/* ==========================================================================
*      : TriggerManager.h
*      : 
*    : 谡
*    : 2008-08-01
* ǻ :
*===========================================================================*/
#pragma once
#include "Quest_Common.h"

/// Ʈ 
class cTrigger
{
	friend class cQuestManager;
	friend class cTriggerManager;

public:
	cTrigger();

private:
	/// ߻ Ʈ ε
	unsigned long mQuestIndex;

	///  
	short mLowLevel;

	/// ְ 
	short mHighLevel;

	/// 
	short mRace[2];

	///  
	typedef tHashSet<unsigned long> cJobSet;
	cJobSet mJobSet;

	/// ؾϴ 
	sQuestItem mHaveItem[QUEST_ITEM_MAX];

	/// ƮŴ - Ϸ  
	///   Ʈ ε
	typedef tArray<unsigned long> cLinkQuestArr;
	cLinkQuestArr mLinkQuestArr;

	/// ɷ־ ϴ ȿƮ
	unsigned long mSkillArray[QUEST_BUFF_MAX];
};


/// Ʈ Ŵ
class cTriggerManager
{
	static cTriggerManager* mpSingleton;

public:	
	cTriggerManager();
	~cTriggerManager();

	bool Init();
	void Clear();
	
	bool AddTrigger( unsigned long questIdx, cTrigger* trigger );
	void DeleteTrigger( unsigned long questIdx );

protected:
	cTrigger* GetTrigger( unsigned long questIdx );

public:
	static cTriggerManager* GetSingleton();

private:
	/// Ʈ  (questidx, cTrigger*)
	typedef tPointerHashMap<unsigned long, void*> cTriggerMap;
	cTriggerMap mTriggerMap;
};

inline
cTriggerManager* cTriggerManager::GetSingleton()
{
	return mpSingleton;
}

#define TRIGGERMAN cTriggerManager::GetSingleton()

