#include "StdAfx.h"
#include "UIBackWindow.h"
#include "UIWindow.h"
#include "planeobject.h"

cUIBackWindow::cUIBackWindow( eUINodeType type )
: cUIWindow( type )
, mpPlane(0)
{
}

cUIBackWindow::~cUIBackWindow()
{
	SAFE_DELETE(mpPlane);
}

/// ǻ : 
bool cUIBackWindow::SetSkin( const cUINodeSkin* pskin )
{
	if( pskin->IsKindof( eUINODE_WINDOW ) == false )
	{
		assert( 0 && "not window type" );
		return false;
	}

	///  Ų ռ ˻
	if( pskin->IsValid() == false )
	{
		assert( 0 && "invalid skin" );
		return false;
	}

	/// ̹ 
	if( pskin->mpTexture )
	{
		/// ؽó  
		unsigned short tx = (unsigned short)pskin->mSkinInfo->mTexX;
		unsigned short ty = (unsigned short)pskin->mSkinInfo->mTexY;
		unsigned short tw = (unsigned short)pskin->mSkinInfo->mTexWidth;
		unsigned short th = (unsigned short)pskin->mSkinInfo->mTexHeight;

		if( mpPlane == 0 )
		{
			mpPlane = new cPlaneObject;

			if( mpPlane->Create( pskin->mpTexture, 0, 0, 
								(unsigned short)GetScreenWidth(), (unsigned short)GetScreenHeight(),
								tx, ty, tx + tw, ty + th ) == false )
			{
				assert( 0 && "failed to create back image");
				return false;
			}
		}
		else
		{
			mpPlane->SetTextureRect( tx, ty, tx + tw, ty + th );
		}
	}
	else
	{
		SAFE_DELETE( mpPlane );
	}

	/// ũ ġ ǥ  
	unsigned int x = pskin->mSkinInfo->mX;
	unsigned int y = pskin->mSkinInfo->mY;
	unsigned int w = pskin->mSkinInfo->mWidth;
	unsigned int h = pskin->mSkinInfo->mHeight;

	SetRelativeRect( cUIRect(x, y, x + w, y + h) );
	return true;
}

//void cUIBackWindow::SetAlphaEnabled( bool enabled, NiAlphaProperty::AlphaFunction srcBlend, NiAlphaProperty::AlphaFunction destBlend )
//{
//	///  ɼ 
//	NiAlphaProperty* alphaProp = mpPlane->GetAlphaProp();
//	alphaProp->SetAlphaBlending( enabled );
//
//	if( enabled )
//	{
//		alphaProp->SetSrcBlendMode( srcBlend );
//		alphaProp->SetDestBlendMode( destBlend );
//	}
//}

/// ǻ : 
void cUIBackWindow::UpdateSkin()
{
}

/// ǻ : 
void cUIBackWindow::OnRender( cUIFontItemKeeper* fontKeeper )
{
	///  ̹ 
	if( mpPlane )
		mpPlane->Draw();

	cUIWindow::OnRender( fontKeeper );
}

/// ǻ : 
void cUIBackWindow::OnMouseMove( const cUIPos& )
{
}

/// ǻ : 
void cUIBackWindow::OnLButtonDown( const cUIPos&, bool , bool , bool )
{
}

void cUIBackWindow::SetBackTexture( NiTexture* tex )
{
	if( tex == 0 )
	{
		SAFE_DELETE(mpPlane);
		return;
	}

	mpPlane = new cPlaneObject;
	if( mpPlane->Create( tex, 0, 0, (unsigned short)GetScreenWidth(), (unsigned short)GetScreenHeight(),
			0, 0, tex->GetWidth(), tex->GetHeight() ) == false )
	{
		assert( 0 && "failed to create back image");
		NiMessageBox("failed to create back image","Error");
		return;
	}
}

void cUIBackWindow::SetAlpha( float alpha )
{
	if( mpPlane )
		mpPlane->SetColorA( 1.0f, 1.0f, 1.0f, alpha );
}