#include "StdAfx.h"
#include "UIContainer.h"

#include "InputSystem.h"
#include "TabWindow.h"
#include "RadioButton.h"

#include "UIManager.h"
#include "UIRootNode.h"

cUIContainerSkin::cUIContainerSkin( eUINodeType type )
: cUINodeSkin( type )
{
}

cUIContainerSkin::~cUIContainerSkin()
{
}

/////////////////////////////////////////////////////////////////////////////////////////////
cUIContainer::cUIContainer( eUINodeType type )
: cUINode( type ) 
{
	mOnlyBackground = false;
	mHoldView = false;
	mExceptSnap = false;
}

/// ǻ : 
cUIContainer::~cUIContainer()
{
	/// ڽĵ鿡 ˸
	cChildList::cIterator i = mChildList.Begin();
	cChildList::cIterator end = mChildList.End();

	for( ; i != end; ++i )
	{
		cUINode* n = (cUINode*)(*i);
		if( n )
		{
			n->mpParent = 0;
			delete n;
		}
		else
		{
			assert(0);
		}
	}
}

/// ǻ : ϵ   ( ͱ η  )
void cUIContainer::RemoveChildComplete( cUINode* pchild )
{
	cChildList::cIterator i = mChildList.Begin();
	cChildList::cIterator end = mChildList.End();

	for( ; i != end; ++i )
	{
		cUINode* n = (cUINode*)(*i);

		if( n == pchild )
		{
			UIMAN->GetRootNode()->RemoveProcessChild( n );

			mChildList.Erase( i );
			n->mpParent = 0;
			SAFE_DELETE( n );

			return;
		}
	}
}

/// ǻ : 
void cUIContainer::RemoveChild( cUINode* pchild )
{
	cChildList::cIterator i = mChildList.Begin();
	cChildList::cIterator end = mChildList.End();

	for( ; i != end; ++i )
	{
		cUINode* n = (cUINode*)(*i);

		if( n == pchild )
		{
			UIMAN->GetRootNode()->RemoveProcessChild( n );
			n->mpParent = 0;
			mChildList.Erase( i );

			return;
		}
	}
}

/// ǻ : 
void cUIContainer::UpdateRect()
{
	cUINode::UpdateRect();

	/// ڽ 
	cChildList::cIterator i = mChildList.Begin();
	cChildList::cIterator end = mChildList.End();

	for( ; i != end; ++i )
	{
		cUINode* n = (cUINode*)(*i);

		if( n )
		{
			n->UpdateRect();
		}
	}
}

/*
	ڱ updateskin 
	ڱ updaterect
	ڽ updaterect

	ڽ updateskin
	ڱ updaterect 

	⺻ 2 ȣ 
*/
void cUIContainer::UpdateSkin()
{
	cUINode::UpdateSkin();

	/// ڽ Ų 
	cChildList::cIterator i = mChildList.Begin();
	cChildList::cIterator end = mChildList.End();

	for( ; i != end; ++i )
	{
		cUINode* n = (cUINode*)(*i);

		if( n )
			n->UpdateSkin();
	}
}

void cUIContainer::NetUnLockAllUI()
{
	cUINode::NetUnLockAllUI();

	/// ڽ 
	cChildList::cIterator i = mChildList.Begin();
	cChildList::cIterator end = mChildList.End();

	for( ; i != end; ++i )
	{
		cUINode* n = (cUINode*)(*i);

		if( n )
			n->NetUnLockAllUI();
	}
}

/// ǻ : 
void cUIContainer::AddChild( cUINode* pchild )
{
	if( pchild )
	{
//		if( pchild->mpParent )
//		{
//			pchild->mpParent->RemoveChild( pchild );
//		}
//		pchild->mpParent = this;
		mChildList.PushBack( pchild );
	}
}

/// ǻ : Ʈ ڽ 
int cUIContainer::AddEditBox( cUINode* pchild )
{
	int i = 0;
	if( pchild )
	{
		i = mEditArr.GetSize();
		mEditArr.PushBack( pchild );
	}
	else
	{
		assert( 0 && "null node" );
		return -1;
	}
	return i;
}

/// ǻ : Ŀ  Ʈ ڽ ü
///  Լ ̳ ο ϴ EditBox  Ŀ ̵ Ѵ.
void cUIContainer::ChangeFocus( unsigned int index )
{
	/// error check
	if( index >= mEditArr.GetSize() )
	{
		assert( 0 && "index out of range" );
		return ;
	}

	unsigned int newFocus = index + 1;
	if( newFocus >= mEditArr.GetSize() )
	{
		newFocus = 0;
	}

	((cUINode*)mEditArr[newFocus])->SetFocus();
}


/// ǻ :  ư  ( ׷ѹ,  )
void cUIContainer::AddRadio( unsigned int groupNum, cUINode* pchild )
{
	if( !pchild )
	{
		assert( 0 && "null node" );
		return;
	}

	/// ׷ѹ 0  ʾ !!
	if( groupNum > mHeadRadioArr.GetSize() )
	{	
		assert( 0 && "error!! start group number at 0" );
		return;
	}

	/// ׷ ó   .
	if( mHeadRadioArr.GetSize() == groupNum ) 
	{
		mHeadRadioArr.PushBack( pchild );
	}
	else
	{
		/// ̹ ϴ ׷ȣ̸, Ų
		((cRadioButton*)mHeadRadioArr[groupNum])->Link( pchild );
	}
}

/// ǻ : ش׷   ư  
cUINode* cUIContainer::GetHeadRadio( unsigned int groupNum )
{
	if( groupNum >= mHeadRadioArr.GetSize() )
	{
		assert( 0 && "wrong radio group num");
		return 0;
	}

	return (cUINode*)mHeadRadioArr[groupNum];
}

/// ǻ : θ ؿ شid  ڽ ã
cUINode* cUIContainer::GetChild( int id, bool cascade ) const
{
	cUINode* n = 0;
	cChildList::cConstIterator i = mChildList.Begin();
	cChildList::cConstIterator end = mChildList.End();

	for( ; i != end; ++i )
	{
		n = (cUINode*)(*i);

		if( n->GetID() == id )
		{
			return n;
		}
		/// cascade ڽĵ ˻
		if( cascade && n->IsKindof( eUINODE_CONTAINER ) )
		{
			n = ((cUIContainer*)n)->GetChild( id, true );
			
			if( n )
			{
				return n;
			}
		}
	}
	return 0;
}

cUINode* cUIContainer::GetNode( const cUIPos& pos ) const
{
	///   켱 ˻
	if( mVisible && cUINode::ContainPoint( pos ) == true )
	{
		cUINode* node = 0;

		/// ȭ տ ڷ ˻
		cChildList::cConstIterator i = (--mChildList.End());
		cChildList::cConstIterator end = (--mChildList.Begin());

		for( ; i != end; --i )
		{
			cUINode* n = (cUINode*)(*i);

			if( n->IsEnabled() == false || n->IsVisible() == false )
				continue;

			if( n->IsKindof( eUINODE_CONTAINER ) )
			{
				node = ((cUIContainer*)n)->GetNode( pos );
			}
			else if( n->ContainPoint( pos ) )
			{
				if( n->IsExceptEvent() == false )
					node = n;
			}

			/// ؽ   ˻ 
			if( node && node->ContainPoint( pos ) )
				return node;
		}

		/// ̺Ʈ , Ȥ ո ؽ ˻
		if( mExceptionEvent == false && ContainPoint( pos ) == true )
			return (cUINode*)this;
		else
			return 0;
	}
	else
		return 0;
}

/// ǻ : ־  ϴ  ִ ̳ʸ  (  Ʈ ڽĵ鸸  )
cUIContainer* cUIContainer::GetNearRootChild( cUIContainer* con, bool axisX )
{
	/*
		ƿ ҽ ġ,
		巡 츸 óϵ . 
	*/
	cUIRect rect;

	///  ε ٱ⶧  ( AUTO_MAGNATIC_DIST / 2 ) ȼ,
	/// ٱ ( AUTO_MAGNATIC_DIST / 2 ) ȼ ؼ ˻ϵ Ѵ 
	rect.mLeft = con->GetAbsoluteRect().mLeft - ( AUTO_MAGNATIC_DIST / 2 );
	rect.mRight = con->GetAbsoluteRect().mRight + ( AUTO_MAGNATIC_DIST / 2 );
	rect.mTop = con->GetAbsoluteRect().mTop - ( AUTO_MAGNATIC_DIST / 2 );
	rect.mBottom = con->GetAbsoluteRect().mBottom + ( AUTO_MAGNATIC_DIST / 2 );

	cUIContainer* result = 0;
	
	/// 巡  
	if( con->IsKindof( eUINODE_DRAGWINDOW ) == true )
	{
		return 0;
	}

	/// ڱ ڽ visible ̰  ̳ʾ Ѵ. 
	if( mVisible && IsKindof( eUINODE_CONTAINER ) )
	{
		cChildList::cConstIterator i = (--mChildList.End());
		cChildList::cConstIterator end = (--mChildList.Begin());

		cUIContainer* pleftCon = 0;
		cUIContainer* prightCon = 0;
		cUIContainer* ptopCon = 0;
		cUIContainer* pbottomCon = 0;
		///   ִܰŸ
		unsigned int rDist = 0;
		unsigned int lDist = 0;
		unsigned int tDist = 0;
		unsigned int bDist = 0;

		for( ; i != end; --i )
		{
			cUIContainer* n = (cUIContainer*)(*i);

			/// 񱳴 vislble ° ƴϰų  ڽŰ ϰų, ׶ ѱ 
			/// ڼ ˻ ̸ܴ ѱ
			if( n->IsVisible() == false || con == n || 
				n->IsOnlyBackground() || n->IsExceptSnap() == true )
			{
				continue;
			}

			///   ̳ ãƼ Ѵ 
			if( rect.IntersectRect( n->GetAbsoluteRect() ) )
			{			
				//// x ˻ 
				if( axisX == true )
				{
					///     ̳ ã 
					if( rect.mRight - AUTO_MAGNATIC_DIST <= n->GetAbsoluteRect().mLeft ) 
					{
						if( prightCon == 0 || prightCon->GetAbsoluteRect().mLeft > n->GetAbsoluteRect().mLeft )
						{
							/// right    ̳  
							prightCon = n;
							rDist = n->GetAbsoluteRect().mLeft - rect.mRight - AUTO_MAGNATIC_DIST;
						}
					}
					///     ̳ ã 
					if( rect.mLeft + AUTO_MAGNATIC_DIST >= n->GetAbsoluteRect().mRight ) 
					{
						if( pleftCon == 0 || pleftCon->GetAbsoluteRect().mRight < n->GetAbsoluteRect().mRight )
						{	
							/// left    ̳ʰ   
							pleftCon = n;
							lDist = rect.mLeft + AUTO_MAGNATIC_DIST - n->GetAbsoluteRect().mRight;
						}
					}
					///  ִ  left  Ÿ  ٿ 
					if( rect.mLeft >= n->GetAbsoluteRect().mLeft && rect.mLeft - n->GetAbsoluteRect().mLeft <= 0 ||
						rect.mLeft <= n->GetAbsoluteRect().mLeft && n->GetAbsoluteRect().mLeft - rect.mLeft <= AUTO_MAGNATIC_DIST )
					{
						con->mSnapType = eSNAP_LEFT_OUT;
						return n;
					}
					///  ִ  right  Ÿ  ٿ 
					if( rect.mRight >= n->GetAbsoluteRect().mRight && rect.mRight - n->GetAbsoluteRect().mRight <= AUTO_MAGNATIC_DIST ||
						rect.mRight <= n->GetAbsoluteRect().mRight && n->GetAbsoluteRect().mRight - rect.mRight <= 0 )
					{
						con->mSnapType = eSNAP_RIGHT_OUT;
						return n;
					}
				}
				/// Y ˻ 
				else if( axisX == false )
				{
					///     ̳ ã 
					if( rect.mTop + AUTO_MAGNATIC_DIST >= n->GetAbsoluteRect().mBottom ) 
					{
						if( ptopCon == 0 || ptopCon->GetAbsoluteRect().mTop > n->GetAbsoluteRect().mTop )
						{
							ptopCon = n;
							tDist = rect.mTop + AUTO_MAGNATIC_DIST - n->GetAbsoluteRect().mBottom;
						}
					}
					/// Ʒ    ̳ ã 
					if( rect.mBottom - AUTO_MAGNATIC_DIST <= n->GetAbsoluteRect().mTop ) 
					{
						if( pbottomCon == 0 || pbottomCon->GetAbsoluteRect().mTop < n->GetAbsoluteRect().mTop )
						{
							pbottomCon = n;
							bDist = n->GetAbsoluteRect().mBottom - rect.mBottom - AUTO_MAGNATIC_DIST;
						}
					}
					///  ִ  top  Ÿ  ٿ 
					if( rect.mTop >= n->GetAbsoluteRect().mTop && rect.mTop - n->GetAbsoluteRect().mTop <= 0 ||
						rect.mTop <= n->GetAbsoluteRect().mTop && n->GetAbsoluteRect().mTop - rect.mTop <= AUTO_MAGNATIC_DIST )
					{
						con->mSnapType = eSNAP_TOP_OUT;
						return n;
					}
					///  ִ  bottom  Ÿ  ٿ 
					if( rect.mBottom >= n->GetAbsoluteRect().mBottom && rect.mBottom - n->GetAbsoluteRect().mBottom <= AUTO_MAGNATIC_DIST ||
						rect.mBottom <= n->GetAbsoluteRect().mBottom && n->GetAbsoluteRect().mBottom - rect.mBottom <= 0 )
					{
						con->mSnapType = eSNAP_BOTTOM_OUT;
						return n;
					}
				}
			}
		}

		///  ˻簡  尡 ̳ʸ 
		/// x  
		if( axisX == true )
		{
			if( prightCon == 0 )
			{
				con->mSnapType = eSNAP_RIGHT;	/// ʿ ٿ 
				result = pleftCon;
			}
			else if( pleftCon == 0 ) 
			{
				con->mSnapType = eSNAP_LEFT;
				result =  prightCon;
			}
			else if( rDist <= lDist )
			{
				con->mSnapType = eSNAP_LEFT;
				result = prightCon;			
			}
			else if( rDist > lDist )
			{
				con->mSnapType = eSNAP_RIGHT;
				result = pleftCon;
			}
		}
		/// y   
		else if( axisX == false )
		{
			if( ptopCon == 0 )
			{
				con->mSnapType = eSNAP_TOP;
				result =  pbottomCon;
			}
			else if( pbottomCon == 0 ) 
			{
				con->mSnapType = eSNAP_BOTTOM;
				result =  ptopCon;
			}
			else if( tDist >= bDist )
			{
				con->mSnapType = eSNAP_BOTTOM;
				result =  ptopCon;			
			}
			else if( tDist < bDist )
			{
				con->mSnapType = eSNAP_TOP;
				result =  pbottomCon;
			}
		}
	}
	return result;
}

/// ǻ : 
bool cUIContainer::HandleEvent( const cUIEvent& event )
{
	/// θ   ڽĵ ̺Ʈ ó Ұ
	if( mVisible == false )
	{
		return false;
	}

	switch( event.mType )
	{
	case eUIEVENT_COMMAND:
		switch( event.mID )
		{
		case eUIID_OK:
			OnOk();
			break;
		case eUIID_CANCEL:
			OnCancel();
			break;
		default:
			OnCommand( event.mpCaller, event.mID );
		}
		break;

	case eUIEVENT_CHECKBOX_CHANGED:
		OnCheckBoxChanged( event.mpCaller, event.mID );
		break;

	case eUIEVENT_EDITBOX_ENTER:
		OnEditBoxEntered( event.mpCaller, event.mID );
		break;

	case eUIEVENT_LISTBOX_CHANGED:
		OnListBoxChanged( event.mpCaller, event.mID );
		break;

	case eUIEVENT_SCROLLBAR_MOVE:
		OnScrollbarMoved( event.mpCaller, event.mID );
		break;

		/// ð ư    .
	case eUIEVENT_BUTTON_DOWNED:
		OnButtonDowned( event.mpCaller, event.mID );
		break;

		/// ÷װ õǾ  μ  ̺Ʈ ߻
	case eUIEVENT_BUTTON_CONTINUEDOWNED:
		OnButtonContinueDowned( event.mpCaller, event.mID );
		break;

	case eUIEVENT_LISTBOX_SELECTED:
		OnListBoxSelected( event.mpCaller, event.mID );
		break;

	case eUIEVENT_LISTBOX_SELECTEDRBUTTON:
		OnListBoxSelectedRButton( event.mpCaller, event.mID, event.mShift );
		break;

		///  ư  ̺Ʈ 
	case eUIEVENT_RADIO_PRESSED:
		OnRadioPressed( event.mpCaller, event.mID );
		break;

		/// Ǫư  ̺Ʈ 
	case eUIEVENT_PUSHBUTTON_PRESSED:
		OnPushButtonPressed( event.mpCaller, event.mID );
		break;

		/// ǹư 
	case eUIEVENT_TABBUTTON_PRESSED:
		OnTabButtonPressed( event.mpCaller, event.mID );
		break;

	case eUIEVENT_ICON_DRAGGED:
 		OnIconDragged( event.mpCaller, event.mID, cUIPos(MOUSE->GetMouseX(), MOUSE->GetMouseY()), event.mShift );
		break;

	case eUIEVENT_ICON_DOUBLECLICKED:
		OnIconDoubleClicked( event.mpCaller, event.mID );
		break;

	case eUIEVENT_ICON_HOVERED:
		OnIconHovered( event.mpCaller, event.mID, cUIPos(MOUSE->GetMouseX(), MOUSE->GetMouseY()) );
		break;

	case eUIEVENT_ICON_CLICKED:
		OnIconClicked( event.mpCaller, event.mID );
		break;

	case eUIEVENT_ICON_RIGHTCLICKED:
		OnIconRightClicked( event.mpCaller, event.mID, event.mShift );
		break;
	case eUIEVENT_IMAGE_HOVERED:
		OnImageHovered( event.mpCaller, event.mID, cUIPos(MOUSE->GetMouseX(), MOUSE->GetMouseY()) );
		break;
	case eUIEVENT_IMAGE_CLICKED:
		OnImageClicked( event.mpCaller, event.mID );
		break;
	case eUIEVENT_LISTBOX_ROW_HOVERED:
		OnListBoxRowHovered( event.mpCaller, event.mID, event.mPos, event.mExtraData );
		break;
	case eUIEVENT_LISTBOX_ROW_LEFT:
		OnListBoxRowLeft( event.mpCaller, event.mID );
		break;
	case eUIEVENT_LISTBOX_IMAGE_HOVERED:
		OnListBoxImageHorvered( event.mpCaller, event.mID, event.mPos, event.mExtraData );
		break;
	case eUIEVENT_LISTBOX_IMAGE_LEFT:
		OnListBoxImageLeft( event.mpCaller, event.mID );
		break;

		///  ǥġ Ϸ
	case eUIEVENT_GAUGE_END:
		OnGaugeEnd( event.mpCaller, event.mID );
		break;

	case eUIEVENT_COMBO_SELECTED:
		OnComboSelected( event.mpCaller, event.mID );
		break;

	case eUIEVENT_OPTIONGAUGE_UPDATE:
		OnOptiongaugeUpdate( event.mpCaller, event.mID );
		break;

	case eUIEVENT_MOUSE_OTHERCLICK:
		OnMouseOtherClick( event.mPos );
		break;

	default:
		return cUINode::HandleEvent( event );
	}
	return true;
}