/* ==========================================================================
*      : UIContainer.h
*      : 
*    : ̼
*    : 2006.09.29
* ǻ : 
*===========================================================================*/
#pragma once
#include "UINode.h"
#include "UINodeData.h"

/// UI ̳ Ų
class cUIContainerSkin : public cUINodeSkin
{
public:
	cUIContainerSkin( eUINodeType type = eUINODE_CONTAINER );
	virtual ~cUIContainerSkin();
};

/////////////////////////////////////////////////////////////////////////////////////

/// UI ̳
/// ٸ UI 带 ڽ   ִ.
class cUIContainer : public cUINode
{
public:
	/// 
	virtual void UpdateRect();

	/// Ų
	virtual void UpdateSkin();
	

	/// ̺Ʈ ó
	virtual bool HandleEvent( const cUIEvent& event );

	/// ڽ ߰
	virtual void AddChild( cUINode* pchild );

	/// ڽ 
	virtual void RemoveChild( cUINode* pchild );

	/// θκ ڽ  ( ͱ ش )
	virtual void RemoveChildComplete( cUINode* pchild );

	/// ڽ Ʈ 
	tPointerList<void*>* GetChildList();

	/// ڽ 
	cUINode* GetChild( int id, bool cascade = false ) const;

	/// 带 
	/// ġ  ڽ Ǵ ڱ ڽ Ѵ.
	cUINode* GetNode( const cUIPos& pos ) const;

	/// ̳ʸ 
	/// Ʈ child  ش    ̳ʸ ã´ 
	cUIContainer* GetNearRootChild( cUIContainer* con, bool axisX );

	/// ׶  
	void SetOnlyBackground( bool value );

	///  Ȧ  
	void SetHoldView( bool hold );

	/// ׶   
	bool IsOnlyBackground();

	/// ݵ ϴ   
	bool IsHoldView();

	////// Ư ڽ  
	/// Ŀ  Ʈ ڽ ü 
	void ChangeFocus( unsigned int index );

	/// Ʈڽ  
	int AddEditBox( cUINode* pchild );

	///  ư  
	void AddRadio( unsigned int groupNum, cUINode* pchild );

	///   ư  
	cUINode* GetHeadRadio( unsigned int groupNum );

	/// ڼ 뿩 ( ٸ ̳ʰ ٰ   )
	void SetExceptSnap( bool set );
    bool IsExceptSnap();	/// ڼ˻ ܿ

	///  UI   Ǯ
	void NetUnLockAllUI();

protected:
	cUIContainer( eUINodeType type = eUINODE_CONTAINER );
	virtual ~cUIContainer();

protected:
	/// ̺Ʈ
	virtual void OnOk() {}
	virtual void OnCancel() {}
	virtual void OnCommand( cUINode* /*caller*/, unsigned int /*id*/ ) {}
	virtual void OnCheckBoxChanged( cUINode* /*caller*/, unsigned int /*id*/ ) {}
	virtual void OnEditBoxEntered( cUINode* /*caller*/, unsigned int /*id*/ ) {}
	virtual void OnListBoxChanged( cUINode* /*caller*/, unsigned int /*id*/ ) {}
	virtual void OnListBoxSelected( cUINode* /*caller*/, unsigned int /*id*/ ) {}
	virtual void OnListBoxSelectedRButton( cUINode* /*caller*/, unsigned int /*id*/, bool /*shift*/ ) {}
	virtual void OnScrollbarMoved( cUINode* /*caller*/, unsigned int /*id*/ ) {}
	virtual void OnButtonDowned( cUINode* /*caller*/, unsigned int /*id*/ ) {}
	virtual void OnButtonContinueDowned( cUINode* /*caller*/, unsigned int /*id*/ ) {}
	virtual void OnRadioPressed( cUINode* /*caller*/, unsigned int /*id*/ ) {}
	virtual void OnPushButtonPressed( cUINode* /*caller*/, unsigned int /*id*/ ) {}
	virtual void OnTabButtonPressed( cUINode* /*caller*/, unsigned int /*id*/ ) {}
	virtual void OnIconHovered( cUINode* /*caller*/, unsigned int /*id*/, const cUIPos& /*pos*/ ) {}
	virtual void OnIconLeft( cUINode* /*caller*/, unsigned int /*id*/ ) {}
	virtual void OnIconDragged( cUINode* /*caller*/, unsigned int /*id*/, const cUIPos& /*pos*/, bool /*shift*/ ) {}
	virtual void OnIconDoubleClicked( cUINode* /*caller*/, unsigned int /*id*/ ) {}
	virtual void OnIconClicked( cUINode* /*caller*/, unsigned int /*id*/ ) {}
	virtual void OnIconRightClicked( cUINode* /*caller*/, unsigned int /*id*/, bool /*shift*/ ) {}
	virtual void OnImageHovered( cUINode* /*caller*/, unsigned int /*id*/, const cUIPos& /*pos*/ ) {}
	virtual void OnImageClicked( cUINode* /*caller*/, unsigned int /*id*/ ) {}
	virtual void OnListBoxRowHovered( cUINode* /*caller*/, unsigned int /*id*/, const cUIPos& /*pos*/, void* /*extraData*/ ) {}
	virtual void OnListBoxRowLeft( cUINode* /*caller*/, unsigned int /*id*/ ) {}
	virtual void OnListBoxImageHorvered( cUINode* /*caller*/, unsigned int /*id*/, const cUIPos& /*pos*/, void* /*extraData*/ ) {}
	virtual void OnListBoxImageLeft( cUINode* /*caller*/, unsigned int /*id*/ ) {}
	virtual void OnGaugeEnd( cUINode* /*caller*/, unsigned int /*id*/ ) {}
	virtual void OnComboSelected( cUINode* /*caller*/, unsigned int /*id*/ ) {}
	virtual void OnOptiongaugeUpdate( cUINode* /*caller*/, unsigned int /*id*/ ) {}
	virtual void OnMouseOtherClick( const cUIPos& /*pos*/ ) {}

protected:
	/// ڽ Ʈ
	typedef tPointerList<void*> cChildList;
	cChildList mChildList;

	/// Ʈ ڽ Ʈ (Ѻθ  )
	typedef tPointerArray<void*> cEditArr;
	cEditArr mEditArr;

	///   ư 迭
	typedef tPointerArray<void*> cRadioArr;
	cRadioArr mHeadRadioArr;

public:
	/// ׶  
	bool mOnlyBackground;

	/// ݵ ϴ  ( visible  Ҽ  Ѵ )
	bool mHoldView;

private:
	/// ڼ 뿩 ( true ̸ ٸ ̳ʵ  ʴ´ )
	bool mExceptSnap;
};

inline tPointerList<void*>* cUIContainer::GetChildList()
{
	return &mChildList;
}

inline void cUIContainer::SetOnlyBackground( bool value )
{ 
	mOnlyBackground = value;
}

inline void cUIContainer::SetHoldView( bool hold )
{
	mHoldView = hold;
}

inline bool cUIContainer::IsOnlyBackground()
{
	return mOnlyBackground;
}

inline bool cUIContainer::IsHoldView()
{
	return mHoldView;
}

inline void cUIContainer::SetExceptSnap( bool set )
{
	mExceptSnap = set;
}

inline bool cUIContainer::IsExceptSnap()
{
	return mExceptSnap;
}
