#include "StdAfx.h" 
#include "UICursor.h"

#include "Application.h"
#include "RenderSystem.h"

#include "StageManager.h"
#include "SkillExecuter.h"

#include "resource.h"

cUICursor* cUICursor::mpSingleton = 0;

cUICursor::cUICursor()
: mCusorAlpha(0.f)
{
	assert( mpSingleton == 0 && "bad singleton!" );
	mpSingleton = this;

	for( int i = 0; i < eCURSOR_MAX; ++i )
	{
		mCursor[i] = 0;
	}
}

cUICursor::~cUICursor()
{
	mpSingleton = 0;

}

/// ǻ :
bool cUICursor::Init()
{
	char pathName[256] = {0,};
	for( unsigned int i=0; i<eCURSOR_MAX; i++ )
	{
		HINSTANCE hins = THEAPP->GetWindowInstance();

		mCursor[eCURSOR_DEFAULT] = LoadCursor( hins, MAKEINTRESOURCE( IDC_CURSOR1 ) );
		mCursor[eCURSOR_ATTACK] = LoadCursor( hins, MAKEINTRESOURCE( IDC_CURSOR2 ) );
		mCursor[eCURSOR_SKILL] = LoadCursor( hins, MAKEINTRESOURCE( IDC_CURSOR3 ) );
		mCursor[eCURSOR_TALK] = LoadCursor( hins, MAKEINTRESOURCE( IDC_CURSOR4 ) );
		mCursor[eCURSOR_MOVEMAP] = LoadCursor( hins, MAKEINTRESOURCE( IDC_CURSOR5 ) );
		mCursor[eCURSOR_MOVESTOP] = LoadCursor( hins, MAKEINTRESOURCE( IDC_CURSOR6 ) );
		mCursor[eCURSOR_DROPITEM] = LoadCursor( hins, MAKEINTRESOURCE( IDC_CURSOR7 ) );
		mCursor[eCURSOR_GATHERING] = LoadCursor( hins, MAKEINTRESOURCE( IDC_CURSOR8 ) );
/*
		switch( i )
		{
		case eCURSOR_DEFAULT: 
			::sprintf( pathName, "%s", "./Data/2DData/default.cur" ); break;
		case eCURSOR_ATTACK: 
			::sprintf( pathName, "%s", "./Data/2DData/attack.cur" ); break;
		case eCURSOR_SKILL: 
			::sprintf( pathName, "%s", "./Data/2DData/skill.cur" ); break;
		case eCURSOR_TALK: 
			::sprintf( pathName, "%s", "./Data/2DData/talk.cur" ); break;
		case eCURSOR_MOVEMAP: 
			::sprintf( pathName, "%s", "./Data/2DData/movemap.cur" ); break;
		case eCURSOR_MOVESTOP: 
			::sprintf( pathName, "%s", "./Data/2DData/movestop.cur" ); break;
		case eCURSOR_DROPITEM: 
			::sprintf( pathName, "%s", "./Data/2DData/dropitem.cur" ); break;
		default:
			continue;
		}

		/// load in default folder
		mCursor[i] = LoadCursorFromFileA( pathName );
		if( mCursor[i] )
			continue;

		/// load in pack 
		cFileLoader loader;
		if( loader.Open( pathName, true ) == false )
		{
			assert( 0 );
			return false;
		}
		mCursor[i] = (HCURSOR)CreateIconFromResourceEx( (PBYTE)loader.GetBufferPtr(), loader.GetSize(), FALSE, 0x00030000, 0, 0, LR_DEFAULTCOLOR );
		if( mCursor[i] == 0 )
		{
			assert(0);
			return false;
		}
*/
	}

	/// ʱĿ 
	mCurCursorType = eCURSOR_DEFAULT;
	::SetCursor( mCursor[ mCurCursorType ]);

	return true;
}

/// ǻ :
void cUICursor::Process( float )
{
	if( mCurCursorType == eCURSOR_MAX )
		::SetCursor( NULL );
	else
		::SetCursor( mCursor[ mCurCursorType ]);

	/// SetClassLong RegisterClassExԼ ؼ ϵ Ư  ٲ  ϴ ԼԴϴ. 
	::SetClassLong( THEAPP->GetHWND(),GCL_HCURSOR,(LONG)mCursor); 
}

/// ǻ :
void cUICursor::SetCursor( eCursor_Type eType )
{
	if( eType == eCURSOR_MAX  )
	{
		mCurCursorType = eCURSOR_MAX;
		::SetCursor( NULL );
		return;
	}

	eCursor_Type type = eType;
	if( STAGEMAN->GetCurrentStage() == eStage_Game )
	{
		if( SKILLEXECUTER->IsFieldSkillCharge() == false )
		{
			if( SKILLEXECUTER->IsSkillCharge() == true )
				type = eCURSOR_SKILL;
		}
	}
	/// ϸ Ǿ   ʴ 찡
	/// Ƿ ϽŲ 
	if( mCurCursorType == type )
	{
		return;
	}

	mCurCursorType = type;

	::SetCursor( mCursor[ mCurCursorType ]);
}