/* ==========================================================================
*    : ̼
*    : 2007.06.08
*      : ؽƮ , κ ÷ Ҽ մ ؽƮ 
* ǻ : 
*===========================================================================*/
#pragma once

#include "Lexer.h"

class cUIFuncTextLexer;
class cParser;

/// UI  ؽƮ ū Ÿ
enum eUIFuncTextNodeType
{
	eTEXTNODE_NULL = 0,
	eTEXTNODE_STRING,
	eTEXTNODE_COLOR,
	eTEXTNODE_VARNAME,
	eTEXTNODE_NEWLINE,
};

/// UI ؽƮ ڿ 
class cUIFuncTextParam
{
public:
	cStringT mName;
};

/// UI ڿ 
#pragma pack( push, 1 )
class cUIFuncTextNode
{
	friend class cUIFuncText;

public:
	cUIFuncTextNode();
	~cUIFuncTextNode();

	const cUIFuncTextNode* GetNext() const;
	const cUIFuncTextNode* Back() const;

public:
	eUIFuncTextNodeType mType;

	TCHAR*	mpString;
	unsigned long mColor;
	
private:
	mutable cUIFuncTextNode* mpNext;
};
#pragma pack( pop )

inline cUIFuncTextNode::cUIFuncTextNode()
: mType( eTEXTNODE_NULL )
, mpNext( 0 )
, mpString( 0 )
, mColor( 0 )
{
}

inline cUIFuncTextNode::~cUIFuncTextNode()
{
	if( mType == eTEXTNODE_STRING )
		delete [] mpString;

	if( mpNext )
		delete mpNext;
}

inline const cUIFuncTextNode* cUIFuncTextNode::GetNext() const
{
	return mpNext;
}

inline const cUIFuncTextNode* cUIFuncTextNode::Back() const
{
	if( mpNext )
		return mpNext->Back();
	else
		return this;
}

/// UI  ڿ
class cUIFuncText
{
public:
	cUIFuncText();
	~cUIFuncText();

	void Clear();

	/// ε
	bool Load( const cString& pathName );

	/// ؽƮ 
	const cUIFuncTextNode* GetNode( unsigned int id ) const;

private:
	cUIFuncTextNode* NewNode( unsigned int id );
	void PushStringNode( unsigned int id, const cString& str );
	void PushColorNode( unsigned int id, unsigned long color );
	void PushVarNameNode( unsigned int id );
	void PushNewLineNode( unsigned int id );

private:
	typedef tHashMap<unsigned int, void*> cNodeMap;
	cNodeMap mNodeMap;
};

/// UI ڿ ū Ÿ
enum
{
	/// ڻ
	eTOKEN_TEXT_BLACK = 100,
	eTOKEN_TEXT_WHITE,
	eTOKEN_TEXT_GRAY,
	eTOKEN_TEXT_RED,
	eTOKEN_TEXT_GREEN,
	eTOKEN_TEXT_BLUE,
	eTOKEN_TEXT_YELLOW,

	/// 
	eTOKEN_TEXT_VARNAME,

	/// γѱ
	eTOKEN_TEXT_NEWLINE,
};

/// UI ڿ  м
class cUIFuncTextLexer : public cLexer
{
public:
	cUIFuncTextLexer( const char* buffer, unsigned int size );
};
