#include "StdAfx.h"
#include "UIIDList.h"

#include "Lexer.h"
#include "Parser.h"
#include "FileSystem.h"
#include "MemFile.h"

cUIIDList::cUIIDList()
{
}

cUIIDList::~cUIIDList()
{
}

bool cUIIDList::Load( const cString& pathName )
{
	///  
	cFileLoader loader;
	if( loader.Open( pathName, true ) == false )
	{
		return false;
	}

	/// Ų   
	cString path;
	::GetFilePath( &path, pathName );

	///  ְ Ľ
	cToken token;
	cLexer lexer( loader.GetBufferPtr(), loader.GetSize() );
	cParser parser( &lexer, pathName );

	cString propName;
	unsigned int propID = 0;

	/// ״ū  ˻
	while( lexer.IsEnd() == false )
	{
		lexer.GetNextToken( &token );
	
		switch( token.mType )
		{
		case eTOKEN_ERROR:
			return false;
		case eTOKEN_NULL:
			continue;
		case eTOKEN_STR:
			{
				/// Ƽ ̸ ̵ ޾ƿ 
				propName = token;
				propID = parser.ParseInt();
			}
			break;
		default:
			assert( 0 && "invalid token" );
			return false;
		}

		///  Ų ʿ ߰
		if( mIDHashMap.Insert( propName, propID ) == false )
		{
			assert( 0 && "failed to insert prop name, maybe already exist" );
			return false;
		}
	}
	return true;
}

/// ǻ : ̵  
unsigned int cUIIDList::GetPropID( const cString& propname ) const
{
	cIDHashMap::cConstIterator i = mIDHashMap.Find( propname );

	if( i == mIDHashMap.End() )
	{
		return 0;
	}
	return i->mSecond;
}
