#include "Stdafx.h"
#include "UIIMENode.h"
#include "Application.h"
#include "FontAgent.h"
#include "ChatManager.h"
#include "StageManager.h"

HWND cUIIMENode::mHWnd = NULL;
bool cUIIMENode::mShiftKey = false;
bool cUIIMENode::mControlKey = false;

cUIIMENode::cUIIMENode( eUINodeType type )
: cUINode( type )
, mTextLength( 0 )
, mTextCaretX( 0 )
, mScrollIndex( 0 )
, mScrollCaretX( 0 )
, mOneLineWidth( 0 )
, mStartDragCaretX( 0 )
, mEndDragCaretX( 0 )
, mMaxEditLength(0)
, mFixFlag( false )
, mCompFlag( false )
, mDraggingFlag( false )
, mChangeText( false )
, mImeFlag( false )
, mFocusBook( false )
{
	mEditKind = eEDIT_NORMAL;

	::ZeroMemory( mText, sizeof(mText) );
	::ZeroMemory( mCompText, sizeof(mCompText) );
}

cUIIMENode::~cUIIMENode()
{

}

void cUIIMENode::Clear()
{
	::ZeroMemory( mText, sizeof(mText) );
	::ZeroMemory( mCompText, sizeof(mCompText) );
	mTextLength = 0;
	mTextCaretX = 0;
	mScrollIndex = 0;
	mScrollCaretX = 0;
	mDraggingFlag = false;
	mCompFlag = false;

	mChangeText = true;
}

bool cUIIMENode::OnCreate( cUINodeProperty* )
{
	if( cUINode::OnCreate() == false )
		return false;

	/// ڵ  
	if( mHWnd == 0 )
	{
		mHWnd = THEAPP->GetHWND();
	}
	return true;
}

/// ǻ : 1byte  ֱ
void cUIIMENode::OnChar( unsigned int wparam )
{
	if( mEditKind == eEDIT_NOINPUT )
		return;

	TCHAR str[2] = {0,};

	str[0] = (TCHAR)wparam;
	str[1] = 0;

	/// ڿ ̸ 
	if( *str <= 0 )
	{
		assert( 0 && "str is 0" );
	}

	bool except = false;
	BYTE byte2 = LOBYTE( wparam );

	/// Ưΰ 
	if( mEditKind == eEDIT_EXCEPT_SPECIAL )
	{
		if( (byte2 >= 48 && byte2 <= 57) ||
			(byte2 >= 65 && byte2 <= 90) || 
			(byte2 >= 97 && byte2 <= 122 ) )
			except = false;
		else
			except = true;
	}
	
	/// ش ڿ ȿ ˻ ü ؽƮ 
	if( !except && IsValid( *str ) )
	{
		AddChar( str );
	}
}

/// ǻ : Է¹ ڿ ȿ ˻
bool cUIIMENode::IsValid( TCHAR c )
{
	switch( mEditKind )
	{
	case eEDIT_NUMBER:
		{
			/// ڿ ȿ
			if( isdigit( c ) )
				return true;
		}
		break;
	case eEDIT_EXCEPT_SPECIAL:
	case eEDIT_ACCOUNT_ID:
		{
			/// ,  Է ȿ
			/// ѱԷ ime   
			if( isalpha( c ) || isdigit( c ) )	
				return true;
		}
		break;
	case eEDIT_ACCOUNT_PASS:
	default:
		{
			if( c >= 32 && c < 127 )
				return true;
		}
		break;
	}

	return false;
}

void cUIIMENode::SetFocusBook()
{
	mFocusBook = true;
}

void cUIIMENode::SetFocus()
{
	cUINode::SetFocus();

	////
	HIMC hIMC = ::ImmGetContext( mHWnd );

	DWORD dwConversion, dwSentence;
	ImmGetConversionStatus( hIMC, &dwConversion, &dwSentence);

	/// ̸  ȯ
	if( mEditKind == eEDIT_ACCOUNT_ID || mEditKind == eEDIT_ACCOUNT_PASS )
	{
		if( dwConversion == IME_CMODE_HANGEUL )
			::ImmSetConversionStatus( hIMC, IME_CMODE_ALPHANUMERIC, 0 );
	}
//	else
//	{
		/// ѱ۸̸ IME  Ŭ
//		if( dwConversion == IME_CMODE_HANGEUL )
//			::ImmSetCompositionString( hIMC, SCS_SETSTR, NULL, 0, NULL, 0 );
//	}

	::ImmReleaseContext( mHWnd, hIMC );
}

void cUIIMENode::OnImeNotify( unsigned int /*wparam*/ )
{
	HIMC hIMC = ::ImmGetContext( mHWnd );

	DWORD dwConversion, dwSentence;
	ImmGetConversionStatus( hIMC, &dwConversion, &dwSentence);

	/// ̸  ȯ
	if( mEditKind == eEDIT_ACCOUNT_ID || mEditKind == eEDIT_ACCOUNT_PASS )
	{
		if( dwConversion == IME_CMODE_HANGEUL )
			::ImmSetConversionStatus( hIMC, IME_CMODE_ALPHANUMERIC, 0 );
	}
	::ImmReleaseContext( mHWnd, hIMC );
}

/// ǻ : 
void cUIIMENode::OnImeComposition( unsigned int, unsigned int lparam )
{
	/// ڿ Ʈ̰ų, ڸ ް ϸ  
	if( mEditKind == eEDIT_NOINPUT || mEditKind == eEDIT_NUMBER || 
		mEditKind == eEDIT_ACCOUNT_ID || mEditKind == eEDIT_ACCOUNT_PASS )
		return;

	/// 巡 ̸ ime Է ȹ 
	if( mPressed == true )
	{
		mImeFlag = true;
		return;
	}

	/// հ ϼǼ °  ( 巡׻¿ ԷµǾ  )
	if( mImeFlag == true )
	{
		mImeFlag = false;
		return;
	}	

	HIMC hIMC = ::ImmGetContext( mHWnd );

	TCHAR str[20] = {0,};

	///  ڿ ´
	if( lparam & GCS_COMPSTR )
	{
		/// ̸ ´
		int strLen = ::ImmGetCompositionString( hIMC, GCS_COMPSTR, NULL, 0 );

		///  ̸ŭ ڸ ´
		::ImmGetCompositionString( hIMC, GCS_COMPSTR, str, strLen );

		/// ڿ  
		str[ strLen/sizeof(TCHAR) ] = 0;

		AddCompWord( str, strLen/sizeof(TCHAR) );
	}
	/// ϼ ڿ ´
	else if( lparam & GCS_RESULTSTR )
	{
		/// ̸ ´
		int strLen = ::ImmGetCompositionString( hIMC, GCS_RESULTSTR, NULL, 0 );

		::ImmGetCompositionString( hIMC, GCS_RESULTSTR, str, strLen );

		str[ strLen/sizeof(TCHAR) ] = 0;

		/// ü ؽƮ 
		AddString( str, strLen/sizeof(TCHAR) );
	}

	::ImmReleaseContext( mHWnd, hIMC );
}

/// ǻ : 
void cUIIMENode::OnKeyDown( eKeyCode code )
{
	switch( code )
	{
	case eKEY_C:
		{
			/// ƮŰ ÿ ,
			if( mControlKey )
			{
				KeyDownCopy();
			}
		}
		break;

	case eKEY_V:
		{
			if( mControlKey )
			{
				KeyDownPaste();
			}
		}
		break;
	case eKEY_TAB:
		{
			/// ӽ ƴϸ  
			if( STAGEMAN->GetCurrentStage() != eStage_Game )
				return;

			if( mShiftKey )
			{
				/// shfit + tab Ű Ŀ ü 
				CHATMANAGER->ChangeFocus();
			}
		}
		break;
	case eKEY_LEFT:
		{
			CaretMoveLeft();
		}
		break;

	case eKEY_RIGHT:
		{
			CaretMoveRight();
		}
		break;

	case eKEY_HOME:
		{
			mDraggingFlag = false;
			CaretMoveHome();
		}
		break;

	case eKEY_END:
		{
			mDraggingFlag = false;
			CaretMoveEnd();
		}
		break;

	case eKEY_BACK:
		{
			/// ÿ ,
			if( mDraggingFlag )
			{
				DeleteSell();
			}
			else
			{
				KeyDownBackSpace();
			}
		}
		break;

	case eKEY_DELETE:
		{
			/// ÿ ,
			if( mDraggingFlag )
			{
				DeleteSell();
			}
			else
			{
				KeyDownDelete();
			}
		}
		break;
	default:
		break;
	}
}

////------------------------------------------------------------------------
/// ǻ : 1byte   
/// UNICODE ̹Ƿ ѱ̵,   ѱ ̴ 1 ̴.
void cUIIMENode::AddChar( LPTSTR word )
{
	/// 巡 ̸ ime Է ȹ 
	if( mPressed == true )
		return;

	mCompFlag = false;
	mFixFlag = false; 

	/// ÿ  
	DeleteSell();

	/// Է  
	if( mTextLength >= mMaxEditLength )
		return;

	TCHAR rightStr[ MAX_TEXT_LENGTH ] = {0,};
	int rightLen = GetRightString( rightStr, MAX_TEXT_LENGTH );

	/// 
	mText[ mTextCaretX ] = *( word );

	/// ĳε,  
	mTextCaretX++;
	mTextLength++;

	assert( mTextCaretX < MAX_TEXT_LENGTH );

	/// ڿ ߰ ̾ٸ,  ڿ Ѵ
	if( rightLen != 0 ) 
	{
		Sstrncpy( mText + mTextCaretX, MAX_TEXT_LENGTH - mTextCaretX, rightStr, rightLen );
	}

	mText[ mTextLength ] = 0;

	/// ؽƮ width ϱ 
	unsigned int textWidth = FONTAGENT->GetTextExtent( cFontAgent::eFont_Chat, mText + mScrollIndex, mTextCaretX - mScrollIndex );

	///   ũ Ŵ 
 	if( (int)textWidth > mOneLineWidth )
	{
		mScrollIndex++;
	}
	else
	{
		mScrollCaretX++;
	}

	mChangeText = true;
}

/// ǻ : 
void cUIIMENode::AddCompWord( LPTSTR word, int len )
{	
	/// ÿ  
	DeleteSell();

	if( mTextLength >= mMaxEditLength )
		return;

	///  ѱ 
	Sstrncpy( mCompText, MAX_TEXT_LENGTH, word, len );

	///  ƴ ̷ Ǵ
	if( len > 0 )
	{	
		/// ù ΰ츸 ó 
		if( mCompFlag == false )
		{
			int textWidth = FONTAGENT->GetTextExtent( cFontAgent::eFont_Chat, mText + mScrollIndex, mTextCaretX - mScrollIndex );
			int comWidth = FONTAGENT->GetTextExtent( cFontAgent::eFont_Chat, mCompText, 1 );
			
			///   ũ Ŵ 
			if( textWidth + comWidth > mOneLineWidth )
			{
				mScrollIndex++;
				mScrollCaretX--;
			}
		}

		/// .
		mCompFlag = true;
	}
	else if( len <= 0 )
	{
		///  
		mCompFlag = false;
	}

	mChangeText = true;
}

/// ǻ :  ڿ Ư,   óϱ 
void cUIIMENode::AddString( LPTSTR string, int len )
{
	bool add = false;
	LPTSTR str = string;
	for(int index = 0; index < len; ++index )
	{
		if( mEditKind == eEDIT_EXCEPT_SPECIAL )
		{
			/// Ưܿ ϰ .
			if( (*str >= 48 && *str <= 57) ||
				(*str >= 65 && *str <= 90) || 
				(*str >= 97 && *str <= 122 ) ||
				(*str >= 12593 && *str <= 12642 ) ||
				(*str >= 44032 && *str <= 55203 ))
			{
				AddChar( str );
				str++;

				add = true;
			}
		}
		else
		{
			/// Ϲ .
			AddChar( str );
			str++;

			add = true;
		}
	}

	if( add == false )
	{
		::ZeroMemory( mCompText, sizeof(mCompText) );
		mCompFlag = false;
		mChangeText = true;
	}
}

/// ǻ : ĳ ߽  ڿ ´
int cUIIMENode::GetRightString( LPTSTR dest, unsigned int maxDestLen )
{
	/// ڿ ̸  
	if( mTextCaretX >= mTextLength )
		return 0;

	///  Ŀκ  ڿ ٰ dest 
	Sstrncpy( dest, maxDestLen, mText + mTextCaretX, mTextLength - mTextCaretX );

	/// ߶  ڿ   
	return (mTextLength - mTextCaretX);
}

/// ǻ : ĳ ڿ ó ̵
void cUIIMENode::CaretMoveHome()
{
	mCompFlag = false;

	/// ̹ ġ  
	if( mTextCaretX <= 0 )
		return;

	mTextCaretX = 0;
	mScrollCaretX = 0;
	mScrollIndex = 0;
	mChangeText = true;
}

/// ǻ : ĳ ڿ  ̵
void cUIIMENode::CaretMoveEnd()
{
	mCompFlag = false;

	/// ̹  ġ  
	if( mTextCaretX == mTextLength )
		return;

	mTextCaretX = mTextLength;
	
	/// ߸ 
	unsigned int cutWidth = 0;

	/// ߸ڿ  
	int cutlen = 0;

	///  ˻ 
	while( (int)cutWidth < mOneLineWidth )
	{
		///  ˻ʿ .
		if( cutlen > mTextLength )
			break;

		cutlen++;

		cutWidth = FONTAGENT->GetTextExtent( cFontAgent::eFont_Chat, mText + mTextLength - cutlen, cutlen );
	}

	///    (  Ƣ ڴ  ﵵ ̷ )
	if( (int)cutWidth > mOneLineWidth )
	{
		cutlen--; 
	}

	/// ũѵ ¶
	if( mTextLength - cutlen > 0 )
	{
		mScrollIndex = mTextLength - cutlen;
		mScrollCaretX = cutlen;
	}
	else
	{
		mScrollIndex = 0;
		mScrollCaretX = mTextLength;
	}

	mChangeText = true;
}

/// ǻ : ĳ    ̵
void cUIIMENode::CaretMoveLeft()
{
	mCompFlag = false;

	/// 巡  ,
	if( mDraggingFlag )
	{
		/// 巡  ó ̵ 
		if( mStartDragCaretX < mEndDragCaretX )
		{
			mTextCaretX = mScrollIndex + mStartDragCaretX;
			mScrollCaretX = mStartDragCaretX;
		}
		else
		{
			mTextCaretX = mScrollIndex + mEndDragCaretX;
			mScrollCaretX = mEndDragCaretX;
		}
		mDraggingFlag = false;
		return;
	}

	/// ̹ ġ  
	if( mTextCaretX <= 0 )
		return;

	/// 
	mTextCaretX--;

	/// ũĳ ġ showtext ù ġ ƴϸ ׳ 
	if( mScrollCaretX - 1 >= 0 )
	{
		mScrollCaretX--;
	}
	else
	{
		///   ݸ ִܺ ҽ 
		/// ˻ ڿ 
		unsigned int cutWidth = 0;

		/// ߸ڿ  
		int cutlen = 0;

		///  ˻ 
		while( (int)cutWidth < mOneLineWidth )
		{
			cutlen++;

			cutWidth = FONTAGENT->GetTextExtent( cFontAgent::eFont_Chat, mText + mScrollIndex, cutlen );
		}

		int div = cutlen / 2;
		int n = mScrollIndex / div;
		if( n > 0 )
		{
			mScrollIndex -= div;
		}
		else
		{
			///    
			int value = mScrollIndex % div;
			mScrollIndex -= value;
		}

		mScrollCaretX = mTextCaretX - mScrollIndex;
		mChangeText = true;
	}
}

/// ǻ : ĳ    ̵
void cUIIMENode::CaretMoveRight()
{
	mCompFlag = false;

	/// 巡  ,
	if( mDraggingFlag )
	{
		/// 巡  ó ̵ 
		if( mStartDragCaretX < mEndDragCaretX )
		{
			mTextCaretX = mScrollIndex + mEndDragCaretX;
			mScrollCaretX = mEndDragCaretX;
		}
		else
		{
			mTextCaretX = mScrollIndex + mStartDragCaretX;
			mScrollCaretX = mStartDragCaretX;
		}
		mDraggingFlag = false;
		return;
	}
	
	/// ̹  ġ  
	if( mTextCaretX == mTextLength )
		return;

	/// U ĭ  
	mTextCaretX++;

	unsigned int textWidth = FONTAGENT->GetTextExtent( cFontAgent::eFont_Chat, mText + mScrollIndex, mTextCaretX - mScrollIndex );

	/// ũĳ ġ Ѷ  ƴϸ 
	if( (int)textWidth < mOneLineWidth )
	{
		mScrollCaretX++;
	}
	else
	{
		/// ˻ ڿ 
		unsigned int cutWidth = 0;

		/// ߸ڿ  
		int cutlen = 0;

		///  ˻ 
 		while( (int)cutWidth < mOneLineWidth )
		{
			///  ˻ʿ .
			if( cutlen >= mTextLength )
				break;

			cutlen++;

			cutWidth = FONTAGENT->GetTextExtent( cFontAgent::eFont_Chat, mText + mScrollIndex, cutlen );
		}

		/// ڿ  
		int div = cutlen / 2;
		int n = (mTextLength - (mScrollIndex + cutlen) ) / div;
		if( n > 0 )
		{
			mScrollIndex += div;
		}
		else
		{
			///    
			int value = (mTextLength - (mScrollIndex + cutlen)) % div + 1;
			mScrollIndex += value;
		}

	
		mScrollCaretX = mTextCaretX - mScrollIndex;
		mChangeText = true;
	}
}

/// ǻ : 齺̽  ó
void cUIIMENode::KeyDownBackSpace()
{
	mCompFlag = false;

	if( mTextCaretX <= 0 )
		return;

	///  ĳ߽  ڿ ִ° .
	TCHAR rightStr[ MAX_TEXT_LENGTH ] = {0,};
	int rightLen = GetRightString( rightStr, MAX_TEXT_LENGTH );
	
	if( mTextCaretX > 0 )
	{
		mTextCaretX--;
	}
	else
	{
		assert(0);
	}

	if( mTextLength > 0 )
	{
		mTextLength--;
	}
	else
	{
		assert(0);
	}

	/// ũĳ ġ showtext ù ġ ƴϸ ׳ 
	if( mScrollCaretX - 1 >= 0 )
	{
		mScrollCaretX--;
	}
	else
	{
		/*
			̺κ ٽ¥-_- ٶ󸶹ٻ
		*/

		///   ݸ ִܺ ҽ 
		/// ˻ ڿ 
		unsigned int cutWidth = 0;

		/// ߸ڿ  
		int cutlen = 0;

		///  ˻ 
		while( (int)cutWidth < mOneLineWidth )
		{
			cutlen++;

			cutWidth = FONTAGENT->GetTextExtent( cFontAgent::eFont_Chat, mText + mScrollIndex, cutlen );
		}

		int div = cutlen / 2;
		int n = mScrollIndex / div;
		if( n > 0 )
		{
			mScrollIndex -= div;
		}
		else
		{
			///    
			int value = mScrollIndex % div;
			mScrollIndex -= value;
		}

		mScrollCaretX = mTextCaretX - mScrollIndex;
		
	}

	/// ڿ     û
	ClearText( mTextCaretX );
	mText[ mTextCaretX ] = 0;

	///  ڿ ϸ 
	if( rightLen != 0 )
	{
		/// ڿ     û
		ClearText( mTextCaretX );

		Sstrncpy( mText + mTextCaretX, MAX_TEXT_LENGTH - mTextCaretX, rightStr, rightLen );
	}

	mChangeText = true;
}

/// ǻ : delete Ű  ó
void cUIIMENode::KeyDownDelete()
{
	mCompFlag = false;

	/// ̹  ġ  
	if( mTextCaretX == mTextLength )
		return;

	///  ĳ߽  ڿ ִ° .
	TCHAR rightStr[ MAX_TEXT_LENGTH ] = {0,};
	int rightLen = GetRightString( rightStr, MAX_TEXT_LENGTH );

	//  ÿ 쿡 ٸ  ֵ Ѵ.
	if( mTextLength > 0 )
	{
		mTextLength--;
	}
	else
	{
		assert(0);
	}

	if( rightLen != 0 )
	{
		/// ڿ     û
		ClearText( mTextCaretX );

		Sstrncpy( mText + mTextCaretX, MAX_TEXT_LENGTH - mTextCaretX, rightStr + 1, rightLen - 1 );
	}

	/// ڿ     û
	ClearText( mTextLength );
	mText[ MAX_TEXT_LENGTH ] = 0;

	mChangeText = true;
}

/// ǻ : mText  ʴ ε  
void cUIIMENode::ClearText( int index )
{
	/// copy size  ʿ!!
	TCHAR str[ MAX_TEXT_LENGTH ] = {0,};
	Sstrncpy( str, MAX_TEXT_LENGTH, mText, index );

	::ZeroMemory( mText, sizeof(mText) );
	Sstrncpy( mText, MAX_TEXT_LENGTH, str, index );

	mChangeText = true;
}

/// ǻ : 
void cUIIMENode::KeyDownCopy()
{
	/// 
	LPTSTR str = mText;

	///   ڿ 
	//LPTSTR copyStr = 0;
	TCHAR copyStr[ MAX_TEXT_LENGTH ] = {0,};

	/// ص ڿ 
	int copyLen = mEndDragCaretX - mStartDragCaretX;
	if( copyLen == 0 )
		return;
	
	if( copyLen > 0 )
	{
		Sstrncpy( copyStr, MAX_TEXT_LENGTH, str + mStartDragCaretX + mScrollIndex, copyLen );
	}
	else if( copyLen < 0 )
	{
		/// ȯ
		copyLen = (-copyLen);
		Sstrncpy( copyStr, MAX_TEXT_LENGTH, str + mEndDragCaretX + mScrollIndex, copyLen );
	}
	
	/// ƼƮ ȯ 
	char asciiStr[ MAX_TEXT_LENGTH ] = {0,};
	ConvertToAscii( copyStr, asciiStr, MAX_TEXT_LENGTH );

	int asciilen = ::strlen( asciiStr );

	/// Ŭ忡 ٿֱ 
	HGLOBAL hMem;

	///  ޸ Ҵ 
	hMem = ::GlobalAlloc( GHND, (asciilen + 1) );

	/// ޸  㰡  
	char* pBuff = (char*)::GlobalLock( hMem );

	/// Ŭ忡  
	memcpy( pBuff, asciiStr, asciilen );
	pBuff[ asciilen ] = 0;

	/// ޸ 㰡 
	::GlobalUnlock( hMem );

	/// Ŭ  ϴٸ, 
	if( OpenClipboard( mHWnd ) )
	{
		///  ͸ 
		::EmptyClipboard();

		/// 
		::SetClipboardData( CF_TEXT, hMem );

		::CloseClipboard();
	}
}

/// ǻ : 
void cUIIMENode::KeyDownPaste()
{
	/// ٿֱ Ҷ ÿ    
	DeleteSell();

	/// Ŭ忡 ٿֱ 
	HGLOBAL hMem;

	/// Ŭ忡 TEXT Ÿ ڰ , ´
	if( ::IsClipboardFormatAvailable( CF_TEXT ) )
	{
		///   
		if( ::OpenClipboard( mHWnd ) == false )
			return;

		hMem = ::GetClipboardData( CF_TEXT );

		/// ޸ 
		char* pBuff = (char*)::GlobalLock( hMem );
		if( ::strlen(pBuff) == 0 )
		{
			::GlobalUnlock( hMem );
			::CloseClipboard();
			return;
		}

		///   
		TCHAR str[ MAX_TEXT_LENGTH ] = {0,};

		/// unicode  ȯ 
		ConvertToUnicode( pBuff, str, MAX_TEXT_LENGTH );
		int len = ::_tcslen( str );
		if( len == 0 )
		{
			::GlobalUnlock( hMem );
			::CloseClipboard();
			return;
		}

		LPTSTR s = str;

		for(int index = 0; index < len; ++index )
		{				
			AddChar( s );
			s++;
		}		

		/// 
		::GlobalUnlock( hMem );

		/// ݱ 
		::CloseClipboard();

		mChangeText = true;
	}
}

/// ǻ :  õ ¿ backspace Է Ȥ  delete Է
void cUIIMENode::DeleteSell()
{
	/// ̹ ÿ   
	if( mDraggingFlag == false )
		return;

	///   
	mDraggingFlag = false;

	int delstart = 0;
	int len = mEndDragCaretX - mStartDragCaretX;
	if( len == 0 )
		return;

	if( len < 0 )
	{
		len = (-len);
		delstart = len;
		mTextCaretX = mEndDragCaretX + mScrollIndex;
	}
	else if( len > 0 )
	{
		mTextCaretX = ( mStartDragCaretX > 0 ) ? mStartDragCaretX + mScrollIndex : mStartDragCaretX;
	}

	///  ĳ߽  ڿ ִ° .
	TCHAR rightStr[ MAX_TEXT_LENGTH ] = {0,};
	
	int rightLen = GetRightString( rightStr, MAX_TEXT_LENGTH );

	///  ִ ؽƮ  (   κи Ȯ  )
	for( int i = mTextCaretX; i < mTextCaretX + delstart + len; ++i )
	{
		mText[i] = _T('\0');
	}	

	if( rightLen != 0 )
	{
		Sstrncpy( mText + mTextCaretX, MAX_TEXT_LENGTH - mTextCaretX, rightStr + len, rightLen - len );
	}

	if( mTextCaretX == 0 )
		mScrollIndex = 0;

	mScrollCaretX = mTextCaretX - mScrollIndex;

	if( mTextLength - len >= 0 )
	{
		mTextLength -= len;
	}
	else
	{
		assert(0);
	}

	mText[ mTextLength ] = 0;
	len = 0;

	mChangeText = true;
}
