/* ==========================================================================
*      : UIIMENode.h
*      : 
*    : 谡
*    : 2006-10-31
* ǻ :
*===========================================================================*/
#pragma once
#pragma comment(lib, "imm32.lib")
#include "UINode.h"
#include "UIKeyCode.h"

const int MAX_TEXT_LENGTH = 512;

/// Ʈ 
enum eEditKind
{
	eEDIT_NORMAL,		/// Ϲ 
	eEDIT_NOINPUT,		/// Է¸ ȹ.
	eEDIT_NUMBER,		/// ڿ
	eEDIT_ACCOUNT_ID,	/// ID 
	eEDIT_ACCOUNT_PASS,	/// PASS  
	eEDIT_EXCEPT_SPECIAL /// Ưڸ 
};

class cUIIMENode : public cUINode
{
public:
	cUIIMENode( eUINodeType type );
	virtual ~cUIIMENode();

	/// ؽƮ ´
	LPCTSTR GetText() const;

	/// ؽƮ  ȹ
	int GetLength() const;

	/// ؽƮ ʱȭѴ
	void Clear();

	void SetFocus();

	/// Ű Է, ٷ Ŀ ٽÿ  ǹ°.
	///  Ŀ Ŀ ش.
	void SetFocusBook();

	/// Ʈ ü ִ  ִ ڿ 
	void SetMaxEditLength( int maxlen );

protected:
	virtual bool OnCreate( cUINodeProperty* property = 0 );
	///  Է½ ó
	virtual void OnChar( unsigned int wparam );
	virtual void OnImeNotify( unsigned int wparam );
	virtual void OnImeComposition( unsigned int wparam, unsigned int lparam );
	/// Ű ٿ  ó
	virtual void OnKeyDown( eKeyCode code );
	/// Է¹ ڰ ȿ ˻
	virtual bool IsValid( TCHAR c );

	/// ؽƮ   ش.
	void ClearText( int index );

	/// 1 byte   
	void AddChar( LPTSTR word );

	///  ѱ 
	void AddCompWord( LPTSTR word, int len );

	/// ڿ ȣ  ԉ  óϴ Լ
	void AddString( LPTSTR string, int len );

	/// ĳ ߽  ڿ ´
	int GetRightString( LPTSTR dest, unsigned int maxDestLen );

	/// ĳ ڿ ó ű
	void CaretMoveHome();

	/// ĳ ڿ  ű
	void CaretMoveEnd();

	/// ĳ    ű. () 0226 :  Է  ǥ ѱ  ̵
	virtual void CaretMoveLeft();

	/// ĳ    ű. () 0226 :  Է  ǥ ѱ  ̵
	virtual void CaretMoveRight();

	/// 齺̽ Ű , () 0226 :  Է  ǥ ѱ  ̵
	virtual void KeyDownBackSpace();

	/// Delete Ű . () 0226 :  Է  ǥ ѱ  ̵
	virtual void KeyDownDelete();

	/// ٿ  ִ ڼ 
	void SetOneLineWidth( int linelen );

	/// ctrl + c 
	void KeyDownCopy();

	/// ctrl + v 
	void KeyDownPaste();

	/// 巡  ִ ¿ backspace ٿ Ȥ delete key ٿ
	void DeleteSell();

private:
	/// ڵ
	static HWND mHWnd;

public:
	/// shift key
	static bool mShiftKey;

	/// Ʈ Ű Ǵ 
	static bool mControlKey;

protected:
	/// Ʈڽ   ڿ
	/// ڵ  : 2byte ڹ迭, ̴ 1
	TCHAR mText[ MAX_TEXT_LENGTH ];

	///   ڸ 
	TCHAR mCompText[ MAX_TEXT_LENGTH ];

	/// Ʈ SHOW ؽƮ ſ
	bool mChangeText;

	/// Ʈڽ   ڿ  ( byte )
	int mTextLength;

	///  ڿ ĳ 
	int mTextCaretX;

	/// 
	bool mCompFlag;

	/// ÷ 
	bool mFixFlag;

	/// ũѱ  ε( ȭ鿡 Ѹ ؽƮ ε)
	int mScrollIndex;

	/// ũ  ĳ( ȭ  ĳ )
	int mScrollCaretX;

	/// ٿ  ִ ִ  
	int mOneLineWidth;

	/// Ʈ  ִ ִ  Ʈ 
	int mMaxEditLength;

	/// 巡  ĳǥ 
	int mStartDragCaretX, mEndDragCaretX;

	/// 巡 ÷
	bool mDraggingFlag;

	bool mImeFlag;

	/// Ŀ 
	bool mFocusBook;

	/// Ʈ  
	eEditKind mEditKind;
};

inline LPCTSTR cUIIMENode::GetText() const
{
	return mText;
}

inline void cUIIMENode::SetOneLineWidth( int linelen )
{
	mOneLineWidth = linelen;
}

inline void cUIIMENode::SetMaxEditLength( int maxlen )
{
	mMaxEditLength = maxlen;
}

inline int cUIIMENode::GetLength() const
{
	return mTextLength;
}