#include "StdAfx.h"
#include "UIImage.h"
#include "RenderSystem.h"

cUIImage::cUIImage()
{
	mTexture = 0;
	mScreenTexture = NiNew NiScreenTexture(0);

	mScreenTexture->SetApplyMode( NiTexturingProperty::APPLY_MODULATE );
	mScreenTexture->AddNewScreenRect( 0, 0,
		0, 0,
		0, 0, NiColorA::WHITE );

	mScreenTexture->MarkAsChanged( NiScreenTexture::EVERYTHING_MASK );
}

cUIImage::cUIImage( NiTexture* tex )
{
	assert( tex );

	mTexture = tex;
	mScreenTexture = NiNew NiScreenTexture( tex );

	mTextureWidth = tex->GetWidth();
	mTextureHeight = tex->GetHeight();

	mScreenTexture->SetApplyMode( NiTexturingProperty::APPLY_MODULATE );
	mScreenTexture->AddNewScreenRect( 0, 0,
		(unsigned short)tex->GetWidth(), (unsigned short)tex->GetHeight(),
		0, 0, NiColorA::WHITE );

	mScreenTexture->MarkAsChanged( NiScreenTexture::EVERYTHING_MASK );
}

cUIImage::cUIImage( NiTexture* tex, unsigned int x, unsigned int y, unsigned int tx, unsigned int ty, unsigned int tw, unsigned int th )
{
	assert( tex );

	mTexture = tex;
	mScreenTexture = NiNew NiScreenTexture( tex );

	//mTextureWidth = tex->GetWidth();
	//mTextureHeight = tex->GetHeight();

	mScreenTexture->SetApplyMode( NiTexturingProperty::APPLY_MODULATE );
	mScreenTexture->AddNewScreenRect(
		(short)y, (short)x,
		(unsigned short)tw, (unsigned short)th,
		(unsigned short)ty, (unsigned short)tx, NiColorA::WHITE );
	//mScreenTexture->AddNewScreenRect( 0, 0,
	//	(unsigned short)tex->GetWidth(), (unsigned short)tex->GetHeight(),
	//	0, 0, NiColorA::WHITE );
	mScreenTexture->MarkAsChanged( NiScreenTexture::EVERYTHING_MASK );
}

cUIImage::~cUIImage()
{
	mTexture = 0;
	SAFE_NIDELETE( mScreenTexture );
}

void cUIImage::Draw()
{
	if( mTexture )
	{
		mScreenTexture->Draw( NiRenderer::GetRenderer() );
	}
}

void cUIImage::SetTexture( NiTexture* tex )
{
	assert( tex );

	mTextureWidth = tex->GetWidth();
	mTextureHeight = tex->GetHeight();

	mTexture = tex;
	mScreenTexture->SetTexture( tex );
}

/// ǻ : 
void cUIImage::SetPos( int x, int y )
{
	//short xx = (short)( (double)x * (double)RENDERSYS->GetScreenWidth() );
	//short yy = (short)( (double)y * (double)RENDERSYS->GetScreenHeight() );

	NiScreenTexture::ScreenRect& rc = mScreenTexture->GetScreenRect( 0 );
	/*rc.m_sPixLeft = xx;
	rc.m_sPixTop = yy;*/

	rc.m_sPixLeft = (short)x;
	rc.m_sPixTop = (short)y;

	mScreenTexture->MarkAsChanged( NiScreenTexture::VERTEX_MASK );
}

void cUIImage::SetScreenRect( const cUIRect& rect )
{
	/// Ҽڸ .
	//unsigned int screenW = RENDERSYS->GetScreenWidth();
	//unsigned int screenH = RENDERSYS->GetScreenHeight();

	//mWidthOnScreen = FloatToInt( (rect.mRight - rect.mLeft) * screenW );
	//mHeightOnScreen = FloatToInt( (rect.mBottom - rect.mTop) * screenH );

	mWidthOnScreen = rect.mRight - rect.mLeft;
	mHeightOnScreen = rect.mBottom - rect.mTop;

	/*rc.m_sPixLeft = (short)(rect.mLeft * screenW);
	rc.m_sPixTop = (short)(rect.mTop * screenH);
	rc.m_usPixWidth = (unsigned short) mWidthOnScreen;
	rc.m_usPixHeight = (unsigned short) mHeightOnScreen;*/

	NiScreenTexture::ScreenRect& rc = mScreenTexture->GetScreenRect( 0 );
	rc.m_sPixLeft = (short)rect.mLeft;
	rc.m_sPixTop = (short)rect.mTop;
	rc.m_usPixWidth = (unsigned short) mWidthOnScreen;
	rc.m_usPixHeight = (unsigned short) mHeightOnScreen;

	mScreenTexture->MarkAsChanged( NiScreenTexture::VERTEX_MASK );
}

void cUIImage::SetTextureRect( unsigned int tl, unsigned int tt, unsigned int tr, unsigned int tb )
{
	mTexRect.Set( tl, tt, tr, tb );

	NiScreenTexture::ScreenRect& rc = mScreenTexture->GetScreenRect( 0 );
	rc.m_usTexLeft = (unsigned short)tl;
	rc.m_usTexTop = (unsigned short)tt;

	mScreenTexture->MarkAsChanged( NiScreenTexture::TEXTURE_MASK );
}

void cUIImage::SetTextureRect( const cUIRect& rect )
{
	mTexRect = rect;

	NiScreenTexture::ScreenRect& rc = mScreenTexture->GetScreenRect( 0 );
	/*rc.m_usTexLeft = (short)(rect.mLeft * mTextureWidth);
	rc.m_usTexTop = (short)(rect.mTop * mTextureHeight);*/
	rc.m_usTexLeft = (short)rect.mLeft;
	rc.m_usTexTop = (short)rect.mTop;

	mScreenTexture->MarkAsChanged( NiScreenTexture::TEXTURE_MASK );
}

void cUIImage::SetColor( const NiColorA& color )
{
	NiScreenTexture::ScreenRect& rc = mScreenTexture->GetScreenRect( 0 );
	rc.m_kColor = color;

	mScreenTexture->MarkAsChanged( NiScreenTexture::COLOR_MASK );
}

const NiColorA& cUIImage::GetColor() const
{
	const NiScreenTexture::ScreenRect& rc = mScreenTexture->GetScreenRect( 0 );
	return rc.m_kColor;
}

void cUIImage::SetAlpha( float a )
{
	assert(mScreenTexture->GetNumScreenRects());
	NiScreenTexture::ScreenRect& rect = mScreenTexture->GetScreenRect( 0 );
	rect.m_kColor.a = a;

	mScreenTexture->MarkAsChanged( NiScreenTexture::COLOR_MASK );
}

//void cUIImage::operator=( const cUIImage& other )
//{
//	mTexture = other.mTexture;
//	mScreenTexture.SetTexture( mTexture );
//}
