/* ==========================================================================
*      : UIImageBase.h
*      : ScreenTexture  ScreenElements ؼ ϱ   ؼ
*    : ̹
*    : 2007.02.26
* ǻ : 
*===========================================================================*/
#pragma once

#include "UIRect.h"
typedef tUIRect<int> cUIRect;

class cUIImageBase
{
public:
	virtual ~cUIImageBase() {}

	virtual void Draw() = 0;

	/// ؽó 
	virtual void SetTexture( NiTexture* ptex ) = 0;

	/// ̹ Ѵ.
	virtual void ChangeImage( NiTexture* /*ptex*/ ) {}

	/// ũ  ġ  [0, 1]
	virtual void SetPos( int x, int y ) = 0;

	/// ũ  ũ⸦  [0, 1]
	virtual void SetSize( float /*w*/, float /*h*/ ) {}

	/// ũ    [0, 1]
	virtual void SetScreenRect( const cUIRect& rect ) = 0;

	virtual void SetTextureRect( unsigned int tl, unsigned int tt, unsigned int tr, unsigned int tb ) = 0;
	virtual void SetTextureRect( const cUIRect& /*rect*/ ) {}

	///  
	virtual void SetColor( const NiColorA& color ) = 0;
	virtual const NiColorA& GetColor() const = 0;

	///  
	virtual void SetAlpha( float /*a*/ ) {}

	/// ȸ
	virtual void SetTranslate( float /*x*/, float /*y*/ ) {}
	virtual void SetRotate( float /*angle*/ ) {}

	///  θ 
	virtual bool IsValid() const;

	/// ؽó  
	const cUIRect& GetTextureRect() const;

	/// ̹  
	unsigned int GetWidth() const;

	/// ̹   
	unsigned int GetHeight() const;

protected:
	cUIImageBase() 
	{
		mTextureWidth = 0;
		mTextureHeight = 0;
	
		mWidthOnScreen = 1;
		mHeightOnScreen = 1;

		mTexRect.Set( 0, 0, 1, 1 );
	}

protected:
	/// ؽó ũ
	unsigned int mTextureWidth;
	unsigned int mTextureHeight;

	/// ؽó  [0, 1]
	cUIRect mTexRect;

	unsigned int mWidthOnScreen;
	unsigned int mHeightOnScreen;
};

inline bool cUIImageBase::IsValid() const
{
	if( mTextureWidth == 0 || mTextureHeight == 0 )
	{
		assert( 0 && "invalid base image size" );
		return false;
	}

	return true;
}

inline const cUIRect& cUIImageBase::GetTextureRect() const
{
	return mTexRect;
}

inline unsigned int cUIImageBase::GetWidth() const
{
	return mWidthOnScreen;
}

inline unsigned int cUIImageBase::GetHeight() const
{
	return mHeightOnScreen;
}
