/* ==========================================================================
*      : UIManager.h
*      : 
*    : ̼
*    : 2006.09.25
* ǻ : 
*===========================================================================*/
#pragma once

#include "UIEvent.h"
#include "UISkin.h"
#include "UIProperty.h"
#include "UIRect.h"
#include "BaseStage.h"
#include "IndexGenerator.h"

#include "Item_Common.h"

const unsigned int MAXEDIT_DEFAULTLENGTH = 8;

class cUINode;
class cUIContainer;
class cUIRootNode;
class cUIWindow;
class cUICursor;
class cUIIDList;
class cUIText;
class cUIImageFont;
class cUIFuncText;
class cUIFuncTextNode;
class cUINpcTelling;
class cMsgBox;
class cDragWindow;
class cApplication;
class cIconParam;
class cIcon;
class cUIRoundGauge;
class cPage;
struct sSceneData;

class cTipWindow;
class cItemTipWindow;
class cSkillTipWindow;
class cBuffToolTipWindow;
class cSimpleTipWindow;
class cChatTipWindow;

enum eMSGBox_Event;
enum eBoxSkin_Type;
enum eDragFrom;
enum eTip_Kind;
enum eNpcFunc;


/// UI 
class cUIManager
{
	friend class cApplication;
	static cUIManager* mpSingleton;

public:
	cUIManager();
	~cUIManager();

	/// ʱȭ
	void SetCurrentStage( eSTAGE stageIndex );
	bool InitSkin( const cString& pathName );
	bool InitImageFont();
	bool InitIcon();
	bool InitNpc();

	/// 
	void Reset();

	/// ֻ ö󰡾ϴ Node Ѵ.
	void GotoFrontNode( cUINode* node );
	void RemoveFrontNode( unsigned long frontId );

	/// ޼ڽ Ǿ 
	void GotoFrontMsgBox();

	///  ݱ ( ESC ư )
	bool Close();
	void NetUnLockAllUI();
	
	/// Ų ü
	void ChangeSkin( const cString& pathName );

	/// Ʈ
	void Process( unsigned long deltaTime, unsigned long accumTime );
	void Render();

	///  
	bool SetModal( cUIWindow* window );
	void ReleaseModal( cUIWindow* window );

	/// ޽ڽ ( ̺Ʈ , Ų÷, Ÿ, ѽð, ѽð , sucess = ѽð send ޼ Ÿ(,) )
	bool CreateModal( eSTAGE handlerIndex, eMSGBox_Event eventtype, LPCTSTR text, LPCTSTR captiontext, eBoxSkin_Type skintype, void* extraData = 0,
					  unsigned long totaltime = 0, bool printTime = false, bool success = false, unsigned int maxLen = MAXEDIT_DEFAULTLENGTH );
	void DestroyMsgBox( cMsgBox* pMsgBox );
	void CloseAllMsgBox( bool event );

	/// ޽ڽ text ü Ѵ.
	void ChangeModalMessage( LPCTSTR text );

	/// Ƿ ޹ڽ Ѵ.
	void SendEventToMsgbox( bool success, eMSGBox_Event eventtype );	///  ̺Ʈ   ݱ
	void ModalEventFromGameSystem( bool success );						///  ִ  ݱ
	void CloseMsgBox( eMSGBox_Event eventtype );						/// ش ̺Ʈ   ݴ´

	/// ڷκ ̺Ʈ 
	bool PostEventFromUser( const cUIEvent& event );

	/// ο  show   ó
	void CheckEventNode( cUINode* n );

	/// 콺 ĸ 带   
	void SetCaptureNode( cUINode* node );
	void ReleaseCaptureNode( cUINode* node );

	/// ȣ 
	void ReleaseHoverNode( cUINode* node );

	/// Ŀ 带   
	void SetFocusedNode( cUINode* node );
	void ReleaseFocusedNode( cUINode* node );

	/// 콺 ̺Ʈ ޴  ʱȭ( ȣ, ĸ )
	void ReleaseEventNode();

	///  ϵ Ŀ 带  Ѵ.
	void ClearFocusedNode();

	/// 
	void ShowItemTip( eTip_Kind tipkind, const cUIPos& pos, unsigned long itemIndex, int slotIndex, cUIRoundGauge* gauge );
	void ShowItemTip( eTip_Kind tipkind, const cUIPos& pos, unsigned long itemIndex, unsigned int enhance );
	void ShowOtherItemTip( eTip_Kind tipkind, const cUIPos& pos, sInventory& inven );
	void ShowSkillTip( eTip_Kind tipkind, cSkillTipWindow* pTip, const cUIPos& pos, unsigned long skillIdx, char stepIdx, bool store );
	void ShowBuffTip( cBuffToolTipWindow* pTip, const cUIPos& pos, unsigned long uniqueIdx, unsigned long influenceIdx, bool showTime = true );
	void ShowCommunityTip( cSimpleTipWindow* pTip, const cUIPos& pos, cStringT str );
	void ShowChatItemTip( const cUIPos& pos, sInventory& inven );
	void ShowChatItemTip( const cUIPos& pos, unsigned long itemIndex, int slotIndex );
	void ShowUITip( const cUIPos& pos, unsigned long tipIdx );
	void HideTip();

	/// 巡 
    void SetDragWindow( cDragWindow* dragWindow );
	void ShowDrag( cUIWindow* pcaller, eDragFrom dragFrom, cIcon* icon, const cUIPos& pos, bool shift );
	void HideDrag( cUIWindow* pcaller );
	bool IsVisibleDrag();

	/// NPC  
	void SetNpcBackWindow( cUIWindow* back );
	cUIWindow* GetNpcBackWindow() { return mpNpcBackWindow; }
	bool IsShowNpcBack();
	void ShowNpcBack();
	void HideNpcBack();
	void HideNpcBackNoMsg();

	void SetNpcFunc( eNpcFunc npcType );
	eNpcFunc GetNpcFunc();
	
	///  show 
	void SetRestoreShow( cUIWindow* n );

	/// Ư  show  ( npc â ݾ )
	void RestoreShow();

	/// ڱ ڽ ƴ ٸ 찡 콺 Ŭ ̺Ʈ ޴°  ޼ ߻
	void AddEventOtherClick( cUIWindow* win );

	/// ä   
	void SetChatItemTipWindow( cChatTipWindow* win );

	///  Ų 
	cUISkin* GetSkin() const;

	/// Ӽ  
	cUIProperty* GetProperty() const;

	/// UI ID Ʈ  
	cUIIDList* GetUIIDList() const;

	/// Ʈ 带 
	cUIRootNode* GetRootNode() const;

	/// ȣ 带  
	cUINode* GetHoverNode() const;

	/// 콺 ĸ 带 
	cUINode* GetCaptureNode() const;

	/// Ŀ 带 
	cUINode* GetFocusedNode() const;

	/// θ root ̳  
	cUIContainer* GetContainer( unsigned int id );
	cUIWindow* GetModalBox() { return mpModalMsgBox; }

	/// 尡 ̳  
	cUIContainer* UpdateNearContainer( cUIContainer* con, bool axisX ) const;

	LPCTSTR GetUIText( unsigned int textId );
	bool GetUIText( cStringT*, unsigned int textId );

	/// ̹ Ʈ
	cUIImageFont* GetImageFont( unsigned int fontIndex );

	/// 
	cIconParam* GetIconParam( unsigned int iconId );

	/// Npc
	cUINpcTelling* GetNpcTelling( unsigned int npcId ) const;
	const cUIFuncTextNode* GetNpcTextNode( unsigned int textId );

	//void AddVisibleArr( cUINode* node, bool visible );

	/// page
	bool AddPage( unsigned long pageIdx, cPage* page );
	cPage* GetPage( unsigned long pageIdx );

	/// scene
	sSceneData* GetSceneData( unsigned long sceneIdx );

	bool IsCameraEnableContainUI();

protected:
	/// ε
	bool LoadIDList( const cString& pathName );
	bool LoadSkin( const cString& pathName );
	bool LoadProperty( const cString& pathName );
	bool LoadSkinText( const cString& pathName );

	/// ̹ Ʈ
	bool LoadImageFonts( const cString& pathName );

	/// 
	bool LoadIconParams( const cString& pathName );

	/// Npc
	bool LoadNpcText( const cString& pathName );
	bool LoadNpcScripts( const cString& pathName );
	bool LoadNpcScript( const cString& pathName );
	bool LoadNpcScene( const cString& pathName );

	/// Reload ( ŲũƮ  ε )
	bool ReloadSkin( const cString& pathName );

	/// 콺 ĸ 带 
	void UpdateHoveredNode( cUIContainer* root, const cUIPos& pos );

	/// ڽ ƴ ٸ  Ŭ
	void EventOtherClick( const cUIPos& pos );

	void ShowTip();

	bool MsgBoxEventProcess( const cUIEvent& event );

	/// ֻ  Node  Ѵ.
	void ApplyFrontNode( cUINode* node );

public:
	/// ü 
	static cUIManager* GetSingleton();

private:
	void UpdateScreenSize( unsigned int width, unsigned int height );

protected:
	/// Ų
	cUISkin* mpSkin;
	/// Ӽ 
	cUIProperty* mpProperty;
	/// ؽƮ
	cUIText* mpSkinText;
	/// UI ID Ʈ 
	cUIIDList* mpIDList;
	/// Ʈ 
	cUIRootNode* mpRootNode;
	cUIRootNode* mpStageRootNode[eStage_Max];

	/// 콺 ĸ 
	cUINode* mpCaptureNode;
	/// 콺  
	cUINode* mpHoveredNode;
	/// Ŀ 
	cUINode* mpFocusedNode;

	///  ޽ ڽ
	cUIWindow* mpModalMsgBox;

	/// 콺 ̺Ʈ ߻ ǰ  
	cUIPos	mMousePos;

	/// 
	cTipWindow* mTipWindow;

	/// ä  
	cChatTipWindow* mChatItemTipWindow;

	/// 巡
	cDragWindow* mpDragWindow;

	/// ̿ npc Ÿ
	eNpcFunc mNpcFuncType;

	/// NPC Back 
	cUIWindow* mpNpcBackWindow;
	
	///  Ǿ MsgBox鿡  ó..
	typedef	tPointerList<void*> cDestroyMsgBoxList;
	cDestroyMsgBoxList	mDestroyMsgBoxList;

	typedef tPointerHashMap<unsigned long, void*> cApplyFrontMap;
	cApplyFrontMap						mApplyFrontMap;
	cIndexGenerator<unsigned long>		mFrontIdGen;

	/// ̹ Ʈ
	typedef tHashMap<unsigned int, void*> cImageFontMap;
	cImageFontMap mImageFontMap;

	/// 
	typedef tHashMap<unsigned int, void*> cTextureMap;
	cTextureMap mIconTextureMap;

	typedef tHashMap<unsigned int, void*> cIconParamMap;
	cIconParamMap mIconParamMap;

	/// Npc
	cUIFuncText* mpNpcText;
	typedef tHashMap<unsigned int, void*> cNpcTellingMap;
	cNpcTellingMap mNpcTellingMap;

	///   (ε,  )
	typedef tPointerHashMap<unsigned long, void*> cPageMap;
	cPageMap mPageMap;

	///   ̹ ũƮ
	typedef tPointerHashMap<unsigned long, void*> cSceneMap;
	cSceneMap mSceneMap;

	/// npc 찡    
	typedef tArray<void*> cRestoreShow;
	cRestoreShow mRestore;

	/// ޼ڽ 
	typedef tPointerList<void*> cMsgBoxList;
	cMsgBoxList	mMsgBoxList;

	/// eUIEVENT_MOUSE_OTHERCLICK  ޼  UI 
	typedef tPointerList<void*> cOtherClickList;
	cOtherClickList	mOtherClickList;
};

inline void cUIManager::SetCurrentStage( eSTAGE i )
{
	mpRootNode = mpStageRootNode[i];
}

inline void cUIManager::SetDragWindow( cDragWindow* dragWindow )
{
	if( dragWindow )
		mpDragWindow = dragWindow;
}

inline void cUIManager::SetNpcBackWindow(cUIWindow* back )
{
	if( back )
		mpNpcBackWindow = back;
}

inline void cUIManager::SetNpcFunc( eNpcFunc npcType )
{
	mNpcFuncType = npcType;
}

inline eNpcFunc cUIManager::GetNpcFunc()
{
	return mNpcFuncType;
}

inline void cUIManager::SetChatItemTipWindow( cChatTipWindow* win )
{
	if( win )
		mChatItemTipWindow = win;
}

inline cUISkin* cUIManager::GetSkin() const
{
	return mpSkin;
}

inline cUIProperty* cUIManager::GetProperty() const
{
	return mpProperty;
}

inline cUIIDList* cUIManager::GetUIIDList() const
{
	return mpIDList;
}

inline cUIRootNode* cUIManager::GetRootNode() const
{
	return mpRootNode;
}

inline cUINode* cUIManager::GetHoverNode() const
{
	return mpHoveredNode;
}

inline cUINode* cUIManager::GetCaptureNode() const
{
	return mpCaptureNode;
}

inline cUINode* cUIManager::GetFocusedNode() const
{
	return mpFocusedNode;
}

inline cUIManager* cUIManager::GetSingleton()
{
	return mpSingleton;
}

#define UIMAN cUIManager::GetSingleton()
