#include "stdafx.h"
#include "UIManager.h"

#include "ResourceManager.h"

#include "Token.h"
#include "Lexer.h"
#include "Parser.h"
#include "Icon.h"

bool cUIManager::InitIcon()
{
	if( LoadIconParams( "./Script/Interface/Path_Icon.txt" ) == false )
	{
		return false;
	}
	return true;
}

bool cUIManager::LoadIconParams( const cString& pathName )
{
	///  
	cFileLoader loader;

	if( loader.Open( pathName, true ) == false )
	{
		assert( 0 && "failed to load icon params" );
		return false;
	}

	///  ְ Ľ
	cToken token;
	cLexer lexer( loader.GetBufferPtr(), loader.GetSize() );
	cParser parser( &lexer, pathName );

	///  ̹ ε
	if( parser.ExpectTokenString( "images" ) == false )
		return false;
	if( parser.ExpectTokenString( "{" ) == false )
		return false;

	while( lexer.IsEnd() == false )
	{
		lexer.GetNextToken( &token );

		if( token.mType == eTOKEN_RCURLY )
			break;

		switch( token.mType )
		{
		case eTOKEN_ERROR:
			return false;
		case eTOKEN_NULL:
			continue;
		case eTOKEN_INT:
			{
				/// ؽó ε
				unsigned int id = token.ToInt();
				lexer.GetNextToken( &token );
				assert( token.mType == eTOKEN_STR );

				cString pathName;
				pathName.Format( "./Data/2DData/%s", token.Cstr() );
				NiTexture* p = RESOURCEMAN->LoadTexture( pathName, false );

				if( p == 0 )
				{
					assert( 0 && "failed to load texture" );
					return false;
				}

				/// ؽó ʿ ߰
				mIconTextureMap.Insert( id, p );

				unsigned int width, height;
				width = p->GetWidth();
				height = p->GetHeight();
			}
			break;
		default:
			assert( 0 && "invalid token" );
			return false;
		}
	}

	///   Ʈ Ľ
	if( parser.ExpectTokenString( "iconParams" ) == false )
		return false;
	if( parser.ExpectTokenString( "{" ) == false )
		return false;

	while( lexer.IsEnd() == false )
	{
		lexer.GetNextToken( &token );

		if( token.mType == eTOKEN_RCURLY )
			break;

		switch( token.mType )
		{
		case eTOKEN_ERROR:
			return false;
		case eTOKEN_NULL:
			continue;
		case eTOKEN_INT:
			{
				unsigned int iconIndex = token.ToInt();

				lexer.GetNextToken( &token );
				assert( token.mType == eTOKEN_INT );
				unsigned int imageIndex = token.ToInt();

				lexer.GetNextToken( &token );
				assert( token.mType == eTOKEN_INT );
				unsigned int texx = token.ToInt();

				lexer.GetNextToken( &token );
				assert( token.mType == eTOKEN_INT );
				unsigned int texy = token.ToInt();

				///   ʿ ߰
				cTextureMap::cIterator i = mIconTextureMap.Find( imageIndex );
				if( i == mIconTextureMap.End() )
				{
					assert( 0 && "failed to find icon texture by id" );
					return false;
				}

				cIconParam* param = new cIconParam;
				param->mpTexture = (NiTexture*)i->mSecond;
				//test
				assert( param->mpTexture );
				//
				param->mTexPos.mX = texx;
				param->mTexPos.mY = texy;

				if( mIconParamMap.Insert( iconIndex, param ) == false )
				{
					assert( 0 && "failed to insert icon param, icon id maybe already exist" );
					return false;
				}
			}
			break;
		default:
			assert( 0 && "invalid token" );
			return false;
		}
	}
	return true;
}

cIconParam* cUIManager::GetIconParam( unsigned int iconId )
{
	cIconParamMap::cIterator i = mIconParamMap.Find( iconId );

	if( i == mIconParamMap.End() )
		return 0;
	else
		return (cIconParam*)(i->mSecond);
}
