#include "stdafx.h"
#include "UIManager.h"

#include "ResourceManager.h"

#include "Tokenizer.h"
#include "UIImageFont.h"

bool cUIManager::InitImageFont()
{
	if( LoadImageFonts( "./Script/Interface/Path_Font.txt" ) == false )
	{
		assert( 0 && "failed to load ui image fonts" );
		return false;
	}
	return true;
}

bool cUIManager::LoadImageFonts( const cString& pathName )
{
	///  
	cFileLoader loader;

	if( loader.Open( pathName, true ) == false )
	{
		assert( 0 && "failed to load image fonts" );
		return false;
	}

	cTokenizer tokenizer( loader.GetBufferPtr(), loader.GetSize(), " \t\r\n", pathName.Cstr() );
	cString str;

	while( tokenizer.IsEnd() == false )
	{
		/// ε
		if( tokenizer.GetNext( &str ) == false )
			return false;

		unsigned int index = str.ToInt();

		/// ̹ ε
		if( tokenizer.GetNext( &str ) == false )
			return false;

		unsigned int imageIndex = str.ToInt();

		/// ؽó  ġ
		if( tokenizer.GetNext( &str ) == false )
			return false;

		unsigned int texX = str.ToInt();

		if( tokenizer.GetNext( &str ) == false )
			return false;

		unsigned int texY = str.ToInt();

		/// ؽó Ʈ  ũ
		if( tokenizer.GetNext( &str ) == false )
			return false;

		unsigned int charWidth = str.ToInt();

		if( tokenizer.GetNext( &str ) == false )
			return false;

		unsigned int charHeight = str.ToInt();

		/// ̹ Ʈ 
		NiTexture* tex = UIMAN->GetSkin()->GetTexture( imageIndex );
		if( tex == 0 )
			continue;

		cUIImageFont* imageFont = new cUIImageFont( tex, texX, texY, charWidth, charHeight );

		if( mImageFontMap.Insert( index, imageFont ) == false )
		{
			assert( 0 && "failed to insert image font, maybe already exist" );
			return false;
		}
	}
	return true;
}

cUIImageFont* cUIManager::GetImageFont( unsigned int fontIndex )
{
	cImageFontMap::cIterator i = mImageFontMap.Find( fontIndex );

	if( i == mImageFontMap.End() )
		return 0;
	else
		return (cUIImageFont*)(i->mSecond);
}
