#include "StdAfx.h"
#include "UINode.h"

#include "UINodeData.h"
#include "UINodeProperty.h"
#include "UIContainer.h"
#include "UIEvent.h"
#include "UIImage.h"
#include "UITransformImage.h"
#include "UIRootNode.h"
#include "UIIDList.h"

#include "RenderSystem.h"

cUINode::cUINode( eUINodeType type )
: mType( type )
, mpParent( 0 )
, mID( 0 )
, mFrontID( 0 )
, mpImage( 0 )
, mVisible( true )
, mEnabled( true )
, mPressed( false )
, mMove( false )
, mAlpha( 1.0f )
, mNetLock( false )
, mLockTry( -1 )
, mUseTransform( false )
, mBackupVisible( true )
{
	mSnapType = eSNAP_NONE;

	mRelativeRect.Set(0, 0, 0, 0);
	mAbsoluteRect.Set(0, 0, 0, 0);

	mOldScreenWidth = GetScreenWidth();
	mOldScreenHeight = GetScreenHeight();

	mDefaultColor = eCOLOR_DEFAULT;

	/// ũƮ ǥ ش   Ѵ
	mDefaultWidth = 1024;
	mDefaultHeight = 768;

	mExceptionEvent = false;
	mLClickNotifyStage = false;
	mProcessEnable = false;

	mUseBoldText = false;

	mHoverTipIndex = 0;
}

cUINode::~cUINode()
{
	Destroy();
}

///
bool cUINode::CreateByProperty( cUINodeProperty* pProperty, cUIContainer* pparent, bool bTransform )
{
	assert( UIMAN && "null ui manager" );
	assert( GetRoot() && "null ui root node" );

	mUseTransform = bTransform;

	/// ̵ ˻
	if( mID > 0 )
	{
		assert( 0 && "ui node is already created" );
		return false;
	}

	/// ̵ 
	/// Ƽ ̵ ̵𸮽Ʈ ΰ´.
	cUIIDList* pIDList = UIMAN->GetUIIDList();
	if( pIDList == 0 )
	{
		assert( 0 && "null ID List" );
		return false;
	}

	/// ̵ 
	mID = pIDList->GetPropID( pProperty->mPropertyName );
	if( mID <= 0 )
	{
		/// ̵ 쿣 ӽ ̵ ش
		mID = 100000;
	}

	/// Ų ̸ 
	mSkinName = pProperty->mSkinName;

	///  κ  
	if( SetupNode( pparent ) == false )
		return false;

	if( OnCreate(pProperty) == false )
		return false;

	if( mpParent->IsKindof( eUINODE_ROOT ) == true )
		((cUIRootNode*)mpParent)->AddProcessChild( this );

	return IsValid();
}

///
bool cUINode::CreateByPropertyId( cUINodeProperty* pProperty, cUIContainer* pparent, unsigned int id, bool bTransform )
{
	assert( UIMAN && "null ui manager" );
	assert( GetRoot() && "null ui root node" );

	mUseTransform = bTransform;

	/// ̵ ˻
	if( mID > 0 )
	{
		assert( 0 && "ui node is already created" );
		return false;
	}

	/// Ų ̸ 
	mSkinName = pProperty->mSkinName;

	/// ̵ 
	mID = id;
	if( mID <= 0 )
	{
		/// ̵ 쿣 ӽ ̵ ش
		mID = 100000;
	}

	///  κ  
	if( SetupNode( pparent ) == false )
		return false;

	if( OnCreate(pProperty) == false )
		return false;

	if( mpParent->IsKindof( eUINODE_ROOT ) == true )
		((cUIRootNode*)mpParent)->AddProcessChild( this );

	return IsValid();
}

// ǻ : Ų ʿ Ϲ  ̰ɷ  
bool cUINode::CreateBySkinName( const cString& skinName, cUIContainer* pparent, unsigned int id, bool bTransform )
{
	assert( UIMAN && "null ui manager" );
	assert( GetRoot() && "null ui root node" );

	mUseTransform = bTransform;

	/// Ų ̸ 
	mSkinName = skinName;

	/// ̵ 
	mID = id;

	///  κ  
	if( SetupNode( pparent ) == false )
		return false;

	if( OnCreate() == false )
		return false;

	if( mpParent->IsKindof( eUINODE_ROOT ) == true )
		((cUIRootNode*)mpParent)->AddProcessChild( this );

	return IsValid();
}

bool cUINode::CreateByPropertyName( const cString& propertyName, cUIContainer* pparent, bool bTransform )
{
	assert( UIMAN && "null ui manager" );
	assert( GetRoot() && "null ui root node" );

	mUseTransform = bTransform;

	/// ̵ ˻
	if( mID > 0 )
	{
		assert( 0 && "ui node is already created" );
		return false;
	}

	cUIProperty* prop = UIMAN->GetProperty();
	cUINodeProperty* nodeProp = prop->GetNodeProperty( propertyName );
	if( nodeProp == 0 )
	{
		assert( 0 && "failed to find ui node property" );
		return false;
	}

	/// Ƽ ̵ ̵𸮽Ʈ ΰ´.
	cUIIDList* pIDList = UIMAN->GetUIIDList();
	if( pIDList == 0 )
	{
		assert( 0 && "null ID List" );
		return false;
	}

	/// ̵ 
	mID = pIDList->GetPropID( nodeProp->mPropertyName );
	if( mID <= 0 )
	{
		/// ̵ 쿣 ӽ ̵ ش
		mID = 100000;
	}

	/// Ų ̸ 
	mSkinName = nodeProp->mSkinName;

	///  κ 
	if( SetupNode( pparent ) == false )
		return false;

	if( OnCreate(nodeProp) == false )
		return false;

	if( mpParent->IsKindof( eUINODE_ROOT ) == true )
		((cUIRootNode*)mpParent)->AddProcessChild( this );

	return IsValid();
}

/// ǻ :     κ  
bool cUINode::SetupNode( cUIContainer* pparent )
{
	/// θ 
	assert( mpParent == 0 && "parent already exists!" );

	if( pparent == 0 )
	{
		mpParent = GetRoot();
	}
	else if( pparent->IsKindof( eUINODE_CONTAINER ) )
	{
		mpParent = pparent;
	}
	else
	{
		assert( 0 && "parent should be kind of container");
		return false;
	}

	/// Ų 
	if( ApplySkin() == false )
	{
		assert( 0 && "failed to apply node skin");
		return false;
	}

	/// θ ߰
	mpParent->AddChild( this );

	/// θ ֻƮ ƴϸ İ ͼ  
	if( mpParent != GetRoot() )
	{
		SetAlpha( mpParent->GetAlpha() );
	}

	/// ʹݿ   visible  
	if( mType == eUINODE_WINDOW || mType == eUINODE_TABWINDOW )
	{
		mVisible = false;
	}

	return true;
}

/// ǻ : 
void cUINode::Destroy()
{
	if( mID )
	{
		OnDestroy();

		/// ~
		mID = 0;
	}

	if( mFrontID )
	{
		UIMAN->RemoveFrontNode( mFrontID );

		mFrontID = 0;
	}

	/// ̹ 
	delete mpImage;
	mpImage = 0;

	/// θκ 
	if( mpParent )
	{
		mpParent->RemoveChild( this );
	}
}

/// ǻ : Ų о   
bool cUINode::ApplySkin()
{
	cUISkin* pskin = UIMAN->GetSkin();
	if( pskin == 0 )
	{
		assert( 0 && "null skin" );
		return false;
	}

	///  Ų ˻
	cUINodeSkin* pnodeSkin = pskin->GetNodeSkin( mSkinName );
	if( pnodeSkin == 0 )
	{
		assert( 0 && "failed to find node skin" );
		return false;
	}
	
	///  Ų 
	if( SetSkin( pnodeSkin ) == false )
	{
		return false;
	}
	return true;
}

/// ǻ : 
bool cUINode::SetSkin( const cUINodeSkin* skin )
{
	if( skin == 0 )
	{
		assert( 0 && "null skin" );
		return false;
	}

	///  Ų ռ ˻
	if( skin->IsValid() == false )
	{
		assert( 0 && "invalid skin" );
		return false;
	}

	/// ̹ 
	if( skin->mpTexture )
	{
		if( mpImage == 0 )
		{
			if( mUseTransform )
			{
				mpImage = new cUITransformImage;
				mpImage->SetTexture( skin->mpTexture );
			}
			else
				mpImage = new cUIImage( skin->mpTexture );
		}
		else
		{
			mpImage->SetTexture( skin->mpTexture );
		}

		/// ÷ 
		mpImage->SetColor( skin->mColor );
		
		/// ؽó  
		unsigned int tx = skin->mSkinInfo->mTexX;
		unsigned int ty = skin->mSkinInfo->mTexY;
		unsigned int tw = skin->mSkinInfo->mTexWidth;
		unsigned int th = skin->mSkinInfo->mTexHeight;

		mpImage->SetTextureRect( tx, ty, tx + tw, ty + th );
	}
	else
	{
		delete mpImage;
		mpImage = 0;
	}

	/// Ʈ ٷ ڽ  ǥ ä ػ󵵸 
	if( mpParent == 0 )
	{
		assert(0);
		return false;
	}

	int x = skin->mSkinInfo->mX;
	int y = skin->mSkinInfo->mY;
	unsigned int w = skin->mSkinInfo->mWidth;
	unsigned int h = skin->mSkinInfo->mHeight;

	/// θ Ʈ Ÿ̸  
	if( mpParent->GetType() == eUINODE_ROOT )
	{
		x = ( GetScreenWidth() * skin->mSkinInfo->mX ) / mDefaultWidth;
		y = ( GetScreenHeight() * skin->mSkinInfo->mY ) / mDefaultHeight;

		/// ̳ Ʒʿ 찡 پ ػ ÿ
		/// پֵ Ѵ 
		if( (skin->mSkinInfo->mX + skin->mSkinInfo->mWidth) >= (int)mDefaultWidth )
		{
			x = GetScreenWidth() - w;
		}

		if( (skin->mSkinInfo->mY + skin->mSkinInfo->mHeight) >= (int)mDefaultHeight )
		{
			y = GetScreenHeight() - h;
		}
	}

	mHoverTipIndex = skin->mSkinInfo->mHoverTipIndex;

	/// 
	SetRelativeRect( cUIRect( x, y, x + w, y + h) );
	return true;
}

/// ǻ : ػ  ȣ 
void cUINode::UpdateSkin()
{
	cUISkin* pskin = UIMAN->GetSkin();
	if( pskin == 0 )
	{
		assert(0);
	}

	///  Ų ˻                               
	cUINodeSkin* pnodeSkin = pskin->GetNodeSkin( mSkinName );
	if( pnodeSkin == 0 )
	{
		assert(0);
	}

	/// Ʈ ٷ ڽ  ǥ ä ػ󵵸 
	if( mpParent == 0 )
	{
		assert(0);
		return;
	}

	///  ο ǥ * ο ػ 
	int x = pnodeSkin->mSkinInfo->mX;
	int y = pnodeSkin->mSkinInfo->mY;
	unsigned int w = pnodeSkin->mSkinInfo->mWidth;
	unsigned int h = pnodeSkin->mSkinInfo->mHeight;

	/// θ Ʈ Ÿ̸  
	if( mpParent->GetType() == eUINODE_ROOT )
	{
  		/*x = ( GetScreenWidth() * GetAbsoluteRect().mLeft ) / mOldScreenWidth;
		y = ( GetScreenHeight() * GetAbsoluteRect().mTop ) / mOldScreenHeight;*/
		x = ( GetScreenWidth() * pnodeSkin->mSkinInfo->mX ) / mDefaultWidth;
		y = ( GetScreenHeight() * pnodeSkin->mSkinInfo->mY ) / mDefaultHeight;

		/// ̳ Ʒʿ 찡 پ ػ ÿ
		/// پֵ Ѵ 
		if( GetAbsoluteRect().mRight >= (int)mOldScreenWidth )
		{
			x = GetScreenWidth() - w;
		}

		if( GetAbsoluteRect().mBottom >= (int)mOldScreenHeight )
		{
			y = GetScreenHeight() - h;
		}
	}

	mHoverTipIndex = pnodeSkin->mSkinInfo->mHoverTipIndex;

	/// 
	SetRelativeRect( cUIRect( x, y, x + w, y + h) );

	///  ػ  
	mOldScreenWidth = GetScreenWidth();
	mOldScreenHeight = GetScreenHeight();
}

/// ǻ : 
bool cUINode::IsValid() const
{
	if( mpParent == 0 )
	{
		assert( 0 && "null parent" );
		return false;
	}
	if( mpImage && mpImage->IsValid() == false )
	{
		assert( 0 && "invalid image" );
		return false;
	}
	if( mpImage && mpImage->GetTextureRect().IsValid() == false )
	{
		assert( 0 && "invalid tex rect" );
		return false;
	}
	return true;
}

///
void cUINode::SetColor( float r, float g, float b, float a )
{
	if( mpImage )
	{
		mpImage->SetColor( NiColorA(r,g,b,a) );
	}
}

///
void cUINode::SetColor( const NiColorA& color )
{
	if( mpImage )
	{
		mpImage->SetColor( color );
	}
}

/// ǻ : 
void cUINode::SetAlpha( float a )
{
	mAlpha = a;

	if( mpImage )
	{
		mpImage->SetAlpha( mAlpha );
	}
}

/// ǻ : 
void cUINode::UpdateRect()
{
	///  ǥ θ  ʰ Ѵ (̻   )
	unsigned int rWidth = mRelativeRect.GetWidth();
	unsigned int rHeight = mRelativeRect.GetHeight();

	/// ȭ   
	if( mRelativeRect.mLeft < 0 )
	{
		mRelativeRect.mLeft = 0;
		mRelativeRect.mRight = mRelativeRect.mLeft + rWidth;
	}
	if( mRelativeRect.mRight > (int)GetScreenWidth() )
	{
		mRelativeRect.mRight = GetScreenWidth();
		mRelativeRect.mLeft = mRelativeRect.mRight - rWidth;
	}
	if( mRelativeRect.mTop < 0 )
	{
		mRelativeRect.mTop = 0;
		mRelativeRect.mBottom = mRelativeRect.mTop + rHeight;
	}
	if( mRelativeRect.mBottom > (int)GetScreenHeight() )
	{
		mRelativeRect.mBottom = GetScreenHeight();
		mRelativeRect.mTop = mRelativeRect.mBottom - rHeight;
	}

	cUIRect& parentAbsolute = mpParent->mAbsoluteRect;
	mAbsoluteRect = mRelativeRect + parentAbsolute.mUpperLeft;

	///  ǥ ü ȭ   ʵ 
	unsigned int abWidth = mAbsoluteRect.GetWidth();
	unsigned int abHeight = mAbsoluteRect.GetHeight();

	/// ̳ 쿡
	if( mMove && IsKindof( eUINODE_CONTAINER ) )
	{
		/// ׶ ̳ʸ ׳  
		cUIContainer* pCon = (cUIContainer*)this;
		if( pCon->IsOnlyBackground() == true )
			return;

		if( this->mpParent == GetRoot() )
		{
			mAbsoluteRect = mRelativeRect;

			/// UI ڼ
			ApplySnap();

			if( ::abs(mAbsoluteRect.mLeft) <= (AUTO_MAGNATIC_DIST / 2) )
			{
				mAbsoluteRect.mLeft = 0;
				mAbsoluteRect.mRight = mAbsoluteRect.mLeft + abWidth;
			}
			if( GetScreenWidth() - mAbsoluteRect.mRight <= (AUTO_MAGNATIC_DIST / 2) )
			{
				mAbsoluteRect.mRight = GetScreenWidth();
				mAbsoluteRect.mLeft = mAbsoluteRect.mRight - abWidth;
			}
			if( ::abs(mAbsoluteRect.mTop) <= (AUTO_MAGNATIC_DIST / 2) )
			{
				mAbsoluteRect.mTop = 0;
				mAbsoluteRect.mBottom = mAbsoluteRect.mTop + abHeight;
			}
			if( GetScreenHeight() - mAbsoluteRect.mBottom <= (AUTO_MAGNATIC_DIST / 2) )
			{
				mAbsoluteRect.mBottom = GetScreenHeight();
				mAbsoluteRect.mTop = mAbsoluteRect.mBottom - abHeight;
			}
		}

		/// Ʈ  ġ̹Ƿ, ϰ .
		//mRelativeRect = mAbsoluteRect;
		mMove = false;
	}

	/// ̹  
	if( mpImage )
	{
		mpImage->SetScreenRect( mAbsoluteRect );
	}
}

/// ǻ :UI ̳ʰ ̵ÿ ڼ 
void cUINode::ApplySnap()
{
	unsigned int abWidth = mAbsoluteRect.GetWidth();
	unsigned int abHeight = mAbsoluteRect.GetHeight();

	///  ̵ 찡 پ 츦 ã´.(x˻)
	cUIContainer* interConX = UIMAN->UpdateNearContainer( (cUIContainer*)this, true );
	if( interConX )
	{
		///  ̳ ʿ پ 
		if( mSnapType == eSNAP_RIGHT )
		{
			mAbsoluteRect.mLeft = interConX->GetAbsoluteRect().mRight;
			mAbsoluteRect.mRight = mAbsoluteRect.mLeft + abWidth;
		}
		///  ̳ ʿ پ 
		if( mSnapType == eSNAP_LEFT )
		{	
			mAbsoluteRect.mRight = interConX->GetAbsoluteRect().mLeft;
			mAbsoluteRect.mLeft = mAbsoluteRect.mRight - abWidth;
		}
		/// ̳ʿ LEFT   Ȯ ٿ ( LEFT )
		if( mSnapType == eSNAP_LEFT_OUT )
		{
			mAbsoluteRect.mLeft = interConX->GetAbsoluteRect().mLeft;
			mAbsoluteRect.mRight = mAbsoluteRect.mLeft + abWidth;
		}
		/// ̳ʿ RIGHT   Ȯ ٿ ( RIGHT )
		if( mSnapType == eSNAP_RIGHT_OUT )
		{
			mAbsoluteRect.mRight = interConX->GetAbsoluteRect().mRight;
			mAbsoluteRect.mLeft = mAbsoluteRect.mRight - abWidth;
		}
	}

	/// y ˻
	cUIContainer* interConY = UIMAN->UpdateNearContainer( (cUIContainer*)this, false );
	if( interConY )
	{
		///  ̳ Ʒʿ ٿ
		if( mSnapType == eSNAP_BOTTOM )
		{
			mAbsoluteRect.mTop = interConY->GetAbsoluteRect().mBottom;
			mAbsoluteRect.mBottom = mAbsoluteRect.mTop + abHeight;
		}
		///  ̳ ʿ ٿ 
		if( mSnapType == eSNAP_TOP )
		{
			mAbsoluteRect.mBottom = interConY->GetAbsoluteRect().mTop;
			mAbsoluteRect.mTop = mAbsoluteRect.mBottom - abHeight;
		}
		/// ̳ʿ TOP   Ȯ ٿ ( TOP )
		if( mSnapType == eSNAP_TOP_OUT )
		{
			mAbsoluteRect.mTop = interConY->GetAbsoluteRect().mTop;
			mAbsoluteRect.mBottom = mAbsoluteRect.mTop + abHeight;
		}
		/// ̳ʿ BOTTOM   Ȯ ٿ ( BOTTOM )
		if( mSnapType == eSNAP_BOTTOM_OUT )
		{
			mAbsoluteRect.mBottom = interConY->GetAbsoluteRect().mBottom;
			mAbsoluteRect.mTop = mAbsoluteRect.mBottom - abHeight; 
		}
	}
}

bool cUINode::ContainPoint( const cUIPos& pos ) const
{
	return mAbsoluteRect.ContainPoint( pos );
}

/// ǻ : 
void cUINode::Move( const cUIPos& value )
{
	mRelativeRect += value;
	mMove = true;
	UpdateRect();
}

void cUINode::Show()
{
	mVisible = true;
}

void cUINode::Hide()
{
	mVisible = false;
}

/// ǻ : ڱڽ   
void cUINode::SetPress( bool press )
{
	if( mEnabled == false )
		return;

	if( mPressed != press )
		mPressed = press;
}

cUINode* cUINode::GetFocus()
{
	return UIMAN->GetFocusedNode();
}

cUINode* cUINode::GetHover()
{
	return UIMAN->GetHoverNode();
}

void cUINode::CheckEventNode()
{
	UIMAN->CheckEventNode( this );
}

void cUINode::SetCapture()
{
	UIMAN->SetCaptureNode( this );
}

void cUINode::ReleaseCapture()
{
	UIMAN->ReleaseCaptureNode( this );
}

void cUINode::ReleaseHover()
{
	UIMAN->ReleaseHoverNode( this );
}

void cUINode::SetFocus()
{
	UIMAN->SetFocusedNode( this );
}

void cUINode::ReleaseFocus()
{
	UIMAN->ReleaseFocusedNode( this );
}

void cUINode::ReleaseEventNode()
{
	UIMAN->ReleaseEventNode();
}

cUIRootNode* cUINode::GetRoot()
{
	return UIMAN->GetRootNode();
}

cUINode* cUINode::GetCapture()
{
	return UIMAN->GetCaptureNode();
}

unsigned int cUINode::GetScreenWidth()
{
	return RENDERSYS->GetScreenWidth();
}

unsigned int cUINode::GetScreenHeight()
{
	return RENDERSYS->GetScreenHeight();
}

bool cUINode::SendEvent( cUINode* eventHandler, eUIEventType eventType, cUINode* caller, unsigned int id, bool shift )
{
	assert( eventHandler );
	assert( caller );

	cUIEvent event;
	event.mType = eventType;
	event.mpCaller = caller;
	event.mID = id;
	event.mShift = shift;
	
	return eventHandler->HandleEvent( event );
}

/// ǻ : 
bool cUINode::HandleEvent( const cUIEvent& event )
{
	/// Ȱȭ 쿡 θ ̺Ʈ ѱ LSG070228
	if( mEnabled == false || mVisible == false )
	{
		return mpParent->HandleEvent( event );
	}

	switch( event.mType )
	{
	case eUIEVENT_CAPTURE_LOST:
		OnCaptureLost();
		break;

	case eUIEVENT_FOCUS_LOST:
		OnFocusLost();
		break;

	case eUIEVENT_MOUSE_MOVE:
		OnMouseMove( event.mPos );
		break;

	case eUIEVENT_MOUSE_WHEEL:
		OnMouseWheel( event.mPos, event.mWheel );
		break;

	case eUIEVENT_LBUTTON_DOWN:
		OnLButtonDown( event.mPos, event.mControl, event.mAlt, event.mShift );
		break;

	case eUIEVENT_RBUTTON_DOWN:
		OnRButtonDown( event.mPos, event.mControl, event.mAlt, event.mShift  );
		break;

	case eUIEVENT_LBUTTON_UP:
		OnLButtonUp( event.mPos );
		break;

	case eUIEVENT_RBUTTON_UP:
		OnRButtonUp( event.mPos );
		break;

	case eUIEVENT_LBUTTON_DBLCLK:
		OnLButtonDoubleClick( event.mPos );
		break;

	case eUIEVENT_MOUSE_HOVERED:
		OnMouseHovered( event.mPos );
		break;

	case eUIEVENT_MOUSE_LEFT:
		OnMouseLeft( event.mPos );
		break;

	case eUIEVENT_KEY_DOWN:
		OnKeyDown( event.mCode );
		break;

	case eUIEVENT_KEY_UP:
		OnKeyUp( event.mCode );
		break;

	case eUIEVENT_CHAR:
		OnChar( event.mWparam );
		break;

	case eUIEVENT_IME_NOTIFY:
		OnImeNotify( event.mWparam );
		break;

	case eUIEVENT_IME_STARTCOMPOSITION:
		break;

	case eUIEVENT_IME_ENDCOMPOSITION:
		break;

	case eUIEVENT_IME_COMPOSITION:
		OnImeComposition( event.mWparam, event.mLparam );
		break;

	default:
		return false;
	}
	return true;
}

void cUINode::OnLButtonDown( const cUIPos& /*pos*/, bool /*ctrl*/, bool /*alt*/, bool /*shift*/ )
{
	UIMAN->GotoFrontNode( this );
}

void cUINode::OnMouseHovered( const cUIPos& pos )
{
	if( mHoverTipIndex > 0 )
		UIMAN->ShowUITip( pos, mHoverTipIndex );
}

void cUINode::OnMouseLeft( const cUIPos& )
{
	if( mHoverTipIndex > 0 )
		UIMAN->HideTip();
}
