/* ==========================================================================
*      : UINode.h
*      : 
*    : 谡
*    : 2006-11-30
* ǻ :
*===========================================================================*/
#pragma once

#include "UIRect.h"
#include "UIKeyCode.h"
#include "UIFontItemKeeper.h"
#include "UIManager.h"

class cUINodeSkin;
class cUIEvent;
class cUIImageBase;
class cUIRootNode;
class cUIContainer;
class cUINodeProperty;
class cUIManager;

typedef tUIRect<int> cUIRect;
typedef tUIPos<int> cUIPos;
typedef tUISize<int> cUISize;

/// ڼ Ÿ  
const int AUTO_MAGNATIC_DIST = 20;

///  
const int ICON_SIZE = 28;

/// UI  Ÿ
enum eUINodeType
{
	eUINODE_NULL			= 0,
	eUINODE_CONTAINER		= (1 <<  0),
	eUINODE_ROOT			= (1 <<  1) | eUINODE_CONTAINER,
	eUINODE_WINDOW			= (1 <<  2) | eUINODE_CONTAINER,
	eUINODE_BUTTON			= (1 <<  3),
	eUINODE_PUSHBUTTON		= (1 <<  4) | eUINODE_BUTTON,
	eUINODE_CHECKBOX		= (1 <<  5),
	eUINODE_LABEL			= (1 <<  6),
	eUINODE_EDITBOX			= (1 <<  8),
	eUINODE_LISTBOX			= (1 <<  9) | eUINODE_WINDOW,
	eUINODE_SCROLLBAR		= (1 << 10) | eUINODE_WINDOW,
	eUINODE_BARBUTTON		= (1 << 11) | eUINODE_BUTTON,
	eUINODE_COMBOBOX		= (1 << 12) | eUINODE_WINDOW,
	eUINODE_GAUGE			= (1 << 13),
	eUINODE_GAUGETB			= (1 << 14),
	eUINODE_DOUBLEGAUGE		= (1 << 15),
	eUINODE_TEXTBOX			= (1 << 16) | eUINODE_WINDOW,
	eUINODE_MESSAGEBOX		= (1 << 17) | eUINODE_WINDOW,
	eUINODE_TABWINDOW		= (1 << 18) | eUINODE_WINDOW,
	eUINODE_TABBUTTON		= (1 << 19) | eUINODE_PUSHBUTTON,
	eUINODE_SPINBOX			= (1 << 20) | eUINODE_WINDOW,
	eUINODE_ICON			= (1 << 21), 
	eUINODE_NUMBEREDIT		= (1 << 22) | eUINODE_EDITBOX,
	eUINODE_RADIOBUTTON		= (1 << 23) | eUINODE_BUTTON,
	eUINODE_MULTIEDITBOX	= (1 << 24),
	eUINODE_OPTIONGAUGE		= (1 << 25) | eUINODE_WINDOW, 
	eUINODE_DRAGWINDOW		= (1 << 26) | eUINODE_WINDOW,
	eUINODE_TABSHEET		= (1 << 27) | eUINODE_WINDOW,
	eUINODE_LISTFOLDERBOX	= (1 << 28) | eUINODE_WINDOW,

	eUINODE_FORCE_32BIT	= 0x7FFFFFFF
};

/// ؽƮ  
enum eText_Align
{
	eALIGN_NONE = 0,
	eALIGN_LEFT,
	eALIGN_RIGHT,		
	eALIGN_CENTER,		
};

enum eText_Color
{
	/// ⺻ 
	eCOLOR_BLACK = 0xFF111111,
	eCOLOR_WHITE = 0xFFFFFFFF,
	eCOLOR_YELLOW = 0xFFFFFC31,
	eCOLOR_PINK = 0xFFFF50FF,
	eCOLOR_GREEN = 0xFF89F116,
	eCOLOR_SKYBLUE = 0xFF00FFEA,
	eCOLOR_RED = 0xFFF03719,
	eCOLOR_GRAY = 0xFFDCDCDC,
	eCOLOR_BLUE = 0xFF00FCFF,
	eCOLOR_ORANGE = 0xFFFFA820,
	eCOLOR_BRIGHTGREEN = 0xFFFFCF3B,
	eCOLOR_DARKGRAY = 0xFF808080,
	eCOLOR_BROWN = 0xFF808000,

	eCOLOR_DEFAULT = 0xFFE6D8BB,
	
	///   
	eCOLOR_MALL = 0xFFFFCD00,
	eCOLOR_EPIC = 0xFFFFA800,
	eCOLOR_REGEND = 0xFFD800FF,
	eCOLOR_ETC = 0xFF808080,
	eCOLOR_UNIQUE = 0xFFFFF600,
	eCOLOR_RARE = 0xFF00FFFC,
	eCOLOR_MAGIC = 0xFF00FF00,
	eCOLOR_SYSTEM = 0xFFFACD78,

	/// ä 
	eCOLOR_PARTY = 0xFF90FF00,
	eCOLOR_GUILD = 0xFFFFA300,
	eCOLOR_SHOUT = 0xFF6EBDFF,
	eCOLOR_TRADE = 0xFFFF7100,
	eCOLOR_WHISPER = 0xFFFF564D,
	eCOLOR_TIP = 0xFFEEF41E,
	eCOLOR_GM  = 0xFF32FFC6,
};

/// ڼ Ÿ 
enum eSnap_Type
{
	eSNAP_NONE,
	eSNAP_LEFT,
	eSNAP_RIGHT,
	eSNAP_TOP,
	eSNAP_BOTTOM,

	eSNAP_TOP_OUT,	/// ٱ TOP ġ ٴ°
	eSNAP_BOTTOM_OUT,
	eSNAP_RIGHT_OUT,
	eSNAP_LEFT_OUT,
};

/// UI 
/// UI  Ʈ ֻ ߻  Ŭ̴.
class cUINode
{
	friend class cUIManager;
	friend class cUIContainer;
	friend class cImeBase;

public:
	cUINode( eUINodeType type = eUINODE_NULL );
	virtual ~cUINode();

	///Ƽ ̿  ( Ƽ ̸ ش -   ְ θÿ  )
	virtual bool CreateByPropertyName( const cString& propertyName, cUIContainer* pparent, bool bTransform = false );

	///Ƽ ̿  ( ڽ츦 Ҷ  )
	virtual bool CreateByProperty( cUINodeProperty* pProperty, cUIContainer* pparent, bool bTransform = false );

	/// Ƽ, id    
	virtual bool CreateByPropertyId( cUINodeProperty* pProperty, cUIContainer* pparent, unsigned int id, bool bTransform = false );

	/// Ų ̸ ְ    
	virtual bool CreateBySkinName( const cString& skinName, cUIContainer* pparent, unsigned int id, bool bTransform = false );

	/// Ҹ
	virtual void Destroy();

	/// 
	virtual void UpdateRect();

	/// Ų 
	virtual bool ApplySkin();

	/// ػ 濡  ü Ų 
	virtual void UpdateSkin();
	
	/// 
	void SetColor( float r, float g, float b, float a );
	void SetColor( const NiColorA& color );

	/// İ
	void SetAlpha( float a );
	float GetAlpha();

	/// ̺Ʈ ó
	virtual bool HandleEvent( const cUIEvent& event );

	/// ̵
	void Move( const cUIPos& value );

	///  
	virtual void SetRelativeRect( const cUIRect& rect );
	virtual void SetRelativePos( const cUIPos& pos  );
	void SetRelativeSize( const cUISize& size );
	const cUIRect& GetRelativeRect() const;

	///  
	virtual bool ContainPoint( const cUIPos& pos ) const;
	const cUIRect& GetAbsoluteRect() const;

	///   ( ڱڽŸ  )
	virtual void Show();
	virtual void Hide();
	bool IsVisible() const;	

	/// Ȱȭ  ( ڱڽŸ  )
	virtual void SetEnabled( bool enabled );
	bool IsEnabled() const;
	
	///   ( ڱڽŸ  )
	virtual void SetPress( bool press );
	bool IsPress() const;

	/// 콺 
	void CheckEventNode();

	/// 콺 ĸó
	void SetCapture();
	void ReleaseCapture();

	/// Ŀ
	virtual void SetFocus();
	void ReleaseFocus();

	/// ȣ
	void ReleaseHover();

	/// ĸ, ȣ  Ŭ 
	void ReleaseEventNode();

	/// Ÿ
	eUINodeType GetType() const;

	/// Ų ̸
	const cString& GetSkinName() const;

	/// θ
	cUIContainer* GetParent();

	/// ̵
	int GetID() const;

	///   θ 
	bool IsKindof( eUINodeType type ) const;
	
	/// ̺Ʈ 
	static bool SendEvent( cUINode* eventHandler, eUIEventType eventType, cUINode* caller, unsigned int id, bool shift = false );

	///  ɱ
	virtual void NetLock( int lockTry = 0 );
	virtual void NetUnLock( int lockTry = 0 );
	virtual bool IsNetLock() { return mNetLock; }

	///  ui  Ǯ
	virtual void NetUnLockAllUI();

	inline void SetExceptEvent( bool set ) { mExceptionEvent = set; }
	inline bool IsExceptEvent() { return mExceptionEvent; }

	/// ش ÷װ ,  ̺Ʈ ó, 콺 ǵ
	inline void SetLClickNotifyStage( bool set ) { mLClickNotifyStage = set; }
	inline bool IsLClickNotifyStage() { return mLClickNotifyStage; }

	inline void EnableProcess( bool set ) { mProcessEnable = set; }
	inline bool IsEnableProcess() { return mProcessEnable; }

	inline void EnableBoldText( bool set ) { mUseBoldText = set; }

	inline void SetBackupVisible( bool set ) { mBackupVisible = set; }
	inline bool IsBackupVisible() { return mBackupVisible; }

protected:
	///   κе 
	bool SetupNode( cUIContainer* pparent );
	/// Ų 
	virtual bool SetSkin( const cUINodeSkin* pskin );
	///  
	virtual bool IsValid() const;

	/// ̳  ϶ ڼ ֱ
	void ApplySnap();

	///
	void SetVisible( bool visible );

	/// ȭ ũ
	static unsigned int GetScreenWidth();
	static unsigned int GetScreenHeight();

	/// Ʈ 
	static cUIRootNode* GetRoot();

	/// 콺 ĸó 
	static cUINode* GetCapture();

	/// Ŀ 
	static cUINode* GetFocus();

	/// ȣ  
	static cUINode* GetHover();
    
public:
	virtual void OnProcess( unsigned long deltaTime, unsigned long accumTime ) = 0;
	virtual void OnRender( cUIFontItemKeeper* pKeeper ) = 0;

protected:
	virtual bool OnCreate( cUINodeProperty* pproperty = 0 ) { return true; }
	virtual void OnDestroy() {}
	virtual void OnCaptureLost() {}
	virtual void OnFocusLost() {}
	virtual void OnMouseMove( const cUIPos& pos ) {}
	virtual void OnMouseWheel( const cUIPos& pos, int wheel ) {}
	virtual void OnLButtonDown( const cUIPos& pos, bool ctrl, bool alt, bool shift );
	virtual void OnRButtonDown( const cUIPos& pos, bool ctrl, bool alt, bool shift ) {}
	virtual void OnLButtonUp( const cUIPos& pos ) {}
	virtual void OnRButtonUp( const cUIPos& pos ) {}
	virtual void OnLButtonDoubleClick( const cUIPos& pos ) {}
	virtual void OnMouseHovered( const cUIPos& pos );
	virtual void OnMouseLeft( const cUIPos& pos );
	
	virtual void OnKeyDown( eKeyCode code ) {}
	virtual void OnKeyUp( eKeyCode code ) {}
	
	/// IME Messages
	virtual void OnChar( unsigned int wparam ) {}
	virtual void OnImeNotify( unsigned int wparam ) {}
	virtual void OnImeComposition( unsigned int wparam, unsigned int lparam ) {}

protected:
	/// Ÿ
	eUINodeType mType;

	/// θ
	cUIContainer* mpParent;
	
	/// Ų ̸
	cString mSkinName;

	/// ̵
	unsigned int mID;

	unsigned int mFrontID;

	///
	unsigned long mHoverTipIndex;

	///
	bool mUseTransform;

	/// ̹
	cUIImageBase* mpImage;

	///   ( θ    )
	cUIRect mRelativeRect;

	///  
	cUIRect mAbsoluteRect;

	///  
	bool mMove;

    ///  
	bool mVisible;

	/// Ȱȭ 
	bool mEnabled;

	///   
	bool mPressed;
	
	/// İ
	float mAlpha;

	/// ڼ  Ÿ 
	eSnap_Type mSnapType;

	/// ػ  ػ 
	unsigned int mOldScreenWidth;
	unsigned int mOldScreenHeight;

	/// ũƮ ⺻ ػ ( 1024 * 768 )
	unsigned int mDefaultWidth;
	unsigned int mDefaultHeight;

	/// ⺻  ( ؽƮ )
	eText_Color mDefaultColor;

	/// Ʈũ  
	bool	mNetLock;
	int		mLockTry;

	/// ̺Ʈó Ѵ.
	bool mExceptionEvent;

	/// LButton Ŭ ̺Ʈ  Ѵ.
	bool mLClickNotifyStage;

	bool mProcessEnable;

	bool mUseBoldText;

	/// npc ȭ¿  visible  
	bool mBackupVisible;
};

inline void cUINode::NetLock( int lockTry )
{
	mNetLock = true;
	mLockTry = lockTry;
	SetEnabled( false );

	if( GetCapture() == this )
		ReleaseCapture();
}

inline void cUINode::NetUnLock( int lockTry )
{
	if( IsNetLock() == false )
		return; 

	if( mLockTry == lockTry )
	{
		mNetLock = false;
		mLockTry = -1;
		SetEnabled( true );
	}
	else
	{
		assert(0);
	}
}

inline void cUINode::NetUnLockAllUI()
{
	if( mNetLock == true )
	{
		mNetLock = false;
		mLockTry = -1;
		SetEnabled( true );
	}
}

inline int cUINode::GetID() const
{
	return mID;
}

inline void cUINode::SetRelativeRect( const cUIRect& rect )
{
	mRelativeRect = rect;
	UpdateRect();
}

inline void cUINode::SetRelativePos( const cUIPos& pos  )
{
	mRelativeRect.SetPos( pos );
	UpdateRect();
}

inline void cUINode::SetRelativeSize( const cUISize& size )
{
	mRelativeRect.mRight = mRelativeRect.mLeft + size.mWidth;
	mRelativeRect.mBottom = mRelativeRect.mTop + size.mHeight;
	UpdateRect();
}

inline const cUIRect& cUINode::GetRelativeRect() const
{
	return mRelativeRect;
}

inline const cUIRect& cUINode::GetAbsoluteRect() const
{
	return mAbsoluteRect;
}

inline void cUINode::SetEnabled( bool enabled )
{
	mEnabled = enabled;
}

inline bool cUINode::IsEnabled() const
{
	return mEnabled;
}

inline float cUINode::GetAlpha()
{
	return mAlpha;
}

inline eUINodeType cUINode::GetType() const
{
	return mType;
}

inline const cString& cUINode::GetSkinName() const
{
	return mSkinName;
}

inline cUIContainer* cUINode::GetParent()
{
	return mpParent;
}

inline void cUINode::SetVisible( bool visible )
{
	mVisible = visible;
}

inline bool cUINode::IsVisible() const
{
	return mVisible;
}

inline bool cUINode::IsPress() const
{
	return mPressed;
}

inline bool cUINode::IsKindof( eUINodeType type ) const
{
	return (mType & type) == type;
}
