#include "StdAfx.h"
#include "UINodeData.h"

#include "UISkinLexer.h"
#include "UIManager.h"
#include "Parser.h"

cUINodeSkin::cUINodeSkin( eUINodeType type )
: mType( type )
, mpTexture( 0 )
, mSkinInfo(0)
{
	mSkinInfo = new sSkinInfo;

	mColor = NiColorA::WHITE;

	mDefaultColor = eCOLOR_WHITE;
}

cUINodeSkin::~cUINodeSkin()
{
	SAFE_DELETE( mSkinInfo );
}

/// ǻ :  쳪 ڽĵ Ӽ оδ
bool cUINodeSkin::ParseLine( cParser& parser, cToken& token )
{
	switch( token.mType )
	{
	case eTOKEN_IMAGEINDEX:
		{
			int i = parser.ParseInt();
			mpTexture = UIMAN->GetSkin()->GetTexture( i );

			/// ش ε ؽİ  ,
			if( !mpTexture )
			{
				assert( 0 && "error!! not exist image index" );
				return false;
			}
		}
		break;
	case eTOKEN_POS:
		{
			mSkinInfo->mX = parser.ParseInt();
			mSkinInfo->mY = parser.ParseInt();
		}
		break;
	case eTOKEN_SIZE:
		{
			mSkinInfo->mWidth = mSkinInfo->mTexWidth = parser.ParseInt();
			mSkinInfo->mHeight = mSkinInfo->mTexHeight = parser.ParseInt();
		}
		break;
	case eTOKEN_TEXPOS:
		{
			mSkinInfo->mTexX = parser.ParseInt();
			mSkinInfo->mTexY = parser.ParseInt();
		}
		break;
	case eTOKEN_TEXSIZE:
		{
			// 070424  ʿ Ű. KKR
			// UIImage ü Ȯ, ұ .
			mSkinInfo->mTexWidth = parser.ParseInt();
			mSkinInfo->mTexHeight = parser.ParseInt();
		}
		break;
	case eTOKEN_HOVERTIPINDEX:
		{
			mSkinInfo->mHoverTipIndex = parser.ParseInt();
		}
		break;
	default:
		TCHAR buffer[ 80 ];
		_stprintf( buffer, _T( "%s  %d ° ٿ " ), parser.GetFileName(), parser.GetLineNum() );
		
		assert( 0 && buffer );
		return false;
	}
	return true;
}

/// ǻ : 
bool cUINodeSkin::IsValid() const
{
	/// ȿ ˻縦 ϳ,   쿡
	///     ׳ Ʈ 
//	if( mSkinInfo->mX < 0 || mSkinInfo->mY < 0 )
//	{
//		assert( 0 && "error [x, y] value in script" );
//		return false;
//	}
	if( mSkinInfo->mTexY < 0 || mSkinInfo->mTexX < 0 )
	{
		assert( 0 && "error [texX, texY] value in script" );
		return false;
	}
	if( mSkinInfo->mWidth < 0 || mSkinInfo->mHeight < 0 )
	{
		assert( 0 && "error [size] value in script" );
		return false;
	}
	return true;
}
