/* ==========================================================================
*      : UINodeData.h
*      : 
*    : 谡
*    : 2006-12-13
* ǻ :
*===========================================================================*/
#pragma once

#include "UIRect.h"
#include "UINode.h"

class cUISkin;
class cToken;
class cParser;

struct sSkinInfo
{
	/// 1024 * 768 ػ󵵸   ġ (: ȼ)
	int mX;
	int mY;

	/// ػ󵵿   ũ (: ȼ)
	unsigned int mWidth;
	unsigned int mHeight;

	/// ؽó ̹  ġ, ũ (: ȼ)
	unsigned int mTexX;
	unsigned int mTexY;
	unsigned int mTexWidth;
	unsigned int mTexHeight;

	unsigned long	mHoverTipIndex;

	sSkinInfo()
	{
		mX = 0;
		mY = 0;

		mWidth = 0;
		mHeight = 0;

		mTexX = 0;
		mTexY = 0;
		mTexWidth = 0;
		mTexHeight = 0;

		mHoverTipIndex = 0;
	}

};

/// UI  Ų
/// UI  Ų Ʈ ֻ ߻  Ŭ̴.
class cUINodeSkin
{
	friend class cUISkin;

public:
	cUINodeSkin( eUINodeType type = eUINODE_NULL );
	virtual ~cUINodeSkin();

	/// ε
	virtual bool Load( cParser& parser ) = 0;

	/// Ÿ 
	eUINodeType GetType() const;

	///   θ 
	bool IsKindof( eUINodeType type ) const;

	///  θ 
	virtual bool IsValid() const;

protected:
	///   Ľ
	bool ParseLine( cParser& parser, cToken& token );

public:
	/// 
	NiColorA mColor;

	/// ؽó
	NiTexture* mpTexture;

	/// Ų 
	sSkinInfo* mSkinInfo;

protected:
	/// Ÿ
	eUINodeType mType;

	/// ؽƮ ⺻÷
	unsigned long mDefaultColor;
};

inline eUINodeType cUINodeSkin::GetType() const
{
	return mType;
}

inline bool cUINodeSkin::IsKindof( eUINodeType type ) const
{
	return (mType & type) == type;
}
