/* ==========================================================================
*    : ̼
*    : 2007.06.05
*      : 
* ǻ : 
*===========================================================================*/
#pragma once
#include "Lexer.h"

enum eNpcFunc;

/// Ʈ Ȳ   
struct sQuestLinkPage
{
	unsigned long newIndex;
	unsigned long playIndex;
	unsigned long completeIndex;
	unsigned long rewardIndex;

	sQuestLinkPage::sQuestLinkPage()
	{
		newIndex = 0;
		playIndex = 0;
		rewardIndex = 0;
	}
};

/// Npc   
struct sPageText;
class cPage;
class cParser;
class cUINpcTelling
{
public:
	cUINpcTelling();
	~cUINpcTelling();

	bool Load( cParser& parser );

	/// ⺻   ȹ
	sPageText* GetDefaultTextRandomly();
	unsigned long GetDefaultScene();	/// ⺻ ε 

	///
	cPage* GetPage( unsigned long pageIdx );

	/// Ʈ    
	sQuestLinkPage* GetQuestLinkPage( unsigned long questIdx );

	/// 
	int GetFuncCount() { return mFuncCount; }
	eNpcFunc GetFunc( int i );
	//eNpcFunc GetFunc() const;

	/// 
	unsigned long GetTarotIndex() { return mTarotIndex; }
	unsigned long GetTarotPrice() { return mTarotPrice; }
	short GetSpreadCount() { return mSpreadCount; }
	unsigned long* GetSpreadArr() { return mSpreadIndex; }

protected:
	bool LoadQuestLink( cParser& parser, sQuestLinkPage* linkPage );
	bool LoadPageList( cParser& parser, unsigned long& rewardIndex );
	bool LoadPage( cParser& parser, cPage* page );
	
private:
	/// ⺻   
	unsigned long mDefaultTextIndex;

	/// Ʈ   
	typedef tPointerHashMap<unsigned long, void*> cQuestLinkPage;
	cQuestLinkPage mQuestLinkPage;

	///  - ִ 5
	eNpcFunc mFunc[5];
	int	mFuncCount;

	///  ī 
	unsigned long mTarotIndex;

	/// Ÿ 
	unsigned long mTarotPrice;

	///   
	short mSpreadCount;
	unsigned long mSpreadIndex[5];
};

inline eNpcFunc cUINpcTelling::GetFunc( int i )
{
	return ( i < 5 ) ? mFunc[i] : (eNpcFunc)0;
}

//////////////////////////////////////////////////////
/// Npc ū Ÿ
enum
{
	/// Npc ȭ
	eTOKEN_NPC_TELLING = 100,

	/// 
	eTOKEN_STORE,
	eTOKEN_WAREHOUSE,
	eTOKEN_SKILLSTORE,
	eTOKEN_DISJOINT,
	eTOKEN_GUILD,
	eTOKEN_TAROT,
	eTOKEN_SPREAD,

	eTOKEN_TEXT,
	eTOKEN_PAGE,

	/// ⺻ 
	eTOKEN_DEFAULT,

	/// Ʈ
	eTOKEN_QUEST,
	eTOKEN_NEW,
	eTOKEN_PLAY,
	eTOKEN_COMPLETE,

	eTOKEN_ANSWER,
	eTOKEN_SOUND,
	eTOKEN_SCENE,

	eTOKEN_NEXT,
	eTOKEN_EVENTYES,
	eTOKEN_EVENTREWARD,
	eTOKEN_EVENTCOMPLETE,
};

/// Npc  м
class cUINpcLexer : public cLexer
{
public:
	cUINpcLexer( const char* buffer, unsigned int size );
};