#include "StdAfx.h"
#include "UIProperty.h"
#include "UISkinLexer.h"
#include "Parser.h"
#include "UINodeProperty.h"

#include "FileSystem.h"
#include "MemFile.h"

#include "ServerWindow.h"

cUIProperty::cUIProperty()
{
}

cUIProperty::~cUIProperty()
{
	Clear();
}

void cUIProperty::Clear()
{
	cNodePropertyMap::cIterator i = mNodePropertyMap.Begin();
	cNodePropertyMap::cIterator end = mNodePropertyMap.End();

	for( ; i != end; ++i )
	{
		delete (cUINodeProperty*)(*i).mSecond;
	}

	mNodePropertyMap.Clear();
}

bool cUIProperty::Load( const cString& pathName )
{
	cFileLoader loader;

	if( loader.Open( pathName, true ) == false )
	{
		return false;
	}

	cString path;
	::GetFilePath( &path, pathName );

	cToken token;
	cUISkinLexer lexer( loader.GetBufferPtr(), loader.GetSize() );
	cParser parser( &lexer, pathName );

	while( lexer.IsEnd() == false )
	{
		lexer.GetNextToken( &token );

		///   д´. "ex) uiPropertyList.txt"
		switch( token.mType )
		{
		case eTOKEN_ERROR:
			return false;
		case eTOKEN_NULL:
			continue;
		case eTOKEN_PROPERTYFILES:
			if( LoadScripts( path, parser ) == false )
			{
				return false;
			}
			break;
		default:
			assert( 0 && "invalid token" );
			return false;
		}
	}
	return true;
}

/// ǻ : 
bool cUIProperty::LoadScripts( const cString& path, cParser& parser )
{
	if( parser.ExpectTokenString( "{" ) == false )
	{
		return false;
	}

	cToken token;
	cLexer* lexer = parser.GetLexer();

	while( lexer->GetNextToken( &token ) )
	{
		if( token == "}" )
		{
			break;
		}

		if( token.mType == eTOKEN_STR )
		{
			/// path  ٿ ؿ ο  εϵ .
			cString pathName( path );
			pathName += token;

			///// Ӽ   Ľϰ 
			if( LoadScript( pathName ) == false )
			{
				assert( 0 && "failed to load script file" );
				return false;
			}
		}
		else
		{
			assert( 0 && "invalid keyword" );
			return false;
		}
	}

	///   Ӽ ȿ ˻
	cNodePropertyMap::cIterator i = mNodePropertyMap.Begin();
	cNodePropertyMap::cIterator end = mNodePropertyMap.End();

	for( ; i != end; ++i )
	{
		if( ((cUINodeProperty*)(*i).mSecond)->IsValid() == false )
		{
			assert( 0 && "found invalid node property" );
			return false;
		}
	}

	return true;
}

/// ǻ :  Ӽ   Ľϵ  
/// !!!!!! ⼭ ޸   ° Ȱ ̸
///				Ƽ Ǿ ̴. 
///				GetNodeProperty  ؼ ̹ ϴ ̸  
///				ΰ̻ Ѵٴ !!
bool cUIProperty::LoadScript( const cString& pathName )
{
	cFileLoader loader;

	if( loader.Open( pathName, true ) == false )
	{
		return false;
	}

	cToken token;
	cUISkinLexer lexer( loader.GetBufferPtr(), loader.GetSize() );
	cParser parser( &lexer, pathName );

	while( lexer.IsEnd() == false )
	{
		lexer.GetNextToken( &token );

		cString name;
		if( parser.ParseString( &name ) == false )
		{
			return false;
		}

		eUINodeType type = eUINODE_NULL;

		switch( token.mType )
		{
		case eTOKEN_ERROR:
			return false;
		case eTOKEN_NULL:
			continue;
			/// window   tabsheet Ű带   
			/// ڰ ũƮ tabsheet  ϱ ϱؼ.
		case eTOKEN_PROPERTY_TABSHEET:
			{
				type = eUINODE_TABSHEET;
			}
			break;
		case eTOKEN_PROPERTY_WINDOW:
			{
				/// ui  Ӽ
				type = eUINODE_WINDOW;
			}
			break;
		case eTOKEN_PROPERTY_CHECKBOX:
			{
				/// üũڽ Ӽ
				type = eUINODE_CHECKBOX;
			}
			break;
		case eTOKEN_PROPERTY_LABEL:
			{
				///  Ӽ
				type = eUINODE_LABEL;
			}
			break;
		case eTOKEN_PROPERTY_COMBOBOX:
			{
				/// ޺ڽ Ӽ
				type = eUINODE_COMBOBOX;
			}
			break;
		case eTOKEN_PROPERTY_PUSHBUTTON:
			{
				/// Ǫ ư Ӽ
				type = eUINODE_PUSHBUTTON;
			}
			break;
		case eTOKEN_PROPERTY_BUTTON:
			{
				/// ư Ӽ
				type = eUINODE_BUTTON;
			}
			break;
		case eTOKEN_PROPERTY_TABBUTTON:
			{
				/// ǹư Ӽ
				type = eUINODE_TABBUTTON;
			}
			break;
		case eTOKEN_PROPERTY_MULTIEDITBOX:
			{
				/// Ƽ Ʈڽ Ӽ
				type = eUINODE_MULTIEDITBOX;
			}
			break;
		case eTOKEN_PROPERTY_EDITBOX:
			{
				/// Ʈڽ Ӽ
				type = eUINODE_EDITBOX;
			}
			break;
		case eTOKEN_PROPERTY_LISTBOX:
			{
				/// Ʈڽ Ӽ
				type = eUINODE_LISTBOX;
			}
			break;
		case eTOKEN_PROPERTY_SCROLLBAR:
			{
				/// ũѹ Ӽ
				type = eUINODE_SCROLLBAR;
			}
			break;
		case eTOKEN_PROPERTY_BARBUTTON:
			{
				///  Ӽ
				type = eUINODE_BARBUTTON;
			}
			break;
		case eTOKEN_PROPERTY_SPINBOX:
			{
				/// ɹڽ Ӽ
				type = eUINODE_SPINBOX;
			}
			break;
		case eTOKEN_PROPERTY_GAUGE:
			{
				///  Ӽ
				type = eUINODE_GAUGE;
			}
			break;
		case eTOKEN_PROPERTY_GAUGETB:
			{
				type = eUINODE_GAUGETB;
			}
			break;
		case eTOKEN_PROPERTY_DOUBLEGAUGE:
			{
				type = eUINODE_DOUBLEGAUGE;
			}
			break;
		case eTOKEN_PROPERTY_TEXTBOX:
			{
				/// ؽƮڽ Ӽ
				type = eUINODE_TEXTBOX;
			}
			break;
		case eTOKEN_PROPERTY_TABWINDOW:
			{
				///  Ӽ
				type = eUINODE_TABWINDOW;
			}
			break;
		case eTOKEN_PROPERTY_NUMBEREDIT:
			{
				/// Ʈڽ Ӽ
				type = eUINODE_NUMBEREDIT;
			}
			break;
		case eTOKEN_PROPERTY_RADIOBUTTON:
			{
				/// ư Ӽ 
				type = eUINODE_RADIOBUTTON;
			}
			break;
		case eTOKEN_PROPERTY_OPTIONGAUGE:
			{
				/// ɼǰ Ӽ 
				type = eUINODE_OPTIONGAUGE;
			}
			break;
		case eTOKEN_PROPERTY_LISTFOLDERBOX:
			{
				///  Ʈڽ Ӽ
				type = eUINODE_LISTFOLDERBOX;
			}
			break;
		default:
			assert( 0 && "invalid token" );
			return false;
		}

		/// 
		cUINodeProperty* p = new cUINodeProperty( name, type );

		/// ε
		if( p->Load( parser ) == false )
		{
			delete p;
			return false;
		}

		///  Ӽ ʿ ߰
		if( mNodePropertyMap.Insert( name, p ) == false )
		{
			assert( 0 && "failed to insert ui node property, maybe already exist" );
			return false;
		}
	}
	return true;
}

/// ǻ : 
cUINodeProperty* cUIProperty::GetNodeProperty( const cString& name ) const
{
	cNodePropertyMap::cConstIterator i = mNodePropertyMap.Find( name );
	
	if( i == mNodePropertyMap.End() )	
	{
		//assert( 0 && "failed to find ui node property" );
		return 0;
	}
	return (cUINodeProperty*)(i->mSecond);
}
