/* ==========================================================================
*      : UIRect.h
*      : 
*    : ̼
*    : 2006.09.30
* ǻ : 
*===========================================================================*/
#pragma once

#include "UIPos.h"
#include "UISize.h"

#pragma warning( disable: 4201 )

/// UI  
template <class T>
class tUIRect
{
public:
	tUIRect();
	tUIRect( T left, T top, T right, T bottom );
	tUIRect( const tUIPos<T>& upperLeft, const tUIPos<T>& lowerRight );
	tUIRect( const tUIRect<T>& other );
	tUIRect( const tUIPos<T>& pos, const tUISize<T>& Size );

	/// 
	void Set( T left, T top, T right, T bottom );
	void SetPos( const tUIPos<T>& pos );

	/// Ŭ
	void ClipAgainst( const tUIRect<T>& other );

	/// ߸ κ 
	void Repair();

	///  ϴ θ 
	bool ContainPoint( const tUIPos<T>& pos ) const;

	/// ٸ  ϴ θ 
	bool IntersectRect( const tUIRect<T>& other ) const;

	/// ߽ 
	tUIPos<T> GetCenter() const;

	/// ʺ 
	T GetWidth() const;

	/// ̸ 
	T GetHeight() const;

	/// ũ⸦ 
	tUISize<T> GetSize() const;

	/// ռ θ 
	bool IsValid() const;

	const tUIRect<T>& operator = ( const tUIRect<T>& other );
	tUIRect<T> operator + ( const tUIPos<T>& pos ) const;
	const tUIRect<T>& operator += ( const tUIPos<T>& pos );
	bool operator == ( const tUIRect<T>& other ) const;
	bool operator != ( const tUIRect<T>& other ) const;

public:
	union
	{
		struct
		{
			T mLeft;
			T mTop;
			T mRight;
			T mBottom;
		};

		struct
		{
			tUIPos<T> mUpperLeft;
			tUIPos<T> mLowerRight;
		};
	};
};

template <class T> inline
tUIRect<T>::tUIRect()
: mLeft( 0 )
, mTop( 0 )
, mRight( 0 )
, mBottom( 0 )
{
}

template <class T> inline
tUIRect<T>::tUIRect( T left, T top, T right, T bottom )
{
	mLeft = left;
	mTop = top;
	mRight = right;
	mBottom = bottom;
}

template <class T> inline
tUIRect<T>::tUIRect( const tUIPos<T>& upperLeft, const tUIPos<T>& lowerRight )
: mUpperLeft( upperLeft )
, mLowerRight( lowerRight )
{
}

template <class T> inline
tUIRect<T>::tUIRect( const tUIRect<T>& other )
: mUpperLeft( other.mUpperLeft )
, mLowerRight( other.mLowerRight )
{
}

template <class T> inline
tUIRect<T>::tUIRect( const tUIPos<T>& pos, const tUISize<T>& Size )
: mUpperLeft( pos )
, mLowerRight( pos.mX + Size.mWidth, pos.mY + Size.mHeight )
{
}

template <class T> inline
void tUIRect<T>::Set( T left, T top, T right, T bottom )
{
	mLeft = left;
	mTop = top;
	mRight = right;
	mBottom = bottom;
}

template <class T> inline
void tUIRect<T>::SetPos( const tUIPos<T>& pos )
{
	tUISize<T> Size;

	Size.mWidth = GetWidth();
	Size.mHeight = GetHeight();

	mLeft = pos.mX;
	mTop = pos.mY;
	mRight = mLeft + Size.mWidth;
	mBottom = mTop + Size.mHeight;
}

template <class T> inline
void tUIRect<T>::ClipAgainst( const tUIRect<T>& other ) 
{
	if( other.mRight < mRight )
	{
		mRight = other.mRight;
	}
	if( other.mBottom < mBottom )
	{
		mBottom = other.mBottom;
	}

	if( other.mLeft > mLeft )
	{
		mLeft = other.mLeft;
	}
	if( other.mTop > mTop )
	{
		mTop = other.mTop;
	}

	if( mTop > mBottom )
	{
		mTop = mBottom;
	}
	if( mLeft > mRight )
	{
		mLeft = mRight;
	}
}

template <class T> inline
void tUIRect<T>::Repair()
{
	if( mRight < mLeft )
	{
		T t = mRight;
		mRight = mLeft;
		mLeft = t;
	}

	if( mBottom < mTop )
	{
		T t = mBottom;
		mBottom = mTop;
		mTop = t;
	}
}

template <class T> inline
bool tUIRect<T>::ContainPoint( const tUIPos<T>& pos ) const
{
	return ( mLeft <= pos.mX &&
		mTop <= pos.mY &&
		mRight >= pos.mX &&
		mBottom >= pos.mY );
}

template <class T> inline
bool tUIRect<T>::IntersectRect( const tUIRect<T>& other ) const
{
	return ( mBottom > other.mTop &&
		mTop < other.mBottom &&
		mRight > other.mLeft &&
		mLeft < other.mRight );
}

template <class T> inline
tUIPos<T> tUIRect<T>::GetCenter() const
{
	return tUIPos<T>( ( mLeft + mRight ) / 2, ( mTop + mBottom ) / 2 );
}

template <class T> inline
T tUIRect<T>::GetWidth() const
{
	return mRight - mLeft;
}

template <class T> inline
T tUIRect<T>::GetHeight() const
{
	return mBottom - mTop;
}

template <class T> inline
tUISize<T> tUIRect<T>::GetSize() const
{
	return tUISize<T>( GetWidth(), GetHeight() );
}

template <class T> inline
bool tUIRect<T>::IsValid() const
{
	T dx = mRight - mLeft;
	T dy = mBottom - mTop;

	return !( dx < 0 || dy < 0 || ( dx == 0 && dy == 0 ) );
}

template <class T> inline
const tUIRect<T>& tUIRect<T>::operator = ( const tUIRect<T>& other )
{
	mUpperLeft = other.mUpperLeft;
	mLowerRight = other.mLowerRight;
	return *this;
}

template <class T> inline
tUIRect<T> tUIRect<T>::operator + ( const tUIPos<T>& pos ) const
{
	tUIRect<T> ret( *this );
	ret.mUpperLeft += pos;
	ret.mLowerRight += pos;
	return ret;
}

template <class T> inline
const tUIRect<T>& tUIRect<T>::operator += ( const tUIPos<T>& pos )
{
	mUpperLeft += pos;
	mLowerRight += pos;
	return *this;
}

template <class T> inline
bool tUIRect<T>::operator == ( const tUIRect<T>& other ) const
{
	return ( mUpperLeft == other.mUpperLeft && mLowerRight == other.mLowerRight );
}

template <class T> inline
bool tUIRect<T>::operator != ( const tUIRect<T>& other ) const
{
	return ( mUpperLeft != other.mUpperLeft || mLowerRight != other.mLowerRight );
}
