#include "StdAfx.h"
#include "UIRootNode.h"
#include "UIWindow.h"
#include "UIManager.h"

/// ǻ : 
cUIRootNode::cUIRootNode( eUINodeType type )
: cUIContainer( type )
, mFontItemKeeper( 0 )
, mTipWindow( 0 )
{
	mpParent = 0;
	mID = 0;
	mpImage = 0;

//	mChildVisArray.Reserve( 30 );

	mRelativeRect.Set( 0, 0, GetScreenWidth(), GetScreenHeight() );
	mAbsoluteRect.Set( 0, 0, GetScreenWidth(), GetScreenHeight() );

	mVisible = true;
	mEnabled = true;

	mFontItemKeeper = new cUIFontItemKeeper;
}

/// ǻ : 
cUIRootNode::~cUIRootNode()
{
	SAFE_DELETE(mFontItemKeeper);

	mProcessList.Clear();
}

void cUIRootNode::HideAllChild( bool backupVis, cUINode* except )
{
	///  θ 
	if( backupVis )
	{
		mChildVisArray.Clear();
		mChildVisArray.Reserve( mChildList.GetSize() );

		cChildList::cIterator i = mChildList.Begin();
		cChildList::cIterator iend = mChildList.End();

		for( ; i != iend; ++i )
		{
			cUINode* n = (cUINode*)(*i);

			if( n && n != except && n->IsBackupVisible() )
			{
				if( ((cUIWindow*)n)->IsModal() == false )
				{
					mChildVisArray.PushBack( cChildVis( n, n->IsVisible() ) );
				}
			}
		}
	}

	/// 
	cChildList::cIterator i = mChildList.Begin();
	cChildList::cIterator iend = mChildList.End();

	for( ; i != iend; ++i )
	{
		cUINode* n = (cUINode*)(*i);

		if( n && n->IsKindof( eUINODE_WINDOW ) )
		{
			if( n != except && n->IsVisible() && n->IsBackupVisible() && ((cUIWindow*)n)->IsModal() == false )
			{
				cUIWindow* con = (cUIWindow*)n;
				con->Hide();	
			}
		}
		else
		{
			assert(0);
		}
	}

	///// ޼ ڽ鸸  
	//UIMAN->GotoFrontMsgBox();
}

void cUIRootNode::ShowAllChild( bool restoreVis, cUINode* except )
{
	///  θ 
	if( restoreVis )
	{
		for( unsigned int i = 0, iend = mChildVisArray.GetSize(); i < iend; ++i )
		{
			cChildVis& pair = mChildVisArray[i];
			cUINode* n = (cUINode*)pair.mFirst;
			if( !n )
			{
				assert(0);
				continue;
			}

			if( n == except )
				continue;

			if( n->IsKindof( eUINODE_WINDOW ) )
			{
				if( n != mTipWindow )
				{
					cUIWindow* con = (cUIWindow*)n;
					( pair.mSecond ) ? con->Show() : con->Hide();
				}
			}
			else
			{
				assert(0);
			}
		}

		/// Ư  
		UIMAN->RestoreShow();
	}
	else
	{
		cChildList::cIterator i = mChildList.Begin();
		cChildList::cIterator iend = mChildList.End();

		for( ; i != iend; ++i )
		{
			cUINode* n = (cUINode*)(*i);

			if( n && n->IsKindof( eUINODE_WINDOW ) )
			{
				if( n != except && n->IsVisible() == false )
				{
					cUIWindow* con = (cUIWindow*)n;
					con->Show();	
				}
			}
			else
			{
				assert(0);
			}
		}
	}
}

//void cUIRootNode::AddVisibleArr( cUINode* node, bool visible )
//{
//	for( unsigned int i = 0; i < mChildVisArray.GetSize(); ++i )
//	{
//		cChildVis& pair = mChildVisArray[i];
//		cUINode* n = (cUINode*)pair.mFirst;
//
//		if( n && n == node )
//		{
//			pair.mSecond = visible;
//			return;
//		}
//	}
//
//	mChildVisArray.PushBack( cChildVis( node, visible ) );
//}


/// ǻ : 
bool cUIRootNode::Create( const cString&, cUIContainer*, unsigned int, bool )
{
	assert( 0 );

	return true;
}

/// ǻ : 
void cUIRootNode::UpdateRect()
{
	assert( 0 );
}

void cUIRootNode::UpdateSkin()
{
	/// ػ ȭ Ʈ   
	cUIRect rc( 0, 0, GetScreenWidth(), GetScreenHeight() );
	mAbsoluteRect = rc;
	mRelativeRect = rc;

	/// ڽĿ Ų 
	cChildList::cIterator i = mChildList.Begin();
	cChildList::cIterator end = mChildList.End();

	cUINode* n = 0;
	for( ; i != end; ++i )
	{
		n = (cUINode*)(*i);
		if( n )
			n->UpdateSkin();
	}
}


/// ǻ : 
bool cUIRootNode::SetSkin( const cUINodeSkin* )
{
	return true;
}

/// ǻ : 
bool cUIRootNode::IsValid() const
{
	return true;
}

/// ǻ : 
bool cUIRootNode::HandleEvent( const cUIEvent& )
{
	return true;
}


/// ǻ : 
void cUIRootNode::OnRender( cUIFontItemKeeper* )
{
	if( mVisible )
	{
		/// ڽ 
		cChildList::cIterator i = mChildList.Begin();
		cChildList::cIterator end = mChildList.End();

		for( ; i != end; ++i )
		{
			cUINode* n = (cUINode*)(*i);

			if( n == mTipWindow )
				continue;

			if( n && n->IsVisible() == true )
				n->OnRender( mFontItemKeeper );
		}
		mFontItemKeeper->DrawAll();

		///  
		if( mTipWindow )
		{
			mTipWindow->OnRender( mFontItemKeeper );
			mFontItemKeeper->DrawAll();
		}
	}
}

/// ǻ : 
void cUIRootNode::OnProcess( unsigned long deltaTime, unsigned long accumTime )
{
	if( mVisible )
	{
		cProcessChildList::cIterator i = mProcessList.Begin();
		cProcessChildList::cIterator end = mProcessList.End();

		for( ; i != end; ++i )
		{
			cUINode* node = ( cUINode* )( *i );
			if( node )
			{
				node->OnProcess( deltaTime, accumTime );
			}
			else
			{
				assert(0);
			}
		}

/*
		/// ڽ 
		cChildList::cIterator i = mChildList.Begin();
		cChildList::cIterator end = mChildList.End();

		for( ; i != end; ++i )
		{
			cUINode* node = ( cUINode* )( *i );
			if( node )
			{
				node->OnProcess( deltaTime, accumTime );
			}
			else
				assert(0);
		}

		if( mTipWindow )
		{
			mTipWindow->OnProcess( deltaTime, accumTime );
		}
*/
	}
}

cUIContainer* cUIRootNode::GetContainer( const cUIPos& pos ) const
{
	/// ȭ  տ ڷ ˻
	cChildList::cConstIterator i = (--mChildList.End());
	cChildList::cConstIterator end = (--mChildList.Begin());

	for( ; i != end; --i )
	{
		cUINode* n = (cUINode*)(*i);
		if( !n )
		{
			assert(0);
			return 0;
		}

		if( n->IsVisible() == false )
		{
			continue;
		}

		if( n->IsKindof(eUINODE_CONTAINER) )
		{
			if( n->ContainPoint( pos ) )
			{
				return (cUIContainer*)n;
			}
		}
	}

	return 0;
}

/// 츦 ݴ´.
bool cUIRootNode::Close()
{
	/// ڽİ ϳ ־Ѵ.
	if( mChildList.GetSize() > 0 )
	{
		/// ȭ տ ڷ ˻ 
		cChildList::cConstIterator i = (--mChildList.End());
		cChildList::cConstIterator end = (--mChildList.Begin());
		
		for( ; i != end; --i )
		{
			////// nodeε ڽΰ͵  üũغ 
			cUINode* n = (cUINode*)(*i);

			/// root  ڽ ݵ ̳ʿ Ѵ. 
			if( n && n->IsKindof( eUINODE_WINDOW ) )
			{
				cUIWindow* con = (cUIWindow*)n;

				/// ݵ ϴ 鸸  óѴ 
				if( con && con->IsVisible() && con->IsHoldView() == false )
				{
					con->HideESC( true );
					return true;
				}
			}
		}
	}

	return false;
}

void cUIRootNode::NetUnLockAllUI()
{
	/// ڽİ ϳ ־Ѵ.
	if( mChildList.GetSize() > 0 )
	{
		/// ȭ տ ڷ ˻ 
		cChildList::cConstIterator i = (--mChildList.End());
		cChildList::cConstIterator end = (--mChildList.Begin());

		for( ; i != end; --i )
		{
			////// nodeε ڽΰ͵  üũغ 
			cUINode* n = (cUINode*)(*i);

			/// root  ڽ ݵ ̳ʿ Ѵ. 
			if( n && n->IsKindof( eUINODE_WINDOW ) )
			{
				cUIWindow* con = (cUIWindow*)n;

				if( con )
					con->NetUnLockAllUI();
			}
		}
	}
}

void cUIRootNode::AddProcessChild( cUINode* n )
{
	if( n->IsEnableProcess() )
		mProcessList.PushFront( n );

	if( n->IsKindof( eUINODE_CONTAINER ) == true )
	{
		cUIContainer* con = (cUIContainer*)n;
		tPointerList<void*>* plist = con->GetChildList();
		if( plist->IsEmpty() )
			return;

		tPointerList<void*>::cIterator i = plist->Begin();
		tPointerList<void*>::cIterator iend = plist->End();
		for( ; i != iend; ++i )
		{
			AddProcessChild( (cUINode*)(*i) );
		}
	}
}

void cUIRootNode::RemoveProcessChild( cUINode* n )
{
	if( n->IsEnableProcess() )
		mProcessList.Remove( n );

	if( n->IsKindof( eUINODE_CONTAINER ) == true )
	{
		cUIContainer* con = (cUIContainer*)n;
		tPointerList<void*>* plist = con->GetChildList();
		if( plist->IsEmpty() )
			return;

		tPointerList<void*>::cIterator i = plist->Begin();
		tPointerList<void*>::cIterator iend = plist->End();
		for( ; i != iend; ++i )
		{
			cUINode* p = (cUINode*)(*i);
			RemoveProcessChild( p );
		}
	}
}