#include "StdAfx.h"
#include "UISkin.h"
#include "UISkinLexer.h"
#include "Parser.h"
#include "UINodeData.h"

///
#include "Button.h"
#include "CheckBox.h"
#include "ComboBox.h"
#include "EditBox.h"
#include "Gauge.h"
#include "Icon.h"
#include "Label.h"
#include "ListBox.h"
#include "MsgBox.h"
#include "OptionGauge.h"
#include "RadioButton.h"
#include "ScrollBar.h"
#include "SpinBox.h"
#include "UIWindow.h"
#include "TextBox.h"
#include "TabWindow.h"
#include "ListFolderBox.h"

#include "FileSystem.h"
#include "MemFile.h"
#include "ResourceManager.h"
#include "TargaImage.h"
#include "BitArray.h"

cUISkin::cUISkin()
{
}

cUISkin::~cUISkin()
{
	Clear();
}

/// ǻ : 
void cUISkin::Clear()
{
	/// ؽó  
	mTextureMap.Clear();

	/// Ʈ 迭  
	{
		cBitArrayMap::cIterator i = mAlphaBitArrayMap.Begin();
		cBitArrayMap::cIterator iend = mAlphaBitArrayMap.End();

		for( ; i != iend; ++i )
		{
			delete (cBitArray*)i->mSecond;
		}

		mAlphaBitArrayMap.Clear();
	}

	///  Ų  
	{
		cNodeSkinMap::cIterator i = mNodeSkinMap.Begin();
		cNodeSkinMap::cIterator iend = mNodeSkinMap.End();

		for( ; i != iend; ++i )
		{
			delete (cUINodeSkin*)i->mSecond;
		}

		mNodeSkinMap.Clear();
	}
}

/// ǻ : 
bool cUISkin::Load( const cString& pathName )
{
	/// 
	Clear();

	///  
	cFileLoader loader;

	if( loader.Open( pathName, true ) == false )
	{
		return false;
	}

	/// Ų   
	cString path;
	::GetFilePath( &path, pathName );

	///  ְ Ľ
	cToken token;
	cUISkinLexer lexer( loader.GetBufferPtr(), loader.GetSize() );
	cParser parser( &lexer, pathName );

	while( lexer.IsEnd() == false )
	{
		lexer.GetNextToken( &token );

		switch( token.mType )
		{
		case eTOKEN_ERROR:
			return false;
		case eTOKEN_NULL:
			continue;
		case eTOKEN_IMAGES:
			{
				/// ̹ ϵ ε
				if( LoadImages( path, parser ) == false )
				{
					assert( 0 && "fail to load imagefile" );
					return false;
				}
			}
			break;
		case eTOKEN_SKINFILES:
			{
				/// ũƮ ϵ ε
				if( LoadScripts( path, parser ) == false )
				{
					assert( 0 && "fail to load script" );
					return false;
				}
			}
			break;
		default:
			assert( 0 && "invalid token" );
			return false;
		}
	}
	return true;
}

/// ǻ : 
bool cUISkin::LoadImages( const cString& , cParser& parser )
{
	if( parser.ExpectTokenString( "{" ) == false )
	{
		return false;
	}

	cToken token;
	cLexer* lexer = parser.GetLexer();

	while( lexer->GetNextToken( &token ) )
	{
		if( token == "}" )
		{
			///  Ż ^^
			break;
		}

		/// ؽó ε
		unsigned int id = token.ToInt();
		parser.ParseString( &token );

		cString pathName;
		pathName.Format( "./Data/2DData/%s", token.Cstr() );
		NiTexture* p = RESOURCEMAN->LoadTexture( pathName, false );

		if( p == 0 )
		{
			assert( 0 && "failed to load texture" );
			return false;
		}

		/// ؽó ʿ ߰
		mTextureMap.Insert( id, p );

		/// ؽó İ ִ   Ʈ 迭   ε
		cTargaImage tgaImage;
		if( tgaImage.Load( pathName ) == true && tgaImage.GetBytesPerPixel() == 4 )
		{
			cBitArray* bitArray = new cBitArray( tgaImage.GetWidth() * tgaImage.GetHeight() );
			bitArray->mWidth = tgaImage.GetWidth();
			bitArray->mHeight = tgaImage.GetHeight();
			unsigned char alpha = 0;

			for( int y = tgaImage.GetHeight()-1, i = 0; y >= 0; --y )
			{
				for( int x = 0, xend = tgaImage.GetWidth(); x < xend; ++x, ++i )
				{
					tgaImage.GetPixel( 0, 0, 0, &alpha, (unsigned int)x, (unsigned int)y );
					bitArray->Set( i, alpha > 0 );
				}
			}

			mAlphaBitArrayMap.Insert( id, bitArray );
		}
	}
	return true;
}

/// ǻ : 
bool cUISkin::LoadScripts( const cString& path, cParser& parser )
{
	if( parser.ExpectTokenString( "{" ) == false )
	{
		return false;
	}

	cToken token;
	cLexer* lexer = parser.GetLexer();

	while( lexer->GetNextToken( &token ) )
	{
		if( token == "}" )
		{
			///  Ż ^^
			break;
		}

		switch( token.mType )
		{
		case eTOKEN_STR:
			{
				cString pathName( path );
				pathName += token;

				if( LoadScript( pathName ) == false )
				{
					assert( 0 && "failed to load skin script" );
					return false;
				}
			}
			break;
		default:
			assert( 0 && "invalid token" );
			return false;
		}
	}
	
	///   Ų  ռ ˻
	cNodeSkinMap::cIterator i = mNodeSkinMap.Begin();
	cNodeSkinMap::cIterator end = mNodeSkinMap.End();

	for( ; i != end; ++i )
	{
		if( ((cUINodeSkin*)(*i).mSecond)->IsValid() == false )
		{
			assert( 0 && "found invalid node skin" );
			return false;
		}
	}
	return true;
}


/// ǻ : 
/// !!!!!! ⼭ ޸   ° Ȱ ̸
///				Ų Ǿ ̴. 
///				GetNodeSkin  ؼ ̹ ϴ ̸  
///				ΰ̻ Ѵٴ !!
bool cUISkin::LoadScript( const cString& pathName )
{
	///  ε
	cFileLoader loader;

	if( loader.Open( pathName, true ) == false )
	{
		return false;
	}

	///  ְ Ľ
	cToken token;
	cUISkinLexer lexer( loader.GetBufferPtr(), loader.GetSize() );
	cParser parser( &lexer, pathName );

	while( lexer.IsEnd() == false )
	{
		lexer.GetNextToken( &token );

		cString name;
		if( parser.ParseString( &name ) == false )
			return false;

		cUINodeSkin* p = 0;

		switch( token.mType )
		{
		case eTOKEN_ERROR:
			return false;
		case eTOKEN_NULL:
			continue;
		case eTOKEN_TABSHEET:
		case eTOKEN_WINDOW:
			{
				///  Ų 
				p = cUIWindowSkin::Create( name.Cstr() );
			}
			break;
		case eTOKEN_BARBUTTON:
			{
				p = new cButtonSkin( eUINODE_BARBUTTON );
			}
			break;
		case eTOKEN_PUSHBUTTON:
			{
				p = new cButtonSkin( eUINODE_PUSHBUTTON );
			}
			break;
		case eTOKEN_BUTTON:
			{
				p = new cButtonSkin( eUINODE_BUTTON );
			}
			break;
		case eTOKEN_TABBUTTON:
			{
				/// ư Ų 
				p = new cButtonSkin( eUINODE_TABBUTTON );
			}
			break;
		case eTOKEN_CHECKBOX:
			{
				/// üũ ڽ Ų 
				p = new cCheckBoxSkin;
			}
			break;
		case eTOKEN_LABEL:
			{
				///  Ų 
				p = new cLabelSkin;
			}
			break;
		case eTOKEN_MULTIEDITBOX:
			{
				p = new cEditBoxSkin( eUINODE_MULTIEDITBOX );
			}
			break;
		case eTOKEN_EDITBOX:
			{
				/// Ʈ Ų 
				p = new cEditBoxSkin;
			}
			break;
		case eTOKEN_LISTBOX:
		case eTOKEN_LISTFOLDERBOX:
			{
				/// Ʈ Ų 
				p = new cListBoxSkin;
			}
			break;
		case eTOKEN_SCROLLBAR:
			{
				/// ũѹ Ų 
				p = new cScrollBarSkin;
			}
			break;
		case eTOKEN_COMBOBOX:
			{
				/// ޺ڽ Ų 
				p = new cComboBoxSkin;
			}
			break;
		case eTOKEN_GAUGE:
			{
				p = new cGaugeSkin;
			}
			break;
		case eTOKEN_GAUGETB:
			{
				p = new cGaugeSkin( eUINODE_GAUGETB );
			}
			break;
		case eTOKEN_DOUBLEGAUGE:
			{
				///  Ų 
				p = new cGaugeSkin( eUINODE_DOUBLEGAUGE );
			}
			break;
		case eTOKEN_TEXTBOX:
			{
				/// ؽƮڽ Ų 
				p = new cTextBoxSkin;
			}
			break;
		case eTOKEN_TABWINDOW:
			{
				///  Ų 
				p = new cTabWindowSkin;
			}
			break;
		case eTOKEN_SPINBOX:
			{
				/// Ʈ Ų 
				p = new cSpinBoxSkin;
			}
			break;
		case eTOKEN_MESSAGEBOX:
			{
				/// ޼ ڽ Ų 
				p = new cMessageBoxSkin;
			}
			break;
		case eTOKEN_ICON:
			{
				///  Ų 
				p = new cIconSkin;
			}
			break;
		case eTOKEN_RADIOBUTTON:
			{
				///  ư Ų  
				p = new cRadioButtonSkin;
			}	
			break;
		case eTOKEN_OPTIONGAUGE:
			{	
				/// ɼ  Ų  
				p = new cOptionGaugeSkin;
			}
			break;
		default:
			assert( 0 && "invalid token" );
			return false;
		}

		/// ε
		if( p->Load( parser ) == false )
		{
			delete p;
			return false;
		}

		///  Ų ʿ ߰
		if( mNodeSkinMap.Insert( name, p ) == false )
		{
			assert( 0 && "failed to insert ui node skin, maybe already exist" );
			return false;
		}
	}
	return true;
}

///
bool cUISkin::Reload( const cString& pathName )
{
	/// ؽó  
	mTextureMap.Clear();

	///  
	cFileLoader loader;

	if( loader.Open( pathName, true ) == false )
	{
		return false;
	}

	/// Ų   
	cString path;
	::GetFilePath( &path, pathName );

	///  ְ Ľ
	cToken token;
	cUISkinLexer lexer( loader.GetBufferPtr(), loader.GetSize() );
	cParser parser( &lexer, pathName );

	while( lexer.IsEnd() == false )
	{
		lexer.GetNextToken( &token );

		switch( token.mType )
		{
		case eTOKEN_ERROR:
			return false;
		case eTOKEN_NULL:
			continue;
		case eTOKEN_IMAGES:
			{
				/// ̹ ϵ ε
				if( LoadImages( path, parser ) == false )
				{
					assert( 0 && "fail to load imagefile" );
					return false;
				}
			}
			break;
		case eTOKEN_SKINFILES:
			{
				/// ũƮ ϵ ε
				if( ReloadScripts( path, parser ) == false )
				{
					assert( 0 && "fail to load script" );
					return false;
				}
			}
			break;
		default:
			assert( 0 && "invalid token" );
			return false;
		}
	}
	return true;
}

///
bool cUISkin::ReloadScripts( const cString& path, cParser& parser )
{
	if( parser.ExpectTokenString( "{" ) == false )
	{
		return false;
	}

	cToken token;
	cLexer* lexer = parser.GetLexer();

	while( lexer->GetNextToken( &token ) )
	{
		if( token == "}" )
			break;

		switch( token.mType )
		{
		case eTOKEN_STR:
			{
				cString pathName( path );
				pathName += token;

				if( ReloadScript( pathName ) == false )
				{
					assert( 0 && "failed to Reload skin script" );
					return false;
				}
			}
			break;
		default:
			assert( 0 && "invalid token" );
			return false;
		}
	}

	///   Ų  ռ ˻
	cNodeSkinMap::cIterator i = mNodeSkinMap.Begin();
	cNodeSkinMap::cIterator end = mNodeSkinMap.End();

	for( ; i != end; ++i )
	{
		if( ((cUINodeSkin*)(*i).mSecond)->IsValid() == false )
		{
			assert( 0 && "found invalid node skin" );
			return false;
		}
	}
	return true;
}

/// ũƮ ε  ( Ų ͸ ٲ )
bool cUISkin::ReloadScript( const cString& pathName )
{
	///  ε
	cFileLoader loader;

	if( loader.Open( pathName, true ) == false )
	{
		return false;
	}

	///  ְ Ľ
	cToken token;
	cUISkinLexer lexer( loader.GetBufferPtr(), loader.GetSize() );
	cParser parser( &lexer, pathName );

	while( lexer.IsEnd() == false )
	{
		lexer.GetNextToken( &token );

		cString name;
		if( parser.ParseString( &name ) == false )
			return false;

		if( token.mType == eTOKEN_ERROR )
			return false;

		if( token.mType == eTOKEN_NULL )
			continue;

		cUINodeSkin* p = GetNodeSkin( name );
		if( p == 0 )
		{
			assert( 0 );
			return false;
		}

		/// ε
		if( p->Load( parser ) == false )
		{
			assert( 0 && "failed to update skin script" );
			return false;
		}
	}
	return true;
}

NiTexture* cUISkin::GetTexture( unsigned int id ) const
{
	cTextureMap::cConstIterator i = mTextureMap.Find( id );

	if( i == mTextureMap.End() )
	{
		return 0;
	}
	return (NiTexture*)(i->mSecond);
}

cBitArray* cUISkin::GetAlphaBitArray( unsigned int id ) const
{
	cBitArrayMap::cConstIterator i = mAlphaBitArrayMap.Find( id );

	if( i == mAlphaBitArrayMap.End() )
		return 0;
	else
		return (cBitArray*)(i->mSecond);
}

cUINodeSkin* cUISkin::GetNodeSkin( const cString& name ) const
{
	cNodeSkinMap::cConstIterator i = mNodeSkinMap.Find( name );

	if( i == mNodeSkinMap.End() )
	{
		assert( 0 && "failed to find ui node skin" );
		return 0;
	}
	return (cUINodeSkin*)(i->mSecond);
}
