/* ==========================================================================
*      : UISkin.h
*      : 
*    : ̼
*    : 2006.09.11
* ǻ : 
*===========================================================================*/
#pragma once

class cUINodeSkin;
class cParser;
class cBitArray;

/// Ų
class cUISkin
{
public:
	cUISkin();
	~cUISkin();

	/// 
	void Clear();

	/// ε
	bool Load( const cString& pathName );
	
	/// ε( Ų ٲٱ   )
	bool Reload( const cString& pathName );

	/// ؽó
	NiTexture* GetTexture( unsigned int id ) const;

	/// ĺƮ 迭
	cBitArray* GetAlphaBitArray( unsigned int id ) const;

	///  Ų
	cUINodeSkin* GetNodeSkin( const cString& name ) const;

protected:
	bool LoadImages( const cString& path, cParser& mParser );
	bool LoadScripts( const cString& path, cParser& mParser );
	bool LoadScript( const cString& pathName );

	bool ReloadScripts( const cString& path, cParser& mParser );
	bool ReloadScript( const cString& pathName );

private:
	/// ؽ 
	typedef tPointerHashMap<unsigned int, void*> cTextureMap;
	cTextureMap mTextureMap;

	///  Ʈ 迭 
	typedef tPointerHashMap<unsigned int, void*> cBitArrayMap;
	cBitArrayMap mAlphaBitArrayMap;

	///  Ų 
	typedef tPointerHashMap<cString, void*> cNodeSkinMap;
	cNodeSkinMap mNodeSkinMap;
};
