/* ==========================================================================
*      : UIWindow.h
*      : 
*    : 谡
*    : 2006.09.29
* ǻ : 
*===========================================================================*/
#pragma once
#include "UIID.h"
#include "UIContainer.h"
#include "UINodeProperty.h"
#include "BaseStage.h"

/// UI 
class cListBox;
class cUIWindow : public cUIContainer
{
public:
	cUIWindow( eUINodeType type = eUINODE_WINDOW );
	virtual ~cUIWindow();

	/// ̺Ʈ
	virtual bool HandleEvent( const cUIEvent& event );

	///   ʱȭ
	///  Խ ѹ ȴ.
	virtual bool InitWindow();

	/// ġ ʱȭ
	bool Reset();

	/// Ų 
	virtual bool SetSkin( const cUINodeSkin* pskin );

	/// 巡
	bool ContainPoint( const cUIPos& pos ) const;

	///
	virtual void ShowModal( eMSGBox_Event eventType );
	virtual void ShowTop( bool hideOthers = false, bool onsound = true );
	virtual void Show( bool onsound = true );
	virtual void Hide( bool onsound = true );

	/// ESC     ó .
	virtual void HideESC( bool onsound = true );

	///   
	virtual void Toggle();
	
	/// ĸ  ġ 
	cUIRect GetCaptionRect() const;

	///
	virtual void NetLock( int lockTry = 0 );
	virtual void NetUnLock( int lockTry = 0 );

	inline eMSGBox_Event GetEvent() { return mEventType; }
	bool IsModal() { return mModal; }

protected:
	/// ڽĻ ( Create  ٷ ȣǹǷ Ҷ ʿ ϵ ϸȴ)
	virtual bool OnCreate( cUINodeProperty* pproperty );

	/// ó
	virtual void OnProcess( unsigned long deltaTime, unsigned long accumTime );

	/// 
	virtual void OnRender( cUIFontItemKeeper* pKeeper );
	
	/// ̺Ʈ
	virtual void OnShow();
	virtual void OnHide();
	virtual void OnOk();
	virtual void OnCancel();
	virtual void OnTimer();
	virtual void OnMouseMove( const cUIPos& pos );
	virtual void OnLButtonDown( const cUIPos& pos, bool ctrl, bool alt, bool /*shiftPress*/ );
	virtual void OnLButtonUp( const cUIPos& pos );
	virtual void OnCaptureLost();
	virtual void OnNetLock( int lockTry ) {}
	virtual void OnNetUnLock( int lockTry ) {}

	/// 
	virtual void SetAlpha( float a );

	/// Ÿ̸
	void SetTimer( bool enabled, unsigned long timeout = 0 );
	bool IsTimerEnabled() const;

private:
	cUIWindow* CreateChildWindow( eUINodeType type, const cString& name );
	cListBox* CreateChildListBox( eUINodeType type, const cString& name );

protected:
	/// 巡
	bool mDragging;
	cUIPos mDragStart;
	
	/// ĸǿ 
	cUIRect mCaptionRect;

	/// Ÿ̸
	bool mTimerEnabled;
	unsigned long mTimeOut;
	unsigned long mAccumTime;
	unsigned long mLastAccumTime;

	/// 
	bool mModal;
	cBaseStage* mMsgHandler;	/// ޽ ڵ鷯
	eMSGBox_Event mEventType;	/// ޽ڽ ̺Ʈ 

	/// show  ÷  ε
	unsigned long mOpenSoundIdx;

	/// close  ÷  ε
	unsigned long mCloseSoundIdx;

	///  Ʈ 迭
	cBitArray* mAlphaBitArray;
};

inline
bool cUIWindow::IsTimerEnabled() const
{
	return mTimerEnabled;
}

////////////////////////////////////////////////////////////////////////////////////
class cBitArray;

/// UI  Ų
class cUIWindowSkin : public cUIContainerSkin
{
	friend class cUISkin;

public:
	cUIWindowSkin( eUINodeType type = eUINODE_WINDOW );
	virtual ~cUIWindowSkin();

	static cUINodeSkin*	Create( const cString& name );

	/// ε
	bool Load( cParser& parser );

public:
	///  Ʈ 迭
	cBitArray* mAlphaBitArray;

	///
	float mAlpha;

	/// ݵ ϴ   
	bool mHoldView;

	/// ĸǿ 
	cUIRect mCaptionRect;

	/// 
	unsigned long mOpenSoundIdx;
	unsigned long mCloseSoundIdx;
};
