#include "stdafx.h"
#include "UserSellSearchWindow.h"
#include "ComboBox.h"
#include "Button.h"
#include "ListBox.h"
#include "NumberEditBox.h"
#include "ItemManager.h"
#include "GameResourceManager.h"
#include "GameUIManager.h"
#include "TipWindow.h"
#include "SmallMiniMapWindow.h"
#include "MiniMapWindow.h"
#include "ItemIcon.h"
#include "FontAgent.h"
#include "Label.h"

cUserSellSearchWindow::cUserSellSearchWindow()
: mpHighCombo(0)
, mpMiddleCombo(0)
, mpLowCombo(0)
, mpNameCombo(0)
, mpEnhanceCombo(0)
, mpSearch(0)
, mpItemList(0)
, mItemIndex(0)
, mEnhance(0)
, mItemSlot(0)
, mpName(0)
{
}

cUserSellSearchWindow::~cUserSellSearchWindow()
{
	Clear();
}

void cUserSellSearchWindow::Clear()
{
	if( mpItemList )
		mpItemList->Clear();

	for( unsigned int i = 0; i < mSearchData.GetSize(); ++i )
	{
		sSearchData* p = (sSearchData*)mSearchData[i];
		if( p )
			SAFE_DELETE( p );
	}

	mSearchData.Clear();
}

void cUserSellSearchWindow::OnShow()
{
	cUIWindow::OnShow();

	if( mpHighCombo )
		mpHighCombo->SetSelect( 0 );
}

void cUserSellSearchWindow::OnHide()
{
	cUIWindow::OnHide();

	Clear();

	mEnhance = 0;
	mItemIndex = 0;

	if( mItemSlot )
	{
		mItemSlot->ChangeImage( 0 );
		mItemSlot->SetItemIndex( 0 );
		mItemSlot->SetTipType( eTOOLTIP_NONE );
	}

	if( mpName )
		mpName->Clear();
}

///
bool cUserSellSearchWindow::OnCreate( cUINodeProperty* pproperty )
{
	if( cUIWindow::OnCreate( pproperty ) == false )
		return false;

	mpHighCombo = (cComboBox*)GetChild( eUIID_GAME_USERSELLSEARCH_HIGHCOMBO );
	mpMiddleCombo = (cComboBox*)GetChild( eUIID_GAME_USERSELLSEARCH_MIDDLECOMBO );
	mpLowCombo = (cComboBox*)GetChild( eUIID_GAME_USERSELLSEARCH_LOWCOMBO );
	mpNameCombo = (cComboBox*)GetChild( eUIID_GAME_USERSELLSEARCH_NAME );
	mpEnhanceCombo = (cComboBox*)GetChild( eUIID_GAME_USERSELLSEARCH_ENHANCE );
	mpSearch = (cButton*)GetChild( eUIID_GAME_USERSELLSEARCH_SEARCH );
	mpItemList = (cListBox*)GetChild( eUIID_GAME_USERSELLSEARCH_LIST );
	mpName = (cLabel*)GetChild( eUIID_GAME_USERSELLSEARCH_ITEMNAME );

	///   
	mItemSlot = new cItemIcon;
	if( mItemSlot->CreateBySkinName( "UserSellSearch_ItemIcon", this, 1 ) == false )
		return false;

	mItemSlot->SetUsedFlag( false, false );

	/// ⺻
	SetEnhanceList();
	SetHighList();
	return true;
}


///
void cUserSellSearchWindow::OnCommand( cUINode*, unsigned int id )
{
	switch( id )
	{
	case eUIID_GAME_USERSELLSEARCH_CLOSE:
		Hide();
		break;
	case eUIID_GAME_USERSELLSEARCH_MAP:
		{
			/// ̴ϸʿ ǥϱ
			cSmallMiniMapWindow* smallmini = GAMEUI->GetSmallMinimapWindow();
			cMiniMapWindow* minimap = GAMEUI->GetMinimapWindow();
			if( !smallmini || !minimap )
				return;

			unsigned int selectRow = mpItemList->GetSelectIndex();
			sSearchData* data = (sSearchData*)mpItemList->GetExtraData( selectRow );
			if( data )
			{
				minimap->AddUserSell( data->name, data->mapnum, data->xPos, data->yPos );
				smallmini->AddUserSell( data->name, data->mapnum, data->xPos, data->yPos );
			}
		}
		break;
	case eUIID_GAME_USERSELLSEARCH_SEARCH:
		{
			/// ˻ ư
			if( mpNameCombo && mpEnhanceCombo )
			{
				mItemIndex = (unsigned long)mpNameCombo->GetSelectData();
				mEnhance = (unsigned int)mpEnhanceCombo->GetSelectData();

				if( mpEnhanceCombo->IsVisible() == true )
					ITEMMAN->TryToUserSellSearch( mItemIndex, mEnhance );
				else
					ITEMMAN->TryToUserSellSearch( mItemIndex, 0 );
			}
		}
		break;
	}
}

void cUserSellSearchWindow::OnComboSelected( cUINode* caller, unsigned int id )
{
	switch( id )
	{
	case eUIID_GAME_USERSELLSEARCH_HIGHCOMBO:
		{
			if( mpHighCombo )
			{
				unsigned int high = (unsigned int)mpHighCombo->GetSelectData();
				SelectHigh( high );
			}
		}
		break;
	case eUIID_GAME_USERSELLSEARCH_MIDDLECOMBO:
		{
			if( mpHighCombo && mpMiddleCombo )
			{
				unsigned int high = (unsigned int)mpHighCombo->GetSelectData();
				unsigned int middle = (unsigned int)mpMiddleCombo->GetSelectData();
				SelectMiddle( high, middle );
			}
		}
		break;
	case eUIID_GAME_USERSELLSEARCH_LOWCOMBO:
		{
			if( mpHighCombo && mpMiddleCombo && mpLowCombo )
			{
				unsigned int high = (unsigned int)mpHighCombo->GetSelectData();
				unsigned int middle = (unsigned int)mpMiddleCombo->GetSelectData();
				unsigned int low = (unsigned int)mpLowCombo->GetSelectData();
				SelectLow( high, middle, low );
			}
		}
		break;
	case eUIID_GAME_USERSELLSEARCH_NAME:
		{
			if( mpNameCombo && mpEnhanceCombo )
			{
				unsigned long itemIndex = (unsigned long)mpNameCombo->GetSelectData();
				cItemDefine* define = ITEMMAN->GetItemDefine( itemIndex );
				if( define )
				{
					///   
					mpName->SetText( define->GetName() );

					mItemSlot->SetItemIndex( itemIndex );
					mItemSlot->SetTipType( define->GetTipType() );
					mItemSlot->ChangeImage( define->GetIconParam() );

					mpEnhanceCombo->SetSelect( 0 );

					unsigned char type = define->GetType();
					if( !(type == ITEM_WEAPON || type == ITEM_WEAR) )
						mpEnhanceCombo->Hide();
					else
						mpEnhanceCombo->Show();
				}

			}
		}
		break;
	}
}

void cUserSellSearchWindow::OnListBoxRowHovered( cUINode* , unsigned int , const cUIPos& pos, void* )
{
	UIMAN->HideTip();
	UIMAN->ShowItemTip( eTIP_ITEM, pos, mItemIndex, mEnhance );
}

void cUserSellSearchWindow::OnListBoxRowLeft( cUINode* , unsigned int )
{
	UIMAN->HideTip();
}

void cUserSellSearchWindow::AddItem( unsigned long dbIndex, LPCTSTR charactername, unsigned long price, 
									 unsigned short mapnum, float xpos, float ypos )
{
	if( !mpItemList )
	{
		assert(0);
		return;
	}

	sSearchData* data = new sSearchData;
	data->dbIndex = dbIndex;
	data->mapnum = mapnum;
	data->name = charactername;
	data->xPos = xpos;
	data->yPos = ypos;
	mSearchData.PushBack( data );

	///  
	int row = mpItemList->AddRow( charactername, mDefaultColor, (void*)data );
	if( row != -1 )
	{
		LPCTSTR priceStr = cNumberEditBox::FormatNumber( price );
		mpItemList->AddColume( row, priceStr, mDefaultColor );

		/// ̸
		LPCTSTR mapName = GAMERESOURCEMAN->GetMapName( mapnum );
		mpItemList->AddColume( row, mapName, mDefaultColor);
	
		/// ʻ ǥ
		TCHAR temp[128] = {0,};
		int x = (int)( xpos * 0.01f );
		int y = (int)( ypos * 0.01f );

		::_stprintf( temp, _T("%d, %d"), x, y );
		mpItemList->AddColume( row, temp, mDefaultColor );
	}
	else
	{
		assert(0);
	}
}

/// з ֱ 
void cUserSellSearchWindow::SetHighList()
{
	if( !mpHighCombo )
	{
		assert(0);
		return;
	}

	///
	tArray<unsigned long>* highArr = ITEMMAN->GetHighClassArr();
	if( highArr )
	{
		for( unsigned int i=0; i< highArr->GetSize(); i++ )
		{
			unsigned long idx = (*highArr)[i];
			LPCTSTR highName = GAMERESOURCEMAN->GetCategoryName( idx );
			mpHighCombo->AddItem( highName, (void*)idx );
		}
	}
	else
	{
		assert(0);
		return;
	}

	mpHighCombo->SetSelect( 0 );
}

/// з ý ߺз 
void cUserSellSearchWindow::SelectHigh( unsigned int high )
{
	if( !mpMiddleCombo )
	{
		assert(0);
		return;
	}

	if( mpEnhanceCombo )
		mpEnhanceCombo->Hide();

	///
	mpMiddleCombo->Clear();

	tArray<unsigned long>* middleArr = ITEMMAN->GetMiddleClassArr( high );
	if( middleArr )
	{
		for( unsigned int i=0; i< middleArr->GetSize(); i++ )
		{
			unsigned long idx = (*middleArr)[i];
			LPCTSTR middleName = GAMERESOURCEMAN->GetCategoryName( idx );

			mpMiddleCombo->AddItem( middleName, (void*)idx );
		}
	}
	else
	{
		assert(0);
		return;
	}

	mpMiddleCombo->SetSelect( 0 );
}

/// Ÿ 
void cUserSellSearchWindow::SelectMiddle( unsigned int high, unsigned int middle )
{
	if( !mpLowCombo )
	{
		assert(0);
		return;
	}

	if( mpEnhanceCombo )
		mpEnhanceCombo->Hide();


	///
	mpLowCombo->Clear();

	/// Һз 
	tArray<unsigned long>* lowArr = ITEMMAN->GetLowClassArr( middle + high );
	if( lowArr )
	{
		for( unsigned int i=0; i< lowArr->GetSize(); i++ )
		{
			unsigned long idx = (*lowArr)[i];
			LPCTSTR lowName = GAMERESOURCEMAN->GetCategoryName( idx );
			mpLowCombo->AddItem( lowName, (void*)idx );
		}
	}
	else
	{
		assert(0);
		return;
	}

	mpLowCombo->SetSelect( 0 );
}	

/// Ÿ 
void cUserSellSearchWindow::SelectLow( unsigned int high, unsigned int middle, unsigned int low )
{
	if( !mpNameCombo )
	{
		assert(0);
		return;
	}

	if( mpEnhanceCombo )
		mpEnhanceCombo->Hide();

	/// ʱȭ
	mpNameCombo->Clear();


	/// ̸ 
	tArray<unsigned long>* ItemArr = ITEMMAN->GetItemCategoryArr( low + middle + high );
	if( ItemArr )
	{
		for( unsigned int i=0; i< ItemArr->GetSize(); i++ )
		{
			unsigned long idx = (*ItemArr)[i];
			LPCTSTR name = ITEMMAN->GetItemName( idx );

			mpNameCombo->AddItem( name, (void*)idx );
		}
	}
	else
	{
		assert(0);
		return;
	}

	mpNameCombo->SetSelect( 0 );
}

void cUserSellSearchWindow::SetEnhanceList()
{
	if( mpEnhanceCombo )
	{
		cStringT str;
		for( int i = 0; i <= MAX_ITEM_ENHANCED; ++i )
		{
			str.Format( GAMERESOURCEMAN->GetItemToolTipText( 2000087 ), i );
			mpEnhanceCombo->AddItem( (LPCTSTR)str.Cstr(), (void*)i );	
		}
	}
}

void cUserSellSearchWindow::OnNetLock( int lockTry )
{
	if( mpSearch )
		mpSearch->NetLock( lockTry );
}

void cUserSellSearchWindow::OnNetUnLock( int lockTry )
{
	if( mpSearch )
		mpSearch->NetUnLock( lockTry );
}