/* ==========================================================================
*      : UserSellSearchWindow.h
*      :  ˻ 
*    : 谡
*    : 2007-10-18
* ǻ :
*===========================================================================*/
#pragma once
#include "UIWindow.h"

class cComboBox;
class cButton;
class cListBox;
class cItemIcon;
class cLabel;
class cUserSellSearchWindow : public cUIWindow
{
public:
	cUserSellSearchWindow();
	virtual ~cUserSellSearchWindow();

	void Clear();
	void AddItem( unsigned long dbIndex, LPCTSTR charactername, unsigned long price,
				  unsigned short mapnum, float xpos, float ypos );

protected:
	bool OnCreate( cUINodeProperty* pproperty );
	void OnCommand( cUINode* pnode, unsigned int id );
	void OnComboSelected( cUINode* caller, unsigned int id );
	void OnListBoxRowHovered( cUINode* , unsigned int , const cUIPos& , void* );
	void OnListBoxRowLeft(cUINode* , unsigned int );
	void OnHide();
	void OnShow();
	void OnNetLock( int lockTry );
	void OnNetUnLock( int lockTry );

	void SetEnhanceList();
	void SetHighList();

	/// 
	void SelectHigh( unsigned int high );
	void SelectMiddle( unsigned int high, unsigned int middle );
	void SelectLow( unsigned int high, unsigned int middle, unsigned int low );

private:
	///  
	struct sSearchData
	{
		unsigned long	dbIndex;	
		int				mapnum;
		cStringT		name;
		float			xPos;
		float			yPos;
	};
	typedef tArray<void*> cSearchData;
	cSearchData mSearchData;

	/// з ޺
    cComboBox*	mpHighCombo;	/// з
	cComboBox*	mpMiddleCombo;	/// ߺз
	cComboBox*	mpLowCombo;		/// Һз
	cComboBox*	mpNameCombo;
	cComboBox*  mpEnhanceCombo;

	/// 
	cButton*	mpSearch;
	cListBox*	mpItemList;

	///
	unsigned long mItemIndex;
	unsigned int mEnhance;

	/// ˻Ϸ   
	cItemIcon*	mItemSlot;
	cLabel*		mpName;
};
