#include "stdafx.h"
#include "UserSellWindow.h"
#include "GameUIManager.h"

#include "MultiEditBox.h"
#include "ItemIcon.h"
#include "Button.h"
#include "NumberEditBox.h"
#include "FontAgent.h"
#include "DragWindow.h"
#include "PlaneObject.h"
#include "TipWindow.h"
#include "UIMsgboxEvent.h"

cUserSellWindow::cUserSellWindow()
: mpName(0)
, mNameSkin(0)
, mPriceSkin(0)
, mImageSkin(0)
, mpNameRegist(0)
, mpItemUpdate(0)
, mpSearch(0)
, mpEnd(0)
, mpJoinEnd(0)
, mLastSlot(0)
, mArrayIndex(0)
, mUserSellOpen( false )
, mpSelectImg(0)
, mTargetIndex(0)
, mStatus( )
{
}

cUserSellWindow::~cUserSellWindow()
{
	SAFE_DELETE( mpSelectImg );
}

/// Ŭ
void cUserSellWindow::ClearSellData( sUserSellData* data, unsigned int index )
{
	sUserSellData* p = data + index;
	p->mSlotIndex = UINT_MAX;
	p->mPrice = 0;
	p->mStatus = StallSellItemNone;
	p->mColor = mDefaultColor;
	p->mItemName.Clear();
	p->mPriceStr.Clear();

	cItemIcon* icon = p->mIcon;
	if( icon )
	{
		icon->ChangeImage( 0 );
		icon->SetTipType( eTOOLTIP_NONE );
		icon->SetItemIndex( 0 );
		icon->SetNumber( 0 );
		icon->ShowNumber( false );
	}
}

///
void cUserSellWindow::Clear()
{
	if( mpName )
		mpName->Clear();

	///  Ŭ
	if( mStatus == eUSERSELL_SELL )
	{
		if( mpName )
			mpName->SetEnabled( true );
	}
	else
	{
		if( mpName )
			mpName->SetEnabled( false );
	}

	for( unsigned int i = 0; i < MAX_STALL_ITEM; ++i )
	{
		/// Ǹ 
		sUserSellData& data = mSellData[i];

		///  Ǯ
		if( data.mSlotIndex <= MAX_INVENTORY )
		{
			cItem& invItem = ITEMMAN->GetItem( data.mSlotIndex );
			invItem.SetLock( false );
		}

		///
		ClearSellData( mSellData, i );
	}

	for( unsigned int i = 0; i < MAX_STALL_ITEM; ++i )
	{
		sUserSellData& data = mJoinData[i];

		/// κ ʱȭ
		sInventory& inv = data.mThatInven;
		inv.idx			= 0;
		inv.ItemIndex	= 0;
		inv.number		= 0;
		inv.count		= 0;
		inv.enhanced	= 0;
		inv.seal		= 0;

		ClearSellData( mJoinData, i );
	}

	mLastSlot = 0;
	mArrayIndex = 0;
	mTargetIndex = 0;
	mUserSellOpen = false;
	mShowSelect = false;
	mLockTry = eLOCK_NONE;

	SetStatus( eUSERSELL_NONE );
}

void cUserSellWindow::OnShow()
{
	cUIWindow::OnShow();

	if( mpName && mStatus == eUSERSELL_SELL )
		mpName->SetFocus();
}

///
void cUserSellWindow::OnHide()
{
	cUIWindow::OnHide();

	/// 
	Clear();
	UIMAN->HideTip();
}

///
bool cUserSellWindow::OnCreate( cUINodeProperty* pproperty )
{
	if( cUIWindow::OnCreate( pproperty ) == false )
		return false;

	mpName = (cMultiEditBox*)GetChild( eUIID_GAME_USERSELL_NAME );
	mpNameRegist = (cButton*)GetChild( eUIID_GAME_USERSELL_NAMEREGIST );
	mpItemUpdate = (cButton*)GetChild( eUIID_GAME_USERSELL_ITEMUPDATE );
	mpSearch	 = (cButton*)GetChild( eUIID_GAME_USERSELL_STORESEARCH );
	mpEnd		 = (cButton*)GetChild( eUIID_GAME_USERSELL_END );
	mpJoinEnd	 = (cButton*)GetChild( eUIID_GAME_USERSELL_JOINEND );

	cString str;
	/// ǸŻ  
	for( unsigned int i = 0; i < MAX_STALL_ITEM; ++i )
	{
		str.Format( "UserSell_SellSlot%02d", i );
		cItemIcon* icon = new cItemIcon;
		if( icon->CreateBySkinName( str, this, i ) == false )
			return false;

		icon->SetLinked( true );
		mSellData[i].mIcon = icon;
	}

	/// Ż  
	for( unsigned int i = 0; i < MAX_STALL_ITEM; ++i )
	{
		str.Format( "UserSell_JoinSlot%02d", i );
		cItemIcon* icon = new cItemIcon;
		if( icon->CreateBySkinName( str, this, i + 100 ) == false )
			return false;

		/// hover ̺Ʈ ó ̵ Ұ 
		icon->SetLinked( true );
		icon->Hide();
		mJoinData[i].mIcon = icon;
	}

	/// ġ 
	cUISkin* pSkin = UIMAN->GetSkin();
	if( pSkin )
	{
		mNameSkin = pSkin->GetNodeSkin( "UserSell_ItemName" );
		if( !mNameSkin )
			return false;

		mPriceSkin = pSkin->GetNodeSkin( "UserSell_ItemPrice" );
		if( !mPriceSkin )
			return false;

		mImageSkin = pSkin->GetNodeSkin( "UserSell_Select" );
		if( !mImageSkin )
			return false;
	}

	/// ÿ ̹ 
	if( mImageSkin->mpTexture )
	{
		/// ؽó  
		unsigned short tx = (unsigned short)mImageSkin->mSkinInfo->mTexX;
		unsigned short ty = (unsigned short)mImageSkin->mSkinInfo->mTexY;
		unsigned short tw = (unsigned short)mImageSkin->mSkinInfo->mTexWidth;
		unsigned short th = (unsigned short)mImageSkin->mSkinInfo->mTexHeight;

		mpSelectImg = new cPlaneObject;

		if( mpSelectImg->Create( mImageSkin->mpTexture, 0, 0, tw, th,
			tx, ty, tx + tw, ty + th ) == false )
		{
			assert( 0 && "failed to create select image");
			return false;
		}
	}

	/// Ǹ 
	if( pSkin )
	{
		cString str;
		cUINodeSkin* nodeSkin = 0;
		for( int i = 0; i < MAX_STALL_ITEM; ++i )
		{
			str.Format( "UserSellRect%02d", i );
			nodeSkin = pSkin->GetNodeSkin( str.Cstr() );

			unsigned short left = nodeSkin->mSkinInfo->mX;
			unsigned short right = nodeSkin->mSkinInfo->mY;
			unsigned short width = nodeSkin->mSkinInfo->mWidth;
			unsigned short height = nodeSkin->mSkinInfo->mHeight;

			mRect[i].Set( left, right, left + width, right + height );
		}
	}

	/// ⺻ 
	Clear();
	SetStatus( eUSERSELL_NONE );

	/// ̹ 
	UpdateSelect( 0 );
	return true;
}

void cUserSellWindow::OnRender( cUIFontItemKeeper* pKeeper )
{
	if( mVisible == false )
		return;

	/// ̹ 
	if( mpImage )
		mpImage->Draw();

	/// ڽ 
	cChildList::cIterator i = mChildList.Begin();
	cChildList::cIterator end = mChildList.End();

	for( ; i != end; ++i )
	{
		if( ((cUINode*)(*i))->IsVisible() == true )
		{
			((cUINode*)(*i))->OnRender(pKeeper);
		}
	}

	///  
	int posX = 0;
	int posY = 0;

	sUserSellData* data = 0;		
	if( mStatus == eUSERSELL_SELL )
		data = mSellData;
	else
		data = mJoinData;
	
	cStringT priceStr;
	for( unsigned int i = 0; i < MAX_STALL_ITEM; ++i, ++data )
	{
		cItemIcon* icon = data->mIcon;
		if( !icon )
			continue;

		cUIRect rc = icon->GetAbsoluteRect();
		
		///  ̸ 
		if( data->mItemName.IsEmpty() == false )
		{
			posX = rc.mRight + mNameSkin->mSkinInfo->mX;
			posY = rc.mTop + mNameSkin->mSkinInfo->mY;
			pKeeper->AddFontItem( cFontAgent::eFont_System, const_cast<LPTSTR>(data->mItemName.Cstr()), posX, posY, data->mColor );
		}
	
		///   
		if( data->mPriceStr.IsEmpty() == false )
		{
			if( data->mStatus == StallSellItemPause )
			{
				///  ǥ
				cStringT str = UIMAN->GetUIText( 353 );
				unsigned int width = FONTAGENT->GetTextExtent( cFontAgent::eFont_System, (LPCTSTR)str.Cstr(), str.GetSize() );
				posX = rc.mRight + mPriceSkin->mSkinInfo->mX + mPriceSkin->mSkinInfo->mWidth - width;
				posY = rc.mTop + mPriceSkin->mSkinInfo->mY;
				pKeeper->AddFontItem( cFontAgent::eFont_System, const_cast<LPTSTR>(str.Cstr()), posX, posY, mDefaultColor );
			}
			else
			{

				int textIdx  = ( icon->IsShowNumber() == true ) ? 352 : 354;
				priceStr.Format( UIMAN->GetUIText( textIdx ), (LPCTSTR)data->mPriceStr.Cstr() );

				unsigned int width = FONTAGENT->GetTextExtent( cFontAgent::eFont_System, (LPCTSTR)priceStr.Cstr(), priceStr.GetSize() );
				posX = rc.mRight + mPriceSkin->mSkinInfo->mX + mPriceSkin->mSkinInfo->mWidth - width;
				posY = rc.mTop + mPriceSkin->mSkinInfo->mY;
				pKeeper->AddFontItem( cFontAgent::eFont_System, const_cast<LPTSTR>(priceStr.Cstr()), posX, posY, mDefaultColor );
			}
		}
	}

	if( mShowSelect && mpSelectImg )
		mpSelectImg->Draw();

	pKeeper->DrawAll();
}

///
void cUserSellWindow::OnCommand( cUINode*, unsigned int id )
{
	switch( id )
	{
	case eUIID_GAME_USERSELL_CLOSE:
		if( mUserSellOpen && mStatus == eUSERSELL_SELL )
			ITEMMAN->TryToUserSellClose();
		else if( mStatus == eUSERSELL_JOIN )
			ITEMMAN->TryToUserSellJoinClose();
		else	///   ʾ
			Hide();
		break;
	case eUIID_GAME_USERSELL_NAMEREGIST:	///  
		if( mStatus == eUSERSELL_SELL )
		{
			if( mpName )
				ITEMMAN->TryToUserSellReName( mpName->GetText() );
		}
		break;
	case eUIID_GAME_USERSELL_ITEMUPDATE:	///  
		if( mStatus == eUSERSELL_SELL )
		{
			int invenSlot = GetSelectInvenSlot();
			if( invenSlot > -1 )
				ITEMMAN->TryToUserSellModify( invenSlot );
		}
		break;
	case eUIID_GAME_USERSELL_STORESEARCH:	///  ˻
		GAMEUI->ToggleUserSellSearchWindow();
		break;	
	case eUIID_GAME_USERSELL_END:			///  
		if( mUserSellOpen && mStatus == eUSERSELL_SELL )
			ITEMMAN->TryToUserSellClose();
		else if( mStatus == eUSERSELL_SELL )
			Hide();
		break;
	case eUIID_GAME_USERSELL_JOINEND:		/// ̿ 
		if( mStatus == eUSERSELL_JOIN )
			ITEMMAN->TryToUserSellJoinClose();
		break;
	}
}

void cUserSellWindow::OnIconClicked( cUINode* caller, unsigned int /*id*/ )
{
	cItemIcon* hoverIcon = (cItemIcon*)caller; 
	sUserSellData* data = ( mStatus == eUSERSELL_SELL ) ? mSellData : mJoinData;
	for( unsigned int i = 0; i < MAX_STALL_ITEM; ++i, ++data )
	{
		if( hoverIcon == data->mIcon )
		{
			UpdateSelect( i );
			break;	
		}
	}
}

void cUserSellWindow::OnIconDoubleClicked( cUINode* caller , unsigned int )
{
	cItemIcon* hoverIcon = (cItemIcon*)caller; 
	sUserSellData* data = ( mStatus == eUSERSELL_SELL ) ? mSellData : mJoinData;

	int select = -1;
	for( unsigned int i = 0; i < MAX_STALL_ITEM; ++i, ++data )
	{
		if( hoverIcon == data->mIcon )
		{
			select = i;
			break;	
		}
	}

	if( select > -1 )
		EventSelectItem( select );
}

void cUserSellWindow::OnIconDragged( cUINode* caller, unsigned int id, const cUIPos& pos, bool shift )
{
	cIcon* icon = (cIcon*)caller;
	if( icon )
		UIMAN->ShowDrag( this, DRAG_FROM_USERSELL, icon, pos, shift );
}

void cUserSellWindow::OnIconHovered( cUINode* caller, unsigned int id, const cUIPos& pos )
{
	cItemIcon* hoverIcon = (cItemIcon*)caller;
	sUserSellData* data = ( mStatus == eUSERSELL_SELL ) ? mSellData : mJoinData;
	for( unsigned int i = 0; i < MAX_STALL_ITEM; ++i, ++data )
	{
		if( hoverIcon == data->mIcon )
		{
			if( mStatus == eUSERSELL_SELL )
			{
				if( data->mSlotIndex > MAX_INVENTORY )
					continue;

				cItem& item = ITEMMAN->GetItem( data->mSlotIndex );
				UIMAN->ShowItemTip( eTIP_ITEM, pos, item.GetIndex(), data->mSlotIndex, 0 );
			}
			else
			{
				UIMAN->ShowOtherItemTip( eTIP_ITEM, pos, data->mThatInven );
			}
			break;
		}
	}
}

void cUserSellWindow::UpdateRect()
{
	cUIWindow::UpdateRect();

	if( mArrayIndex >= 0 && mpSelectImg )
	{
		mpSelectImg->SetScreenRect( mRect[mArrayIndex].mLeft + GetAbsoluteRect().mLeft, mRect[mArrayIndex].mTop + GetAbsoluteRect().mTop, 
			mRect[mArrayIndex].GetWidth(), mRect[mArrayIndex].GetHeight() );
	}
}

void cUserSellWindow::OnLButtonDown( const cUIPos& pos, bool ctrl, bool alt, bool shift )
{
	cUIWindow::OnLButtonDown( pos, ctrl, alt, shift );

	/// ã 
	int select = FindSlot( pos );

	if( select >= 0 )
		UpdateSelect( select );
}

void cUserSellWindow::OnLButtonDoubleClick( const cUIPos& pos )
{
	cUIWindow::OnLButtonDoubleClick( pos );

	/// ã 
	int select = FindSlot( pos );
	if( select > -1 )
		EventSelectItem( select );
}

/// ,  ó
void cUserSellWindow::EventSelectItem( int select )
{
	if( mStatus == eUSERSELL_SELL )
	{
		/// ϵ  
		if( mSellData[select].mSlotIndex <= MAX_INVENTORY )
		{	
			UpdateSelect( select );

			int invenSlot = GetSelectInvenSlot();
			if( invenSlot > -1 )
				ITEMMAN->TryToUserSellModify( invenSlot );
		}
	}
	else 
	{
		///  ̸
		if( mJoinData[select].mThatInven.number > 0 )
		{
			UpdateSelect( select );

			/// ̸ ԺҰ
			if( mJoinData[select].mStatus == StallSellItemPause )
				return;

			/// Կû
			unsigned int itemIndex = mJoinData[select].mThatInven.ItemIndex;
			unsigned int slotIndex = mJoinData[select].mThatInven.number;
			int maxCount = mJoinData[select].mThatInven.count;

			cItemDefine* define = ITEMMAN->GetItemDefine( itemIndex );
			if( define )
			{
				if( define->GetCapacity() > 1 )
					GAMEUI->ShowItemCountWindow( eMBEVENT_ITEMCOUNT_USERSELLBUY, slotIndex, itemIndex, maxCount );
				else
					GAMEUI->ShowItemUserSellBuyAskWindow( mJoinData[select].mThatInven.number, itemIndex, 1, 
					mJoinData[select].mPrice );
			}
			else
			{
				assert(0);
			}
		}
	}
}

/// õ  
int cUserSellWindow::FindSlot( const cUIPos& pos )
{
	int select = -1;
	for( int i = 0; i < MAX_STALL_ITEM; ++i )
	{
		cUIRect rc = mRect[i];

		rc.mLeft += GetAbsoluteRect().mLeft;
		rc.mTop += GetAbsoluteRect().mTop;
		rc.mRight = rc.mLeft + mRect[i].GetWidth();
		rc.mBottom = rc.mTop + mRect[i].GetHeight();

		if( rc.ContainPoint( pos ) == true )
		{
			select = i;
			break;
		}
	}

	return select;
}

void cUserSellWindow::UpdateSelect( unsigned short i )
{
	if( mStatus == eUSERSELL_SELL )
	{
		/// Ͱ  
		if( mSellData[i].mSlotIndex == UINT_MAX )
		{
			if( i == 0 )
				mShowSelect = false;
			return;
		}
	}
	else if( mStatus == eUSERSELL_JOIN )
	{
		/// 
		if( mJoinData[i].mThatInven.ItemIndex == 0 )
		{
			if( i == 0 )
				mShowSelect = false;
			return;
		}
	}
	else
		return;

	if( mpSelectImg )
	{
		mShowSelect = true;
		mpSelectImg->SetScreenRect( mRect[i].mLeft + GetAbsoluteRect().mLeft, mRect[i].mTop + GetAbsoluteRect().mTop, 
									mRect[i].GetWidth(), mRect[i].GetHeight() );
	}

	mArrayIndex = i;
}

///  κ   ȹ
int cUserSellWindow::GetSelectInvenSlot()
{
	if( mStatus == eUSERSELL_JOIN )
		return -1;

	if( mArrayIndex >= mLastSlot )
		return -1;

	return mSellData[mArrayIndex].mSlotIndex;
}

/// ش  ̹ ϵǾִ 
int cUserSellWindow::IsRegistSellSlot( unsigned int slot )
{
	sUserSellData* data = mSellData;
	for( unsigned int i = 0; i < mLastSlot; ++i, ++data )
	{
		if( data->mSlotIndex == slot )
			return i;
	}
	return -1;
}

/// ش  ̹ ϵǾִ 
int cUserSellWindow::IsRegistJoinSlot( unsigned int slot )
{
	sUserSellData* data = mJoinData;
	for( unsigned int i = 0; i < mLastSlot; ++i, ++data )
	{
		sInventory* inv = &data->mThatInven;
        if( inv->number == slot )
			return i;
	}
	return -1;
}

sUserSellData* cUserSellWindow::GetSelectSellData()
{
	return &mSellData[mArrayIndex];
}

sUserSellData* cUserSellWindow::GetSelectJoinData()
{
	return &mJoinData[mArrayIndex];
}

void cUserSellWindow::SetOpen()
{
	mUserSellOpen = true;
}

///  
void cUserSellWindow::SetStatus( unsigned char status )
{
	mStatus = status;

	mpName->SetEnabled( false ); 
	mpNameRegist->Hide();
	mpItemUpdate->Hide();
	mpEnd->Hide();
	mpJoinEnd->Hide();
	mpSearch->Hide();

	///  ̸
	if( status == eUSERSELL_JOIN )
	{
		mpName->SetEnabled( false );
		mpJoinEnd->Show();

		///
		for( unsigned int i = 0; i < MAX_STALL_ITEM; ++i )
		{
			sUserSellData& sellData = mSellData[i];
			if( sellData.mIcon )
				sellData.mIcon->Hide();
			
			sUserSellData& joinData = mJoinData[i];
			if( joinData.mIcon )
				joinData.mIcon->Show();
		}
	}
	/// Ǹ 
	else if( status == eUSERSELL_SELL )
	{
		mpName->SetEnabled( true );
		mpNameRegist->Show();
		mpItemUpdate->Show();
		mpEnd->Show();
		mpSearch->Show();

		///
		for( unsigned int i = 0; i < MAX_STALL_ITEM; ++i )
		{
			sUserSellData& joinData = mJoinData[i];
			if( joinData.mIcon )
				joinData.mIcon->Hide();

			sUserSellData& sellData = mSellData[i];
			if( sellData.mIcon )
				sellData.mIcon->Show();
		}
	}
}


bool cUserSellWindow::AddSellItem( unsigned int slot, unsigned long money )
{
	if( slot > MAX_INVENTORY )
		return false;

	///  
	cItem& item = ITEMMAN->GetItem( slot );
	cItemDefine* define = item.GetDefine();
	if( !define )
	{
		assert(0);
		return false;
	}

	/// ش    ̹ ϵǾ ݸ Ѵ
	int sellSlot = IsRegistSellSlot( slot );
	if( sellSlot > -1 )
	{
		mSellData[sellSlot].mPrice = money;
		mSellData[sellSlot].mPriceStr = cNumberEditBox::FormatNumber( money );
		return true;
	}

	if( mLastSlot >= MAX_STALL_ITEM )
	{
		assert(0);
		return false;
	}

	/// ɱ - κ丮 ,   
	item.SetLock( true );

	/// ÷ 
	unsigned long itemColor = eCOLOR_WHITE;
	ITEMMAN->GetTooltipColor( define->GetTipType(), itemColor );

	/// ̸ 
	TCHAR name[ITENNAME_LEN] = {0,};
	if( item.GetEnhanceStep() > 0 )
	{
		TCHAR temp[ITENNAME_LEN] = {0,};
		::_stprintf( temp, _T("+%d %s"), item.GetEnhanceStep(), define->GetName() );
		bool ret = ITEMMAN->ModifyItemName( temp, name );
		mSellData[mLastSlot].mItemName = ( ret == true ) ? name : temp;
	}
	else
	{
		bool ret = ITEMMAN->ModifyItemName( define->GetName(), name );
		mSellData[mLastSlot].mItemName = ( ret == true ) ? name : define->GetName();
	}
	 
	///  ε 
	mSellData[mLastSlot].mSlotIndex = slot;
	mSellData[mLastSlot].mPriceStr = cNumberEditBox::FormatNumber( money );
	mSellData[mLastSlot].mPrice = money;
	mSellData[mLastSlot].mColor = itemColor;
	
	/// Ǹ  ̹ 
	cItemIcon* icon = mSellData[mLastSlot].mIcon;
	if( icon )
	{
		icon->SetItemIndex( item.GetIndex() );
		icon->ChangeImage( define->GetIconParam() );
		icon->SetTipType( define->GetTipType() );
		icon->SetNumber( item.GetCount() );

		bool show = ( define->GetCapacity() > 1 ) ? true : false;
		icon->ShowNumber( show );
	}
	
	mLastSlot++;

	UpdateSelect( mArrayIndex );
	return true;
}

bool cUserSellWindow::DelSellItem( unsigned int invenSlot )
{
	UIMAN->HideTip();

	int sellSlot = IsRegistSellSlot( invenSlot );
	
	/// ɸ  Ǯ
	if( mSellData[sellSlot].mSlotIndex <= MAX_INVENTORY )
	{
		cItem& invItem = ITEMMAN->GetItem( mSellData[sellSlot].mSlotIndex );
		invItem.SetLock( false );
	}

	/// Կ 
	ClearSellData( mSellData, sellSlot );

	/// Ʈ
	UpdateData( mSellData, sellSlot, true );

	if( mLastSlot > 0 )
		mLastSlot--;

	///     Ǵٴ  .
	///      Ǹ 
	if( sellSlot <= (int)mArrayIndex && mArrayIndex > 0 )
	{
		UpdateSelect( mArrayIndex - 1 );
	}
	return true;
}

///  ν   
void cUserSellWindow::ModSellItem( unsigned int slot, unsigned int count )
{
	if( slot > MAX_INVENTORY )
		return;

	///  
	cItem& item = ITEMMAN->GetItem( slot );
	const cItemDefine* define = item.GetDefine();
	if( !define )
	{
		assert(0);
		return;
	}

	int sellSlot = IsRegistSellSlot( slot );
	if( sellSlot == -1 )
	{
		assert(0);
		return;
	}
	
	///   
	cItemIcon* icon = mSellData[sellSlot].mIcon;
	if( icon )
		icon->SetNumber( count );
}

bool cUserSellWindow::AddJoinItem( sStallSellData* sell )
{
	if( !sell )
	{
		assert(0);
		return false;
	}

	sInventory* inv = &sell->inventory;
	cItemDefine* define = ITEMMAN->GetItemDefine( inv->ItemIndex );
	if( !define )
	{
		assert(0);
		return false;
	}

	/// ش    ̹ ϵǾ ݸ Ѵ
	int joinSlot = IsRegistJoinSlot( inv->number );
	if( joinSlot > -1 )
	{
		mJoinData[joinSlot].mStatus = StallSellItemStart;
		mJoinData[joinSlot].mPrice = sell->price;
		mJoinData[joinSlot].mPriceStr = cNumberEditBox::FormatNumber( sell->price );
		mJoinData[joinSlot].mThatInven.count = inv->count;

		cItemIcon* icon = mJoinData[joinSlot].mIcon;
		if( icon )
			icon->SetNumber( inv->count );
		return true;
	}

	if( mLastSlot >= MAX_STALL_ITEM )
	{
		assert(0);
		return false;
	}

	unsigned long itemColor = eCOLOR_WHITE;
	ITEMMAN->GetTooltipColor( define->GetTipType(), itemColor );

	/// ̸ 
	TCHAR name[ITENNAME_LEN] = {0,};
	if( inv->enhanced > 0 )
	{
		TCHAR temp[ITENNAME_LEN] = {0,};
		::_stprintf( temp, _T("+%d %s"), inv->enhanced, define->GetName() );
		bool ret = ITEMMAN->ModifyItemName( temp, name );
		mJoinData[mLastSlot].mItemName = ( ret == true ) ? name : temp;
	}
	else
	{
		bool ret = ITEMMAN->ModifyItemName( define->GetName(), name );
		mJoinData[mLastSlot].mItemName = ( ret == true ) ? name : define->GetName();
	}

	///  
	sUserSellData* data = &mJoinData[mLastSlot];
	data->mThatInven = *inv;
	data->mStatus = sell->status;
	data->mPrice = sell->price;
	data->mPriceStr = cNumberEditBox::FormatNumber( sell->price );
	data->mColor = itemColor;

	///  
	cItemIcon* icon = data->mIcon;
	if( icon )
	{
		icon->SetItemIndex( inv->ItemIndex );
		icon->ChangeImage( define->GetIconParam() );
		icon->SetTipType( define->GetTipType() );
		icon->SetNumber( inv->count );

		bool show = ( define->GetCapacity() > 1 ) ? true : false;
		icon->ShowNumber( show );
	}
	
	mLastSlot++;
	return true;
}

bool cUserSellWindow::DelJoinItem( sInventory* inv )
{
	if( inv->ItemIndex == 0 )
		return false;
	
	///  ݱ
	UIMAN->HideTip();

	sUserSellData* thatItem = mJoinData;
	for( unsigned int i = 0; i < mLastSlot; ++i, ++thatItem )
	{
		sInventory& thatInv = thatItem->mThatInven;	
		if( thatInv.number == inv->number )
		{
			///   ̸, 
			thatInv.idx			= 0;
			thatInv.ItemIndex	= 0;
			thatInv.number		= 0;
			thatInv.count		= 0;
			thatInv.enhanced	= 0;
			thatInv.seal		= 0;

            ///  ʱȭ
			ClearSellData( mJoinData, i );
			
			/// Ʈ
			UpdateData( mJoinData, i, false );

			if( mLastSlot > 0 )
				mLastSlot--;

			///      Ǹ 
			if( i <= (int)mArrayIndex && mArrayIndex > 0 )
			{
				UpdateSelect( mArrayIndex - 1 );
			}

			if( mLastSlot <= 0 )
				mShowSelect = false;

			return true;
		}
	}
	return true;
}

///  ǥ
void cUserSellWindow::PauseJoinItem( sInventory* inv )
{
	int joinSlot = IsRegistJoinSlot( inv->number );
	if( joinSlot > -1 )
	{
		mJoinData[joinSlot].mStatus = StallSellItemPause;
	}
}

///  
void cUserSellWindow::UpdateData( sUserSellData* data, unsigned int index, bool enable )
{
	sUserSellData* data1 = data + index;
	sUserSellData* data2 = 0;
	
	for( unsigned int i = index; i < mLastSlot-1; ++i, ++data1 )
	{
		data2 = data1 + 1;
		data1->mSlotIndex = data2->mSlotIndex;
		data1->mColor	  = data2->mColor;
		data1->mItemName  = data2->mItemName;
		data1->mPrice	  = data2->mPrice;
		data1->mPriceStr  = data2->mPriceStr;
		data1->mStatus	  = data2->mStatus;

		data1->mThatInven = data2->mThatInven;

		/// ̹ Ʈ
		cItemIcon* icon = data1->mIcon;
		cItemIcon* nextIcon = data2->mIcon;
		if(	icon && nextIcon )
		{
			icon->ChangeImage( nextIcon->GetIconParam() );
			icon->SetItemIndex( nextIcon->GetItemIndex() );
			icon->SetTipType( nextIcon->GetTipType() );
			icon->SetNumber( nextIcon->GetNumber() );
			icon->ShowNumber( nextIcon->IsShowNumber() );
		}
	}

	///   ʱȭ
	if( mStatus == eUSERSELL_SELL )
		ClearSellData( mSellData, mLastSlot-1 );
	else
	{
		sUserSellData* data = &mJoinData[mLastSlot-1];
		sInventory& inv = data->mThatInven;
		inv.idx			= 0;
		inv.ItemIndex	= 0;
		inv.number		= 0;
		inv.count		= 0;
		inv.enhanced	= 0;
		inv.seal		= 0;

		///
		ClearSellData( mJoinData, mLastSlot-1 );
	}
}

///
void cUserSellWindow::SetName( LPCTSTR title )
{
	if( mpName )
		mpName->SetText( title );
}

bool cUserSellWindow::IsNetLock()
{
	return ( mLockTry != eLOCK_NONE );
}

void cUserSellWindow::OnNetLock( int lockTry )
{	
	switch( lockTry )
	{
	case eLOCK_REGIST:
		if( mpNameRegist )
			mpNameRegist->NetLock( lockTry );
		break;
	case eLOCK_ITEMUPDATE:
		if( mpItemUpdate )
			mpItemUpdate->NetLock( lockTry );
		break;
	case eLOCK_END:
		if( mpEnd )
			mpEnd->NetLock( lockTry );
		break;
	case eLOCK_JOINEND:
		if( mpJoinEnd )
			mpJoinEnd->NetLock( lockTry );
		break;
	}

	mLockTry = lockTry;
}

void cUserSellWindow::OnNetUnLock( int lockTry )
{
	switch( lockTry )
	{
	case eLOCK_REGIST:
		if( mpNameRegist )
			mpNameRegist->NetUnLock( lockTry );
		break;
	case eLOCK_ITEMUPDATE:
		if( mpItemUpdate )
			mpItemUpdate->NetUnLock( lockTry );
		break;
	case eLOCK_END:
		if( mpEnd )
			mpEnd->NetUnLock( lockTry );
		break;
	case eLOCK_JOINEND:
		if( mpJoinEnd )
			mpJoinEnd->NetUnLock( lockTry );
		break;
	}

	mLockTry = eLOCK_NONE;
}

