/* ==========================================================================
*      : UserSellWindow.h
*      : 
*    : 谡
*    : 2007-08-29
* ǻ :
*===========================================================================*/
#pragma once
#include "UIWindow.h"
#include "ItemIcon.h"
#include "ItemManager.h"

class cMultiEditBox;
class cItemIcon;
class cButton;
class cPlaneObject;

enum
{
	eLOCK_NONE = 0,
	eLOCK_REGIST,
	eLOCK_RENAME,
	eLOCK_ITEMUPDATE,
	eLOCK_END,
	eLOCK_JOINEND,
	eLOCK_ADD,
	eLOCK_DELETE,
	eLOCK_GET,
};

struct sUserSellData
{
	cItemIcon*	  mIcon;
	cStringT	  mPriceStr;
	cStringT	  mItemName;
	unsigned long mColor;
	unsigned long mPrice;
	
	unsigned char mStatus;			///  
	union
	{
		sInventory	 mThatInven;	///  κ
		unsigned int mSlotIndex;	/// ڽ κ  ȣ
	};

	sUserSellData()
	{
		mIcon = 0;
		mStatus = StallSellItemNone;
		mSlotIndex = UINT_MAX;
		mColor = eCOLOR_WHITE;
	}
};

enum 
{
	eUSERSELL_NONE = 0,
	eUSERSELL_SELL,			/// Ǹ 
	eUSERSELL_JOIN,			///  
};

/// ǸŻ
class cUserSellWindow : public cUIWindow
{
public:
	cUserSellWindow();
	virtual ~cUserSellWindow();

	void Clear();
	void SetStatus( unsigned char status );							///  
	
	bool AddSellItem( unsigned int slot, unsigned long money );		/// Ǹ  - 
	bool DelSellItem( unsigned int invenSlot );
	void ModSellItem( unsigned int slot, unsigned int count );

	bool AddJoinItem( sStallSellData* sell );						///   - 
	bool DelJoinItem( sInventory* inv );
	void PauseJoinItem( sInventory* inv );							/// ش  

	sUserSellData* GetSelectSellData();
	sUserSellData* GetSelectJoinData();

	/// »· 
	void SetOpen();
	bool IsOpen() { return mUserSellOpen; }

	bool IsNetLock();

	///
	void SetName( LPCTSTR title );
	void SetTargetIndex( unsigned long targetIdx );
	unsigned long GetTargetIndex() { return mTargetIndex; }

	int GetSelectInvenSlot();		///  κ ε ȹ
	int IsRegistSellSlot( unsigned int slot );
	int IsRegistJoinSlot( unsigned int slot );
	unsigned char GetStatus() { return mStatus; }

protected:
	bool OnCreate( cUINodeProperty* pproperty );
	void OnRender( cUIFontItemKeeper* pKeeper );
	void OnCommand( cUINode* pnode, unsigned int id );
	void OnLButtonDown( const cUIPos& pos, bool ctrl, bool alt, bool shift );
	void OnLButtonDoubleClick( const cUIPos& pos );
	void OnIconClicked(cUINode* caller, unsigned int );
	void OnIconDoubleClicked( cUINode* , unsigned int );
	void OnIconDragged(cUINode* caller, unsigned int, const cUIPos&, bool );
	void OnIconHovered( cUINode* caller, unsigned int id, const cUIPos& pos );
	void OnShow();
	void OnHide();
	void UpdateRect();
	void OnNetLock( int lockTry );
	void OnNetUnLock( int lockTry );

	/// ǸŰ  ʱȭ
	void ClearSellData( sUserSellData* data, unsigned int index );
	void UpdateData( sUserSellData* data, unsigned int index, bool enalbe );
	void UpdateSelect( unsigned short i );
	int FindSlot( const cUIPos& pos );	/// õ  

	/// ش   Ŭ .
	void EventSelectItem( int select );
	
private:
	///  
	unsigned char	mStatus;
	unsigned int	mLastSlot;		///  ( 0 ~ MAX_STALL_ITEM )
	
	sUserSellData	mSellData[MAX_STALL_ITEM];	/// Ǹ 
	sUserSellData	mJoinData[MAX_STALL_ITEM];	///  
	
	cUINodeSkin* mNameSkin;			///  ̸  ⺻ ġ
	cUINodeSkin* mPriceSkin;		///    ⺻ ġ
	cUINodeSkin* mImageSkin;		///   ̹

	///
	cMultiEditBox*	mpName;
	cButton*		mpNameRegist;
	cButton*		mpItemUpdate;
	cButton*		mpEnd;			/// 
	cButton*		mpSearch;
	cButton*		mpJoinEnd;		/// ̿

	/// Ǹų ϰ ִ 
	bool			mUserSellOpen;
	
	/// usersell  
	unsigned int	mArrayIndex;

	///  ̹
	bool			mShowSelect;
	cPlaneObject*	mpSelectImg;
	cUIRect			mRect[MAX_STALL_ITEM];

	/// join  ε
	unsigned long	mTargetIndex;
};

inline
void cUserSellWindow::SetTargetIndex( unsigned long targetIdx )
{
	mTargetIndex = targetIdx;
}
