/* ==========================================================================
*    : ̼
*    : 2007.02.07
*      :  迭 
* ǻ : 
*===========================================================================*/
#pragma once

class cVisibleArray;
class cCamera;

///  迭 
class cVisibleArraySorter
{
public:
	cVisibleArraySorter( cVisibleArray* array );
	virtual ~cVisibleArraySorter();

	/// 
	virtual void Sort( const cCamera& cam )=0;

	/// 
	virtual void Render() = 0;

protected:
	///  迭
	cVisibleArray* mArray;

	int mNumGeoms;
	int mMaxGeoms;

	NiGeometry** mGeoms;
	float* mDepths;
};

///   迭 
class cAlphaArraySorter : public cVisibleArraySorter
{
public:
	cAlphaArraySorter( cVisibleArray* array, cVisibleArray* testArray );
	virtual ~cAlphaArraySorter();

	/// 
	virtual void Sort( const cCamera& cam );

	/// 
	virtual void Render();


private:
	void SortObjectsByDepth( int l, int r );
	float ChoosePivot( int l, int r ) const;

	NiGeometry** mSortGeoms;
	float* mSortDepths;
	int mSortMaxGeoms;

protected:
	void SortTestGeom( const cCamera& cam );

protected:
	cVisibleArray* mTestArray;

	int mNumTestGeoms;
	int mMaxTestGeoms;

	NiGeometry** mTestGeoms;
	float* mTestDepths;
};

///   迭 
class cSolidArraySorter : public cVisibleArraySorter
{
public:
	cSolidArraySorter( cVisibleArray* array );
	virtual ~cSolidArraySorter();

	/// 
	virtual void Sort( const cCamera& cam );

	/// 
	virtual void Render();
protected:
	void SortObjectsByDepth(int l, int r);
	float ChoosePivot(int l, int r) const;
};