#include "stdafx.h"
#include "WareHouseWindow.h"
#include "PushButton.h"
#include "WareSheetWindow.h"
#include "ItemIcon.h"

#include "../Common/Item_Common.h"
#include "GameUIManager.h"
#include "Npc_Common.h"
#include "ObjectManager.h"
#include "Hero.h"
#include "UIImage.h"

#include "NumberEditBox.h"
#include "UIMsgboxEvent.h"
#include "DragWindow.h"


cWareHouseWindow::cWareHouseWindow()
: mSelectIcon(0)
, mOpen2Button(0)
, mpMoney(0)
, mpSelectImage(0)
, mShowSelect( false )
{
}

cWareHouseWindow::~cWareHouseWindow()
{
	SAFE_DELETE( mpSelectImage );
}

void cWareHouseWindow::SetOpen2Pressed( bool pressed )
{
	if( mOpen2Button )
		mOpen2Button->SetPress( pressed );
}

void cWareHouseWindow::SetMoney( unsigned long money )
{
	if( mpMoney )
		mpMoney->SetValue( money );
}

void cWareHouseWindow::OnShow()
{
	SetMoney( HERO->GetDeposit() );

	cUIWindow::OnShow();
}

bool cWareHouseWindow::OnCreate( cUINodeProperty* property )
{
	if( cTabWindow::OnCreate( property ) == false )
		return false;

	/// ǽƮ 츦 
	cWareSheetWindow* sheet = 0;
	for( unsigned int i = 0; i < TAB_COUNT; ++i )
	{
		sheet = (cWareSheetWindow*)GetChild( eUIID_WAREHOUSE_SHEET1 + i );
		if( sheet )
		{
			sheet->InitWindow( i );
			sheet->Hide();
		}
	}

	cUISkin* pSkin = UIMAN->GetSkin();
	if( !pSkin )
	{
		assert(0);
		return false;
	}

	///  ̹ 
	cUINodeSkin* selectSkin = pSkin->GetNodeSkin( "Inventory_SelectImage" );
	if( selectSkin )
	{
		mpSelectImage = new cUIImage( selectSkin->mpTexture );
		unsigned int tx = selectSkin->mSkinInfo->mTexX;
		unsigned int ty = selectSkin->mSkinInfo->mTexY;
		unsigned int w = selectSkin->mSkinInfo->mWidth;
		unsigned int h = selectSkin->mSkinInfo->mHeight;
		unsigned int x = selectSkin->mSkinInfo->mX;
		unsigned int y = selectSkin->mSkinInfo->mY;
		mpSelectImage->SetTextureRect( tx, ty, tx + w, ty + h );
		mpSelectImage->SetScreenRect( cUIRect( x, y, x + w, y + h ) );
	}

	SetCurrent(0);

	mOpen2Button = (cPushButton*)GetChild( eUIID_WAREHOUSE_OPEN2 );
	mpMoney = (cNumberEditBox*)GetChild( eUIID_WAREHOUSE_MONEY );
	return true;
}

void cWareHouseWindow::UpdateRect()
{
	cTabWindow::UpdateRect();

	if( mSelectIcon && mpSelectImage )
	{
		cUIRect rc = mSelectIcon->GetAbsoluteRect();
		mpSelectImage->SetPos( rc.mLeft-2, rc.mTop-2 );
	}
}

void cWareHouseWindow::OnRender( cUIFontItemKeeper* pKeeper )
{
	cTabWindow::OnRender( pKeeper );

	if( mShowSelect && mpSelectImage )
		mpSelectImage->Draw();
}

void cWareHouseWindow::OnCommand( cUINode* /*node*/, unsigned int id )
{
	switch( id )
	{
	case eUIID_WAREHOUSE_CLOSE:
		Hide();
		break;
	case eUIID_WAREHOUSE_INMONEY:
		/// Ա
		GAMEUI->ShowMoneyWindow( eMONEY_IN, eMBEVENT_WAREHOUSE_MONEYIN );
		break;
	case eUIID_WAREHOUSE_OUTMONEY:
		/// 
		GAMEUI->ShowMoneyWindow( eMONEY_OUT, eMBEVENT_WAREHOUSE_MONEYOUT );
		break;
	}
}

void cWareHouseWindow::OnPushButtonPressed( cUINode* /*caller*/, unsigned int id )
{
	switch( id )
	{
	case eUIID_WAREHOUSE_OPEN2:
		GAMEUI->ToggleWareHouse2Window();
		break;
	}
}

void cWareHouseWindow::OnTabButtonPressed(cUINode* caller, unsigned int id )
{
	cTabWindow::OnTabButtonPressed( caller, id );
	mShowSelect = false;
	//mShowSelect = ( id == eUIID_WAREHOUSE_PRIVATE && mSelectIcon ) ? true : false;
}

void cWareHouseWindow::OnIconClicked( cUINode* caller, unsigned int /*id*/ )
{
	UpdateSelect( (cItemIcon*)caller );
}

void cWareHouseWindow::OnHide()
{
	cUIWindow::OnHide();

	mSelectIcon = 0;
	mShowSelect = false;

	///
	UIMAN->HideDrag( this );
	UIMAN->HideNpcBack();
}

/// ο   
void cWareHouseWindow::ChangeSelect( unsigned int slotIndex )
{
	cItem& item = ITEMMAN->GetItem( slotIndex );
	cItemIcon* newIcon = item.GetIcon();
	UpdateSelect( newIcon );
}

///  õ  .
void cWareHouseWindow::UpdateSelect( cItemIcon* icon )
{
	if( icon )
	{
		unsigned int itemIdex = icon->GetItemIndex();
		if( mpSelectImage && itemIdex > 0 )
		{
			///    ȿ
			cUIRect rc = icon->GetAbsoluteRect();
			mpSelectImage->SetPos( rc.mLeft-2, rc.mTop-2 );
			mSelectIcon = icon;
			mShowSelect = true;
		}
		else
			mShowSelect = false;
	}
	else
	{
		assert(0);
	}
}


/////////////////////////////////////////////////////////////////////////////
/// â 2 
cWareHouse2Window::cWareHouse2Window( cWareHouseWindow* wareHouseWindow )
: mWareHouseWindow( wareHouseWindow )
, mSelectIcon(0)
, mpSelectImage(0)
, mShowSelect( false )
{
	assert( wareHouseWindow );

	for( int i = 0; i < WAREHOUSE_SLOT_COUNT; ++i )
		mIcon[i] = 0;
}

cWareHouse2Window::~cWareHouse2Window()
{
	SAFE_DELETE( mpSelectImage );
}

bool cWareHouse2Window::OnCreate( cUINodeProperty* property )
{
	if( cUIWindow::OnCreate( property ) == false )
		return false;
	
	///  
	cString str;
	unsigned int slotIndex = INVENTORY_WAREHOUSE1_BEGIN;

	for( unsigned int i = 0; i < WAREHOUSE_SLOT_COUNT; ++i, ++slotIndex )
	{
		str.Format( "WareSheet2_Icon%02d", i );
		cItemIcon* icon = new cItemIcon;
		if( icon->CreateBySkinName( str, this, 1 ) == false )
			return false;

		mIcon[i] = icon;
		ITEMMAN->BindIcon( slotIndex, icon );
	}

	cUISkin* pSkin = UIMAN->GetSkin();
	if( !pSkin )
	{
		assert(0);
		return false;
	}

	///  ̹ 
	cUINodeSkin* selectSkin = pSkin->GetNodeSkin( "Inventory_SelectImage" );
	if( selectSkin )
	{
		mpSelectImage = new cUIImage( selectSkin->mpTexture );
		unsigned int tx = selectSkin->mSkinInfo->mTexX;
		unsigned int ty = selectSkin->mSkinInfo->mTexY;
		unsigned int w = selectSkin->mSkinInfo->mWidth;
		unsigned int h = selectSkin->mSkinInfo->mHeight;
		unsigned int x = selectSkin->mSkinInfo->mX;
		unsigned int y = selectSkin->mSkinInfo->mY;
		mpSelectImage->SetTextureRect( tx, ty, tx + w, ty + h );
		mpSelectImage->SetScreenRect( cUIRect( x, y, x + w, y + h ) );
	}

	return true;
}

void cWareHouse2Window::UpdateRect()
{
	cUIWindow::UpdateRect();

	if( mSelectIcon && mpSelectImage )
	{
		cUIRect rc = mSelectIcon->GetAbsoluteRect();
		mpSelectImage->SetPos( rc.mLeft-2, rc.mTop-2 );
	}
}

void cWareHouse2Window::OnProcess( unsigned long deltaTime, unsigned long accumTime )
{
	if( mVisible == false )
		return;

	cUIWindow::OnProcess( deltaTime, accumTime );
}

void cWareHouse2Window::OnRender( cUIFontItemKeeper* pKeeper )
{
	cUIWindow::OnRender( pKeeper );

	if( mShowSelect && mpSelectImage )
		mpSelectImage->Draw();
}

void cWareHouse2Window::OnHide()
{
	cUIWindow::OnHide();

	mSelectIcon = 0;
	mShowSelect = false;

	if( mWareHouseWindow )
		mWareHouseWindow->SetOpen2Pressed( false );
}

void cWareHouse2Window::OnCommand( cUINode*, unsigned int id )
{
	if( id == eUIID_WAREHOUSE2_CLOSE )
		Hide();
}

void cWareHouse2Window::OnIconDragged( cUINode* caller, unsigned int id, const cUIPos& pos, bool shift )
{
	cItemIcon* icon = (cItemIcon*)caller;
	if( icon )
		UIMAN->ShowDrag( this, DRAG_FROM_INVENTORY, icon, pos, shift );
}

void cWareHouse2Window::OnIconClicked( cUINode* caller, unsigned int id )
{
	/// â 1   ̺Ʈ
	UpdateSelect( (cItemIcon*)caller );
}

/// ο   
void cWareHouse2Window::ChangeSelect( unsigned int slotIndex )
{
	cItem& item = ITEMMAN->GetItem( slotIndex );
	cItemIcon* newIcon = item.GetIcon();
	UpdateSelect( newIcon );
}

///  õ  .
void cWareHouse2Window::UpdateSelect( cItemIcon* icon )
{
	if( icon )
	{
		unsigned int itemIdex = icon->GetItemIndex();
		if( mpSelectImage && itemIdex > 0 )
		{
			///    ȿ
			cUIRect rc = icon->GetAbsoluteRect();
			mpSelectImage->SetPos( rc.mLeft-2, rc.mTop-2 );
			mSelectIcon = icon;
			mShowSelect = true;
		}
		else
			mShowSelect = false;
	}
	else
	{
		assert(0);
	}
}
