#include "stdafx.h"
#include "WareSheetWindow.h"

#include "../Common/Item_Common.h"
#include "GameUIManager.h"
#include "ItemManager.h"
#include "DragWindow.h"
#include "ItemIcon.h"

cWareSheetWindow::cWareSheetWindow( eUINodeType type )
: cUIWindow( type )
, mTabIndex( 0 )
{
	for( int i = 0; i < WAREHOUSE_SLOT_COUNT; ++i )
		mIcon[i] = 0;
}

cWareSheetWindow::~cWareSheetWindow()
{
}

void cWareSheetWindow::InitWindow( unsigned int tabIndex )
{
	mTabIndex = tabIndex;

	///  
	cString str;
	unsigned int slotIndex = 0;

	switch( mTabIndex )
	{
	case 0:
		slotIndex = INVENTORY_WAREHOUSE0_BEGIN;
		break;
	case 1:
		slotIndex = INVENTORY_WAREHOUSE2_BEGIN;
		break;
	case 2:
		slotIndex = INVENTORY_WAREHOUSE1_BEGIN;
		break;
	default:
		assert( 0 && "tab index out of range" );
		return;
	}

	for( unsigned int i = 0; i < WAREHOUSE_SLOT_COUNT; ++i, ++slotIndex )
	{
		str.Format( "WareSheet_Icon%02d", i );
		cItemIcon* icon = new cItemIcon;
		if( icon->CreateBySkinName( str, this, 1 ) == false )
			return;

		mIcon[i] = icon;
		ITEMMAN->BindIcon( slotIndex, icon );
	}
}

bool cWareSheetWindow::OnCreate( cUINodeProperty* property )
{
	if( cUIWindow::OnCreate( property ) == false )
		return false;
	return true;
}

void cWareSheetWindow::OnIconDragged( cUINode* caller, unsigned int id, const cUIPos& pos, bool shift )
{
	cItemIcon* icon = (cItemIcon*)caller;
	if( icon )
		UIMAN->ShowDrag( (cUIWindow*)mpParent, DRAG_FROM_INVENTORY, icon, pos, shift );
}

void cWareSheetWindow::OnIconClicked( cUINode* caller, unsigned int id )
{
	/// â쿡   ̺Ʈ
	if( caller )
		SendEvent( mpParent, eUIEVENT_ICON_CLICKED, caller, id );
}