/* ====================================================================
 *      :	WorldManager.h
 *      :	ȯ濡 õ  ü  Ѵ.
 *    :	̹
 *    :	2006.01
 *
 * ߰ :
 *		߰¥ 	۾		߰
 *		2006.01     ̹	    
 * 
 * ǻ :	
 * =================================================================== */
#pragma once

class cPathFinder;
class cTerrain;
class cNaviMesh;
class cNaviField;

class cMaterialData;
class cSceneNode;
class cAreaSceneNode;

///  
class cWorldManager
{
	static cWorldManager* mSingleton;

public:
	cWorldManager();
	~cWorldManager();

	/// ʱȭ  
	bool Init();
	void Exit();

	/// ó
	void Process( unsigned long deltaTime, unsigned long accumTime );
	void ProcessAmbient( unsigned long deltaTime );
	void ProcessFog( unsigned long deltaTime );
	void ProcessCamera( unsigned long deltaTime );

	/// 
	void Render();
	void RenderSkyDome();

	///      ı
	bool Open();
	void Close();
	void ClearSkyDome();

	/// ϴ
	bool LoadSkydome( const cString& pathName, float scale );
	void MoveSkyDome( const NiPoint3& pos );

	/// 
	void SetArea( const cAreaSceneNode& n );
	void BlendArea( const cAreaSceneNode& n0, const cAreaSceneNode& n1, float ratio );

	/// ŷ
	bool Pick( NiPoint3* pos, int mouseX, int mouseY );
	
	/// ̰
	bool CalcHeight( float* height, float posX, float posY );

	bool EnableMove( int mouseX, int mouseY );

	/// Map Index
	inline unsigned int			GetCurrentMapIndex()						{ return mCurrentMapIndex; }
	inline void					SetCurrentMapIndex( unsigned int mapIdx )	{ mCurrentMapIndex = mapIdx; }

	///  
	cTerrain* GetTerrain() const;
	cNaviField* GetNaviField() const;
	cNaviMesh* GetNaviMesh() const;
    cPathFinder* GetPathFinder() const;

	/// load process  Լ
	bool LoadTerrainHeader( unsigned int mapIdx );
	int LoadTerrainNodes( unsigned int count );
	bool LoadNaviMeshHeader( unsigned int mapIdx );
	int LoadNaviMeshNodes( unsigned int count );
	bool LoadNaviField( unsigned int mapIdx );

protected:
	///   
	void CollectGeometries( tList<void*>* pgeomList, NiAVObject* pobj );
	void CollectProperties( tList<void*>* ppropList, NiAVObject* pobj );
	void SetMaterial( tList<void*>& propList, const cMaterialData& material );

	/// ü Ѵ.
	void DisableZBuffer( NiAVObject* pObj );
	void RecursivePrepack( NiAVObject* pObj );

public:
	/// ü 
	static cWorldManager* GetSingleton();

private:
	///  ε
	unsigned int mCurrentMapIndex;

	/// ã
	cPathFinder* mPathFinder;

	/// 
	cTerrain* mTerrain;

	/// ׺޽
	cNaviMesh* mNaviMesh;

	/// ׺ʵ
	cNaviField* mNaviField;

	/// ϴ
	NiNodePtr mSkyDome;
	cString mSkyPathName;

	typedef tList<void*> cGeomList;
	cGeomList mSkyGeomList;

	typedef tList<void*> cMatPropList;
	cMatPropList mSkyMatPropList;

	float mSkyHeight;
	bool mSkyNeedUpdate;

	/// ֺ
	NiColor mTargetSkyAmbient;
	NiColor mSkyAmbient;
	float mTargetSkyDimmer;
	float mSkyDimmer;
	NiColor mTargetTerrainAmbient;
	NiColor mTerrainAmbient;
	float mTargetTerrainDimmer;
	float mTerrainDimmer;
	NiColor mTargetStaticObjectAmbient;
	NiColor mStaticObjectAmbient;
	float mTargetStaticObjectDimmer;
	float mStaticObjectDimmer;
	NiColor mTargetDynamicObjectAmbient;
	NiColor mDynamicObjectAmbient;
	float mTargetDynamicObjectDimmer;
	float mDynamicObjectDimmer;

	/// Ȱ
	NiColor mTargetFogColor;
	NiColor mFogColor;
	float mTargetFogDepth;
	float mFogDepth;

	/// 浹 迭
	typedef tArray<void*> cCollidableArray;
	cCollidableArray mCollidableArray;

	cAreaSceneNode* mArea1;
	cAreaSceneNode* mArea2;
};

inline
cTerrain* cWorldManager::GetTerrain() const
{
	return mTerrain;
}

inline
cNaviMesh* cWorldManager::GetNaviMesh() const
{
	return mNaviMesh;
}

inline
cNaviField* cWorldManager::GetNaviField() const
{
	return mNaviField;
}

inline
cPathFinder* cWorldManager::GetPathFinder() const
{
	return mPathFinder;
}

inline
cWorldManager* cWorldManager::GetSingleton()
{
	return mSingleton;
}

#define WORLDMAN cWorldManager::GetSingleton()
