#include "stdafx.h"

// TODO: ʿ ߰ 
//   ƴ STDAFX.H մϴ.

void GameErrorLog( char* format, ... )
{
	LPVOID  msgBuf = NULL;
	DWORD   bufferLength;

	va_list args;

	va_start( args, format );

	bufferLength = _vscprintf( format, args ) + 1;
	msgBuf       = malloc( bufferLength );

	vsprintf( (char*)msgBuf, format, args );

	va_end( args );

	if ( msgBuf != NULL )
	{
		FILE*      stream = NULL;
		char       filename[ MAX_PATH ];
		SYSTEMTIME systemtime;
		char       buffer[ 1024 ];

		GetLocalTime( &systemtime );

		sprintf( filename,
			"GameLog_%04d_%02d_%02d.log",
			systemtime.wYear,
			systemtime.wMonth,
			systemtime.wDay );

		stream = fopen( filename, "at" );
		if ( stream != NULL )
		{
			sprintf( buffer,
				"%04d %02d %02d::%02d %02d %02d : %s\n",
				systemtime.wYear,
				systemtime.wMonth,
				systemtime.wDay,
				systemtime.wHour,
				systemtime.wMinute,
				systemtime.wSecond,
				(char*)msgBuf );

			fputs( buffer, stream );
			fclose( stream );
		}

		free( msgBuf );
	}
}

int ConvertToUnicode( const char* str, wchar_t* uniStr, unsigned int buffersize )
{
	size_t len = ::strlen(str);
	if( len == 0 )
		return 0;

	int iLen = ::MultiByteToWideChar( CP_ACP, MB_PRECOMPOSED, str, len, NULL, 0 );
	if (iLen > 0)
	{
		assert( iLen+1 < (int)buffersize );
		iLen = ::MultiByteToWideChar(CP_ACP, MB_PRECOMPOSED, str, -1, (LPWSTR)uniStr, iLen+1 );
		assert(iLen != 0);
	}
	else
	{
		iLen --; // return -1
	}
	return iLen;
}

int ConvertToAscii( const wchar_t* uniStr, char* str, unsigned int buffersize )
{
	size_t wideLen = ::wcslen(uniStr);
	if (wideLen == 0)
		return 0;

	// iLen does not include terminating character
	int iLen = ::WideCharToMultiByte(CP_ACP, 0, uniStr, (int)wideLen, (LPSTR)str, 0, NULL, NULL);
	if (iLen > 0)
	{
		assert( iLen+1 < (int)buffersize );
		iLen = ::WideCharToMultiByte(CP_ACP, 0, uniStr , (int)-1, (LPSTR)str, iLen+1, NULL, NULL);
		assert(iLen != 0);
	}
	else
	{
		iLen --;
	}
	return iLen;
}

void Sstrncat( LPTSTR pDest, unsigned int destMaxLen, LPCTSTR pSrc, unsigned int count )
{
	assert( count < destMaxLen -_tcslen(pDest) );
	::_tcsncat( pDest, pSrc, __min(count, destMaxLen -_tcslen(pDest)) );
}

void Sstrncpy( LPTSTR pDest, unsigned int destMaxLen, LPCTSTR pSrc, unsigned int count )
{
	assert( count < destMaxLen );
	unsigned int n = __min(count, destMaxLen);

	::_tcsncpy( pDest, pSrc, n );
	pDest[n] = 0;
}