/* ====================================================================
 *      :	AppTimer.h
 *      :	ø̼ ⺻ Ÿ̸ Ŭ
 *    :	̹
 *    :	2005.12
 * ǻ :	
 * =================================================================== */
#pragma once

#include "sqltypes.h"

/// ø̼ Ÿ̸
class cAppTimer
{
	static cAppTimer* mpSingleton;

public:
	cAppTimer();
	~cAppTimer();

	/// Ÿ̸   
	void Start();
	void Stop();

	/// 缳
	void Reset();

	///
	void Advance();

	// get the absolute system time
	unsigned long GetAbsoluteTime();

	// get the current time
	unsigned long GetCurrentTime();

	// get the time that elapsed between GetElapsedTime() calls
	unsigned long GetDeltaTime();

	inline bool IsStopped() { return mTimerStopped; }

	///  ǻ  ð踦 
	TIMESTAMP_STRUCT GetRealTime();
	///  ǻ  ð迡 sec(:)  ð踦 
	TIMESTAMP_STRUCT GetRealPlusTime( unsigned long sec );

	/// TIMESTAMP_STRUCT  ð  time_t ȯ
	tm ConvertTStoTM( TIMESTAMP_STRUCT timestamp );
	TIMESTAMP_STRUCT ConvertTMtoTS( tm datetime );

	/// time_t  ð  TIMESTAMP_STRUCT ȯ
	//TIMESTAMP_STRUCT ConvertTMtoTS( time_t datetime );

	///  ð Էµ ð (:/1000) ȯѴ.
	unsigned long DiffRealTime( TIMESTAMP_STRUCT timestamp );

public:
	/// ü 
	static cAppTimer* GetSingleton();

private:
	/// QueryPerformanceFrequency  
	bool	mUsingQPF;

	///
	bool	mTimerStopped;

	/// QueryPerformanceCounter..
	LONGLONG		mllQPFTicksPerSec;

	LONGLONG		mllStopTime;
	LONGLONG		mllLastElapsedTime;
	LONGLONG		mllBaseTime;

	/// TimeGetTime..
	unsigned long	mLastElapsedTime;
	unsigned long	mBaseTime;
	unsigned long	mStopTime;

//	double			mLastElapsedTime;
//	double			mBaseTime;
//	double			mStopTime;

};

inline cAppTimer* cAppTimer::GetSingleton()
{
	return mpSingleton;
}

#define TIMER	cAppTimer::GetSingleton()
