#include "StdAfx.h"
#include ".\communityscript.h"

#include "FileLoader.h"
#include "Tokenizer.h"

cCommunityScript* cCommunityScript::mpCommunityScript = NULL;


cCommunityScript::cCommunityScript()
{
	mpCommunityScript = this;
}

cCommunityScript::~cCommunityScript() 
{
	Release();
}

void cCommunityScript::Release()
{
	cComHashMap::cIterator iter;

	for(iter = mComSkillMap.Begin() ; iter != mComSkillMap.End() ; ++iter)
	{
		delete (sCommunitySkillInfo*)(*iter).mSecond;
	}
	mComSkillMap.Clear();
}

bool cCommunityScript::Init()
{
	Release();

	/// script load
#ifdef _CLIENT
	if( CommunitySkillScriptLoad_Client() == false )
#else
	if( CommunitySkillScriptLoad_Server() == false )
#endif
	{
		assert(0);
		return false;
	}

	return true;
}

#ifdef _CLIENT
bool cCommunityScript::CommunitySkillScriptLoad_Client()
{
	cFileLoader loader;
	cString pathName = "./Script/resource/CommunitySkillList.txt";

	if( loader.Open( pathName, true ) == false )
	{
		assert( 0 && "failed to load CommunitySkillList.txt" );
		return false;
	}

	cTokenizer tokenizer( loader.GetBufferPtr(), loader.GetSize(), " \t\r\n", pathName.Cstr() );
	cString str;

	sCommunitySkillInfo* pInfo = 0;
	while( tokenizer.IsEnd() == false )
	{
		pInfo = new sCommunitySkillInfo;

		/// з ȣ
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pInfo->mIndex = str.ToInt();

		/// Ÿ 0:Ȱ, 1:
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pInfo->mType = static_cast<unsigned char>(str.ToInt());

		/// type  ɾ 
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pInfo->mRoleIndex = str.ToInt();

		/// ųâ ǥ  ȣ
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pInfo->mIconIndex = str.ToInt();

		/// ä ɾ ε ( interface msg )
		for( unsigned int i=0; i<5; i++ )
		{
			if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
			pInfo->mCommandIndex[i] = str.ToInt();
		}

		///  ε ( tooltip msg )
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pInfo->mTooltipIndex = str.ToInt();

		///  ǥ ġ
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pInfo->mPosX = str.ToInt();

		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pInfo->mPosY = str.ToInt();

		for( unsigned int i=0;i<eGENDER_MAX * eRACE_MAX; i++ )
		{
			if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
			pInfo->mAnimationTime[i] = str.ToFloat();
		}

		///  
		if( mComSkillMap.Insert( pInfo->mIndex, pInfo ) == false )
		{
			assert(0);
			goto ERR;
		}
	}
	return true;

ERR:
	delete pInfo;
	return false;
}
#endif

bool cCommunityScript::CommunitySkillScriptLoad_Server()
{
	cFileLoader loader;
	cString pathName = "./Script/resource/CommunitySkillList.txt";

	if( loader.Open( pathName, true ) == false )
	{
		assert( 0 && "failed to load CommunitySkillList.txt" );
		return false;
	}

	cTokenizer tokenizer( loader.GetBufferPtr(), loader.GetSize(), " \t\r\n", pathName.Cstr() );
	cString str;

	sCommunitySkillInfo* pInfo = 0;
	while( tokenizer.IsEnd() == false )
	{
		pInfo = new sCommunitySkillInfo;

		/// з ȣ
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pInfo->mIndex = str.ToInt();

		/// Ÿ 0:Ȱ, 1:
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pInfo->mType = static_cast<unsigned char>(str.ToInt());

		// skip value
		//////////////////////////////////////////////////////////////////////////
		/// type  ɾ 
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		/// ųâ ǥ  ȣ
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		/// ä ɾ ε ( interface msg )
		for( unsigned int i=0; i<5; i++ )
			if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }

		///  ε ( tooltip msg )
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		///  ǥ ġ
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		//////////////////////////////////////////////////////////////////////////

		for( unsigned int i=0;i<eGENDER_MAX * eRACE_MAX; i++ )
		{
			if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
			pInfo->mAnimationTime[i] = str.ToFloat();
		}

		///  
		if( mComSkillMap.Insert( pInfo->mIndex, pInfo ) == false )
		{
			assert(0);
			goto ERR;
		}
	}
	return true;

ERR:
	delete pInfo;
	return false;
}

